/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rplatform.serializer;

import org.bukkit.util.BoundingBox;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;

public class BoundingBoxSerializer {
    private static final String DELIMITER = ",";
    private static final int EXPECTED_PARTS = 6;

    @NotNull
    public BoundingBox deserialize(@NotNull String serialized) {
        String[] parts = serialized.split(DELIMITER);
        if (parts.length != 6) {
            throw new IllegalArgumentException("Invalid bounding box format: " + serialized);
        }
        try {
            double minX = Double.parseDouble(parts[0].trim());
            double minY = Double.parseDouble(parts[1].trim());
            double minZ = Double.parseDouble(parts[2].trim());
            double maxX = Double.parseDouble(parts[3].trim());
            double maxY = Double.parseDouble(parts[4].trim());
            double maxZ = Double.parseDouble(parts[5].trim());
            return BoundingBox.of((Vector)new Vector(minX, minY, minZ), (Vector)new Vector(maxX, maxY, maxZ));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid number format in bounding box: " + serialized, e);
        }
    }

    @NotNull
    public String serialize(@NotNull BoundingBox boundingBox) {
        return String.format("%s,%s,%s,%s,%s,%s", boundingBox.getMinX(), boundingBox.getMinY(), boundingBox.getMinZ(), boundingBox.getMaxX(), boundingBox.getMaxY(), boundingBox.getMaxZ());
    }
}

