/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rplatform.scheduler.impl;

import com.raindropcentral.rplatform.scheduler.ISchedulerAdapter;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class FoliaISchedulerImpl
implements ISchedulerAdapter {
    private static final Logger LOG = Logger.getLogger("RPlatform");
    private final JavaPlugin plugin;

    public FoliaISchedulerImpl(@NotNull JavaPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public void runSync(@NotNull Runnable task) {
        this.runGlobal(task);
    }

    @Override
    public void runAsync(@NotNull Runnable task) {
        CompletableFuture.runAsync(this.safe(task));
    }

    @Override
    public void runDelayed(@NotNull Runnable task, long delayTicks) {
        Object global = this.getGlobalScheduler();
        if (!this.tryInvoke(global, "runDelayed", new Class[]{JavaPlugin.class, Consumer.class, Long.TYPE}, new Object[]{this.plugin, this.toConsumer(task), delayTicks})) {
            this.tryInvoke(global, "runAtFixedRate", new Class[]{JavaPlugin.class, Consumer.class, Long.TYPE, Long.TYPE}, new Object[]{this.plugin, this.toConsumer(task), delayTicks, 0x1FFFFFFFFFFFFFFFL});
        }
    }

    @Override
    public void runRepeating(@NotNull Runnable task, long delayTicks, long periodTicks) {
        Object global = this.getGlobalScheduler();
        if (!this.tryInvoke(global, "runAtFixedRate", new Class[]{JavaPlugin.class, Consumer.class, Long.TYPE, Long.TYPE}, new Object[]{this.plugin, this.toConsumer(task), delayTicks, periodTicks})) {
            this.runDelayed(() -> this.runRepeating(task, periodTicks, periodTicks), delayTicks);
        }
    }

    @Override
    public void runAtEntity(@NotNull Entity entity, @NotNull Runnable task) {
        Object entityScheduler = this.getEntityScheduler(entity);
        if (!this.tryInvoke(entityScheduler, "run", new Class[]{Consumer.class}, new Object[]{this.toConsumer(task)})) {
            this.tryInvoke(entityScheduler, "runDelayed", new Class[]{Consumer.class, Long.TYPE}, new Object[]{this.toConsumer(task), 0L});
        }
    }

    @Override
    public void runAtLocation(@NotNull Location location, @NotNull Runnable task) {
        Object region = this.getRegionScheduler();
        if (!this.tryInvoke(region, "run", new Class[]{JavaPlugin.class, Location.class, Consumer.class}, new Object[]{this.plugin, location, this.toConsumer(task)})) {
            this.runGlobal(task);
        }
    }

    @Override
    public void runGlobal(@NotNull Runnable task) {
        Object global = this.getGlobalScheduler();
        if (!this.tryInvoke(global, "run", new Class[]{JavaPlugin.class, Consumer.class}, new Object[]{this.plugin, this.toConsumer(task)})) {
            this.safe(task).run();
        }
    }

    @Override
    @NotNull
    public CompletableFuture<Void> runAsyncFuture(@NotNull Runnable task) {
        return CompletableFuture.runAsync(this.safe(task));
    }

    private Object getGlobalScheduler() {
        try {
            Method m = Bukkit.class.getMethod("getGlobalRegionScheduler", new Class[0]);
            return m.invoke(null, new Object[0]);
        }
        catch (Throwable t) {
            LOG.log(Level.SEVERE, "[Scheduler/Folia] GlobalRegionScheduler not available", t);
            return null;
        }
    }

    private Object getRegionScheduler() {
        try {
            Method m = Bukkit.class.getMethod("getRegionScheduler", new Class[0]);
            return m.invoke(null, new Object[0]);
        }
        catch (Throwable t) {
            LOG.log(Level.SEVERE, "[Scheduler/Folia] RegionScheduler not available", t);
            return null;
        }
    }

    private Object getEntityScheduler(Entity entity) {
        try {
            Method m = entity.getClass().getMethod("getScheduler", new Class[0]);
            return m.invoke((Object)entity, new Object[0]);
        }
        catch (Throwable t) {
            LOG.log(Level.SEVERE, "[Scheduler/Folia] EntityScheduler not available for " + String.valueOf(entity), t);
            return null;
        }
    }

    private boolean tryInvoke(Object target, String methodName, Class<?>[] paramTypes, Object[] args) {
        if (target == null) {
            return false;
        }
        try {
            Method m = this.findMethod(target.getClass(), methodName, paramTypes);
            if (m == null) {
                return false;
            }
            m.invoke(target, args);
            return true;
        }
        catch (InvocationTargetException ite) {
            LOG.log(Level.SEVERE, "[Scheduler/Folia] Invocation failed for " + methodName, ite.getTargetException());
            return false;
        }
        catch (Throwable t) {
            LOG.log(Level.SEVERE, "[Scheduler/Folia] Invocation failed for " + methodName, t);
            return false;
        }
    }

    private Method findMethod(Class<?> clazz, String name, Class<?>[] paramTypes) {
        try {
            return clazz.getMethod(name, paramTypes);
        }
        catch (NoSuchMethodException e) {
            for (Method m : clazz.getMethods()) {
                if (!m.getName().equals(name) || m.getParameterCount() != paramTypes.length) continue;
                return m;
            }
            return null;
        }
    }

    private Object toConsumer(Runnable runnable) {
        Objects.requireNonNull(runnable, "runnable");
        return Proxy.newProxyInstance(Consumer.class.getClassLoader(), new Class[]{Consumer.class}, (proxy, method, args) -> {
            if ("accept".equals(method.getName()) && method.getParameterCount() == 1) {
                this.safe(runnable).run();
                return null;
            }
            if ("andThen".equals(method.getName())) {
                Object next = args != null && args.length == 1 ? args[0] : null;
                return Proxy.newProxyInstance(Consumer.class.getClassLoader(), new Class[]{Consumer.class}, (p2, m2, a2) -> {
                    if ("accept".equals(m2.getName()) && m2.getParameterCount() == 1) {
                        this.safe(runnable).run();
                        if (next instanceof Consumer) {
                            Consumer c = (Consumer)next;
                            try {
                                c.accept(a2 != null ? a2[0] : null);
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                        return null;
                    }
                    return MethodHandles.lookup().unreflect(m2).bindTo(p2).invokeWithArguments(a2);
                });
            }
            return MethodHandles.lookup().unreflect(method).bindTo(proxy).invokeWithArguments(args);
        });
    }

    private Runnable safe(Runnable task) {
        return () -> {
            try {
                task.run();
            }
            catch (Throwable t) {
                LOG.log(Level.SEVERE, "[Scheduler/Folia] Task failed", t);
                throw t;
            }
        };
    }
}

