/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rplatform.scheduler.impl;

import com.raindropcentral.rplatform.scheduler.ISchedulerAdapter;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class BukkitISchedulerImpl
implements ISchedulerAdapter {
    private static final Logger LOG = Logger.getLogger("RPlatform");
    private final JavaPlugin plugin;

    public BukkitISchedulerImpl(@NotNull JavaPlugin plugin) {
        this.plugin = Objects.requireNonNull(plugin, "plugin");
    }

    @Override
    public void runSync(@NotNull Runnable task) {
        Bukkit.getScheduler().runTask((Plugin)this.plugin, this.safe(task));
    }

    @Override
    public void runAsync(@NotNull Runnable task) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, this.safe(task));
    }

    @Override
    public void runDelayed(@NotNull Runnable task, long delayTicks) {
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, this.safe(task), delayTicks);
    }

    @Override
    public void runRepeating(@NotNull Runnable task, long delayTicks, long periodTicks) {
        Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, this.safe(task), delayTicks, periodTicks);
    }

    @Override
    public void runAtEntity(@NotNull Entity entity, @NotNull Runnable task) {
        this.runSync(task);
    }

    @Override
    public void runAtLocation(@NotNull Location location, @NotNull Runnable task) {
        this.runSync(task);
    }

    @Override
    public void runGlobal(@NotNull Runnable task) {
        this.runSync(task);
    }

    @Override
    @NotNull
    public CompletableFuture<Void> runAsyncFuture(@NotNull Runnable task) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            try {
                task.run();
                future.complete(null);
            }
            catch (Throwable t) {
                LOG.log(Level.SEVERE, "[Scheduler] Async task failed", t);
                future.completeExceptionally(t);
            }
        });
        return future;
    }

    private Runnable safe(Runnable task) {
        Objects.requireNonNull(task, "task");
        return () -> {
            try {
                task.run();
            }
            catch (Throwable t) {
                LOG.log(Level.SEVERE, "[Scheduler] Task failed", t);
                throw t;
            }
        };
    }
}

