/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rplatform.scheduler;

import com.raindropcentral.rplatform.api.PlatformType;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public interface ISchedulerAdapter {
    public void runSync(@NotNull Runnable var1);

    public void runAsync(@NotNull Runnable var1);

    public void runDelayed(@NotNull Runnable var1, long var2);

    public void runRepeating(@NotNull Runnable var1, long var2, long var4);

    public void runAtEntity(@NotNull Entity var1, @NotNull Runnable var2);

    public void runAtLocation(@NotNull Location var1, @NotNull Runnable var2);

    public void runGlobal(@NotNull Runnable var1);

    @NotNull
    public CompletableFuture<Void> runAsyncFuture(@NotNull Runnable var1);

    @NotNull
    public static ISchedulerAdapter create(@NotNull JavaPlugin plugin, @NotNull PlatformType platformType) {
        return switch (platformType) {
            default -> throw new MatchException(null, null);
            case PlatformType.FOLIA -> ISchedulerAdapter.createFoliaScheduler(plugin);
            case PlatformType.PAPER, PlatformType.SPIGOT -> ISchedulerAdapter.createBukkitScheduler(plugin);
        };
    }

    @NotNull
    private static ISchedulerAdapter createFoliaScheduler(@NotNull JavaPlugin plugin) {
        try {
            Class<?> clazz = Class.forName("com.raindropcentral.rplatform.scheduler.impl.FoliaISchedulerImpl");
            return (ISchedulerAdapter)clazz.getConstructor(JavaPlugin.class).newInstance(plugin);
        }
        catch (Exception e) {
            return ISchedulerAdapter.createBukkitScheduler(plugin);
        }
    }

    @NotNull
    private static ISchedulerAdapter createBukkitScheduler(@NotNull JavaPlugin plugin) {
        try {
            Class<?> clazz = Class.forName("com.raindropcentral.rplatform.scheduler.impl.BukkitISchedulerImpl");
            return (ISchedulerAdapter)clazz.getConstructor(JavaPlugin.class).newInstance(plugin);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create scheduler", e);
        }
    }
}

