/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rplatform.placeholder;

import com.raindropcentral.rplatform.placeholder.AbstractPlaceholderExpansion;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class PlaceholderRegistry {
    private static final Logger LOGGER = Logger.getLogger(PlaceholderRegistry.class.getName());
    private final Plugin plugin;
    private final AbstractPlaceholderExpansion expansion;
    private final boolean papiAvailable;

    public PlaceholderRegistry(@NotNull Plugin plugin, @NotNull AbstractPlaceholderExpansion expansion) {
        this.plugin = plugin;
        this.expansion = expansion;
        this.papiAvailable = Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI");
    }

    public void register() {
        if (!this.papiAvailable) {
            LOGGER.warning("PlaceholderAPI not found - placeholders will not be available");
            return;
        }
        this.expansion.register();
        LOGGER.info("Registered PlaceholderAPI expansion for " + this.plugin.getName());
    }

    public void unregister() {
        if (this.papiAvailable && this.expansion.isRegistered()) {
            this.expansion.unregister();
            LOGGER.info("Unregistered PlaceholderAPI expansion for " + this.plugin.getName());
        }
    }

    public boolean isAvailable() {
        return this.papiAvailable;
    }

    public boolean isRegistered() {
        return this.papiAvailable && this.expansion.isRegistered();
    }
}

