/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rplatform.placeholder;

import org.bukkit.Bukkit;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class PlaceholderManager {
    private final JavaPlugin plugin;
    private final String identifier;
    private boolean registered;

    public PlaceholderManager(@NotNull JavaPlugin plugin, @NotNull String identifier) {
        this.plugin = plugin;
        this.identifier = identifier;
        this.registered = false;
    }

    public void register() {
        if (this.registered) {
            return;
        }
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") == null) {
            this.plugin.getLogger().warning("PlaceholderAPI not found, skipping placeholder registration");
            return;
        }
        try {
            Class<?> expansionClass = Class.forName("com.raindropcentral.rplatform.placeholder.PAPIHook");
            Object expansion = expansionClass.getConstructor(JavaPlugin.class, String.class).newInstance(this.plugin, this.identifier);
            expansionClass.getMethod("register", new Class[0]).invoke(expansion, new Object[0]);
            this.registered = true;
            this.plugin.getLogger().info("PlaceholderAPI expansion registered: " + this.identifier);
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Failed to register PlaceholderAPI expansion: " + e.getMessage());
        }
    }

    public void unregister() {
        if (!this.registered) {
            return;
        }
        try {
            Class<?> expansionClass = Class.forName("com.raindropcentral.rplatform.placeholder.PAPIHook");
            Object expansion = expansionClass.getConstructor(JavaPlugin.class, String.class).newInstance(this.plugin, this.identifier);
            expansionClass.getMethod("unregister", new Class[0]).invoke(expansion, new Object[0]);
            this.registered = false;
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Failed to unregister PlaceholderAPI expansion: " + e.getMessage());
        }
    }

    public boolean isRegistered() {
        return this.registered;
    }
}

