/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rplatform.placeholder;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractPlaceholderExpansion
extends PlaceholderExpansion {
    private final Plugin plugin;
    private final List<String> placeholders;

    protected AbstractPlaceholderExpansion(@NotNull Plugin plugin) {
        this.plugin = plugin;
        this.placeholders = new ArrayList<String>(this.definePlaceholders());
    }

    @NotNull
    protected abstract List<String> definePlaceholders();

    @Nullable
    protected abstract String resolvePlaceholder(@Nullable Player var1, @NotNull String var2);

    @NotNull
    public String getIdentifier() {
        return this.plugin.getName().toLowerCase();
    }

    @NotNull
    public String getAuthor() {
        return String.join((CharSequence)", ", this.plugin.getPluginMeta().getAuthors());
    }

    @NotNull
    public String getVersion() {
        return this.plugin.getPluginMeta().getVersion();
    }

    @NotNull
    public List<String> getPlaceholders() {
        return this.placeholders.stream().map(placeholder -> String.format("%%%s_%s%%", this.getIdentifier(), placeholder)).collect(Collectors.toList());
    }

    public boolean persist() {
        return true;
    }

    @Nullable
    public String onRequest(@Nullable OfflinePlayer offlinePlayer, @NotNull String params) {
        if (offlinePlayer != null && offlinePlayer.isOnline()) {
            return this.onPlaceholderRequest(offlinePlayer.getPlayer(), params);
        }
        return null;
    }

    @Nullable
    public String onPlaceholderRequest(@Nullable Player player, @NotNull String params) {
        return this.resolvePlaceholder(player, params);
    }
}

