/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rplatform.metrics;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.stream.Collectors;
import java.util.zip.GZIPOutputStream;
import javax.net.ssl.HttpsURLConnection;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BStatsMetrics {
    private static final String METRICS_VERSION = "3.0.2";
    private static final String REPORT_URL = "https://bStats.org/api/v2/data/%s";
    private static final String BSTATS_FOLDER = "bStats";
    private static final String CONFIG_FILE = "config.yml";
    private final JavaPlugin plugin;
    private final MetricsCore core;

    public BStatsMetrics(@NotNull JavaPlugin plugin, int serviceId, boolean isFolia) {
        this.plugin = Objects.requireNonNull(plugin, "Plugin cannot be null");
        File configFile = new File(new File(plugin.getDataFolder().getParentFile(), BSTATS_FOLDER), CONFIG_FILE);
        YamlConfiguration config = this.loadConfiguration(configFile);
        boolean enabled = config.getBoolean("enabled", true);
        String serverUuid = config.getString("serverUuid");
        boolean logErrors = config.getBoolean("logFailedRequests", false);
        boolean logSentData = config.getBoolean("logSentData", false);
        boolean logResponseStatus = config.getBoolean("logResponseStatusText", false);
        this.core = new MetricsCore("bukkit", serverUuid, serviceId, enabled, this::appendPlatformData, this::appendServiceData, task -> Bukkit.getScheduler().runTask((Plugin)plugin, task), () -> ((JavaPlugin)plugin).isEnabled(), (message, error) -> plugin.getLogger().log(Level.WARNING, (String)message, (Throwable)error), message -> plugin.getLogger().log(Level.INFO, (String)message), logErrors, logSentData, logResponseStatus);
        if (isFolia) {
            this.addCustomChart(new SingleLineChart("folia", () -> 1));
        }
    }

    public void addCustomChart(@NotNull CustomChart chart) {
        this.core.addCustomChart(chart);
    }

    public void shutdown() {
        this.core.shutdown();
    }

    @NotNull
    private YamlConfiguration loadConfiguration(@NotNull File configFile) {
        configFile.getParentFile().mkdirs();
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)configFile);
        if (!config.isSet("serverUuid")) {
            config.addDefault("enabled", (Object)true);
            config.addDefault("serverUuid", (Object)UUID.randomUUID().toString());
            config.addDefault("logFailedRequests", (Object)false);
            config.addDefault("logSentData", (Object)false);
            config.addDefault("logResponseStatusText", (Object)false);
            config.options().setHeader(List.of("bStats (https://bStats.org) collects anonymous usage statistics.", "This helps plugin authors understand how their plugins are used.", "All data is completely anonymous and cannot be traced back to individual servers.", "You can disable this by setting 'enabled' to false.")).copyDefaults(true);
            try {
                config.save(configFile);
            }
            catch (IOException e) {
                this.plugin.getLogger().log(Level.WARNING, "Failed to save bStats config", e);
            }
        }
        return config;
    }

    private void appendPlatformData(@NotNull JsonBuilder builder) {
        builder.appendField("playerAmount", Bukkit.getOnlinePlayers().size());
        builder.appendField("onlineMode", Bukkit.getOnlineMode() ? 1 : 0);
        builder.appendField("bukkitVersion", Bukkit.getVersion());
        builder.appendField("bukkitName", Bukkit.getName());
        builder.appendField("javaVersion", System.getProperty("java.version"));
        builder.appendField("osName", System.getProperty("os.name"));
        builder.appendField("osArch", System.getProperty("os.arch"));
        builder.appendField("osVersion", System.getProperty("os.version"));
        builder.appendField("coreCount", Runtime.getRuntime().availableProcessors());
    }

    private void appendServiceData(@NotNull JsonBuilder builder) {
        builder.appendField("pluginVersion", this.plugin.getPluginMeta().getVersion());
    }

    public static final class MetricsCore {
        private static final int SCHEDULER_POOL_SIZE = 1;
        private static final long INITIAL_DELAY_MIN = TimeUnit.MINUTES.toMillis(3L);
        private static final long INITIAL_DELAY_MAX_ADDITIONAL = TimeUnit.MINUTES.toMillis(3L);
        private static final long SECOND_DELAY_MAX = TimeUnit.MINUTES.toMillis(30L);
        private static final long SUBMIT_INTERVAL = TimeUnit.MINUTES.toMillis(30L);
        private final ScheduledExecutorService scheduler;
        private final String platform;
        private final String serverUuid;
        private final int serviceId;
        private final boolean enabled;
        private final Consumer<JsonBuilder> platformDataConsumer;
        private final Consumer<JsonBuilder> serviceDataConsumer;
        private final Consumer<Runnable> taskConsumer;
        private final Supplier<Boolean> serviceEnabledSupplier;
        private final BiConsumer<String, Throwable> errorLogger;
        private final Consumer<String> infoLogger;
        private final boolean logErrors;
        private final boolean logSentData;
        private final boolean logResponseStatus;
        private final Set<CustomChart> customCharts = ConcurrentHashMap.newKeySet();

        public MetricsCore(@NotNull String platform, @Nullable String serverUuid, int serviceId, boolean enabled, @NotNull Consumer<JsonBuilder> platformDataConsumer, @NotNull Consumer<JsonBuilder> serviceDataConsumer, @NotNull Consumer<Runnable> taskConsumer, @NotNull Supplier<Boolean> serviceEnabledSupplier, @NotNull BiConsumer<String, Throwable> errorLogger, @NotNull Consumer<String> infoLogger, boolean logErrors, boolean logSentData, boolean logResponseStatus) {
            this.platform = Objects.requireNonNull(platform);
            this.serverUuid = serverUuid;
            this.serviceId = serviceId;
            this.enabled = enabled && serverUuid != null;
            this.platformDataConsumer = Objects.requireNonNull(platformDataConsumer);
            this.serviceDataConsumer = Objects.requireNonNull(serviceDataConsumer);
            this.taskConsumer = Objects.requireNonNull(taskConsumer);
            this.serviceEnabledSupplier = Objects.requireNonNull(serviceEnabledSupplier);
            this.errorLogger = Objects.requireNonNull(errorLogger);
            this.infoLogger = Objects.requireNonNull(infoLogger);
            this.logErrors = logErrors;
            this.logSentData = logSentData;
            this.logResponseStatus = logResponseStatus;
            ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1, task -> {
                Thread thread = new Thread(task, "bStats-Metrics");
                thread.setDaemon(true);
                return thread;
            });
            executor.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
            this.scheduler = executor;
            this.checkRelocation();
            if (this.enabled) {
                infoLogger.accept("[bStats] Enabling metrics. Service ID: " + serviceId);
                this.startSubmitting();
            } else {
                infoLogger.accept("[bStats] Metrics disabled.");
            }
        }

        public void addCustomChart(@NotNull CustomChart chart) {
            this.customCharts.add(Objects.requireNonNull(chart));
        }

        public void shutdown() {
            if (!this.scheduler.isShutdown()) {
                this.infoLogger.accept("[bStats] Shutting down metrics scheduler.");
                this.scheduler.shutdown();
            }
        }

        private void startSubmitting() {
            Runnable submitTask = () -> {
                if (!this.enabled || !this.serviceEnabledSupplier.get().booleanValue()) {
                    this.scheduler.shutdown();
                    return;
                }
                this.taskConsumer.accept(this::submitData);
            };
            long initialDelay = INITIAL_DELAY_MIN + ThreadLocalRandom.current().nextLong(INITIAL_DELAY_MAX_ADDITIONAL + 1L);
            long secondDelay = ThreadLocalRandom.current().nextLong(SECOND_DELAY_MAX + 1L);
            this.scheduler.schedule(submitTask, initialDelay, TimeUnit.MILLISECONDS);
            this.scheduler.scheduleAtFixedRate(submitTask, initialDelay + secondDelay, SUBMIT_INTERVAL, TimeUnit.MILLISECONDS);
        }

        private void submitData() {
            JsonBuilder baseJson = new JsonBuilder();
            this.platformDataConsumer.accept(baseJson);
            JsonBuilder serviceJson = new JsonBuilder();
            this.serviceDataConsumer.accept(serviceJson);
            List<JsonBuilder.JsonObject> chartData = this.customCharts.stream().map(chart -> chart.getRequestJsonObject(this.errorLogger, this.logErrors)).filter(Objects::nonNull).toList();
            if (!chartData.isEmpty()) {
                serviceJson.appendField("customCharts", chartData.toArray(new JsonBuilder.JsonObject[0]));
            }
            serviceJson.appendField("id", this.serviceId);
            baseJson.appendField("service", serviceJson.build());
            baseJson.appendField("serverUUID", this.serverUuid);
            baseJson.appendField("metricsVersion", BStatsMetrics.METRICS_VERSION);
            JsonBuilder.JsonObject data = baseJson.build();
            this.scheduler.execute(() -> this.sendDataAsync(data));
        }

        private void sendDataAsync(@NotNull JsonBuilder.JsonObject data) {
            block2: {
                try {
                    this.sendData(data);
                }
                catch (Exception e) {
                    if (!this.logErrors) break block2;
                    this.errorLogger.accept("Could not submit bStats metrics data", e);
                }
            }
        }

        private void sendData(@NotNull JsonBuilder.JsonObject data) throws IOException {
            String dataString = data.toString();
            if (this.logSentData) {
                this.infoLogger.accept("[bStats] Submitting metrics data: " + dataString);
            }
            String url = String.format(BStatsMetrics.REPORT_URL, this.platform);
            HttpsURLConnection connection = (HttpsURLConnection)new URL(url).openConnection();
            byte[] compressedData = MetricsCore.compress(dataString);
            connection.setRequestMethod("POST");
            connection.addRequestProperty("Accept", "application/json");
            connection.addRequestProperty("Connection", "close");
            connection.addRequestProperty("Content-Encoding", "gzip");
            connection.addRequestProperty("Content-Length", String.valueOf(compressedData.length));
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setRequestProperty("User-Agent", "Metrics-Service/1");
            connection.setDoOutput(true);
            try (DataOutputStream outputStream = new DataOutputStream(connection.getOutputStream());){
                outputStream.write(compressedData);
            }
            StringBuilder responseBuilder = new StringBuilder();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));){
                String line;
                while ((line = reader.readLine()) != null) {
                    responseBuilder.append(line);
                }
            }
            if (this.logResponseStatus) {
                this.infoLogger.accept("[bStats] Response: " + String.valueOf(responseBuilder));
            }
        }

        private void checkRelocation() {
            if ("false".equals(System.getProperty("bstats.relocatecheck"))) {
                return;
            }
            String defaultPackage = new String(new byte[]{111, 114, 103, 46, 98, 115, 116, 97, 116, 115});
            String currentPackage = this.getClass().getPackage().getName();
            if (currentPackage.startsWith(defaultPackage)) {
                throw new IllegalStateException("bStats Metrics class has not been relocated correctly! Current package: " + currentPackage);
            }
        }

        private static byte[] compress(@Nullable String str) throws IOException {
            if (str == null || str.isEmpty()) {
                return new byte[0];
            }
            try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
                byte[] byArray;
                try (GZIPOutputStream gzip = new GZIPOutputStream(outputStream);){
                    gzip.write(str.getBytes(StandardCharsets.UTF_8));
                    gzip.finish();
                    byArray = outputStream.toByteArray();
                }
                return byArray;
            }
        }
    }

    public static final class SingleLineChart
    extends CustomChart {
        private final Callable<Integer> callable;

        public SingleLineChart(@NotNull String chartId, @NotNull Callable<Integer> callable) {
            super(chartId);
            this.callable = Objects.requireNonNull(callable);
        }

        @Override
        @Nullable
        protected JsonBuilder.JsonObject getChartData() throws Exception {
            Integer value = this.callable.call();
            if (value == null || value == 0) {
                return null;
            }
            return new JsonBuilder().appendField("value", value).build();
        }
    }

    public static abstract class CustomChart {
        protected final String chartId;

        protected CustomChart(@NotNull String chartId) {
            if (chartId.isEmpty()) {
                throw new IllegalArgumentException("Chart ID cannot be empty");
            }
            this.chartId = chartId;
        }

        @Nullable
        protected JsonBuilder.JsonObject getRequestJsonObject(@NotNull BiConsumer<String, Throwable> errorLogger, boolean logErrors) {
            JsonBuilder.JsonObject data;
            try {
                data = this.getChartData();
            }
            catch (Exception e) {
                if (logErrors) {
                    errorLogger.accept("Failed to get data for custom chart with id '" + this.chartId + "'", e);
                }
                return null;
            }
            if (data == null) {
                return null;
            }
            JsonBuilder builder = new JsonBuilder();
            builder.appendField("chartId", this.chartId);
            builder.appendField("data", data);
            return builder.build();
        }

        @Nullable
        protected abstract JsonBuilder.JsonObject getChartData() throws Exception;
    }

    public static final class JsonBuilder {
        private StringBuilder builder = new StringBuilder();
        private boolean firstField = true;

        public JsonBuilder() {
            this.builder.append("{");
        }

        @NotNull
        public JsonBuilder appendField(@NotNull String key, @NotNull String value) {
            Objects.requireNonNull(value);
            this.appendFieldInternal(key, "\"" + JsonBuilder.escape(value) + "\"");
            return this;
        }

        @NotNull
        public JsonBuilder appendField(@NotNull String key, int value) {
            this.appendFieldInternal(key, String.valueOf(value));
            return this;
        }

        @NotNull
        public JsonBuilder appendField(@NotNull String key, @NotNull JsonObject object) {
            Objects.requireNonNull(object);
            this.appendFieldInternal(key, object.toString());
            return this;
        }

        @NotNull
        public JsonBuilder appendField(@NotNull String key, @NotNull JsonObject[] values) {
            Objects.requireNonNull(values);
            String arrayContent = Arrays.stream(values).map(JsonObject::toString).collect(Collectors.joining(","));
            this.appendFieldInternal(key, "[" + arrayContent + "]");
            return this;
        }

        private void appendFieldInternal(@NotNull String key, @NotNull String escapedValue) {
            if (this.builder == null) {
                throw new IllegalStateException("JSON has already been built");
            }
            Objects.requireNonNull(key);
            if (!this.firstField) {
                this.builder.append(",");
            }
            this.builder.append("\"").append(JsonBuilder.escape(key)).append("\":").append(escapedValue);
            this.firstField = false;
        }

        @NotNull
        public JsonObject build() {
            if (this.builder == null) {
                throw new IllegalStateException("JSON has already been built");
            }
            JsonObject result = new JsonObject(this.builder.append("}").toString());
            this.builder = null;
            return result;
        }

        @NotNull
        private static String escape(@NotNull String value) {
            StringBuilder sb = new StringBuilder(value.length() + 10);
            block9: for (int i = 0; i < value.length(); ++i) {
                char c = value.charAt(i);
                switch (c) {
                    case '\"': {
                        sb.append("\\\"");
                        continue block9;
                    }
                    case '\\': {
                        sb.append("\\\\");
                        continue block9;
                    }
                    case '\b': {
                        sb.append("\\b");
                        continue block9;
                    }
                    case '\f': {
                        sb.append("\\f");
                        continue block9;
                    }
                    case '\n': {
                        sb.append("\\n");
                        continue block9;
                    }
                    case '\r': {
                        sb.append("\\r");
                        continue block9;
                    }
                    case '\t': {
                        sb.append("\\t");
                        continue block9;
                    }
                    default: {
                        if (c <= '\u001f') {
                            sb.append(String.format("\\u%04x", c));
                            continue block9;
                        }
                        sb.append(c);
                    }
                }
            }
            return sb.toString();
        }

        public static final class JsonObject {
            private final String value;

            private JsonObject(@NotNull String value) {
                this.value = value;
            }

            @NotNull
            public String toString() {
                return this.value;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                JsonObject that = (JsonObject)o;
                return this.value.equals(that.value);
            }

            public int hashCode() {
                return this.value.hashCode();
            }
        }
    }

    public static final class DrillDownPie
    extends CustomChart {
        private final Callable<Map<String, Map<String, Integer>>> callable;

        public DrillDownPie(@NotNull String chartId, @NotNull Callable<Map<String, Map<String, Integer>>> callable) {
            super(chartId);
            this.callable = Objects.requireNonNull(callable);
        }

        @Override
        @Nullable
        protected JsonBuilder.JsonObject getChartData() throws Exception {
            Map<String, Map<String, Integer>> map = this.callable.call();
            if (map == null || map.isEmpty()) {
                return null;
            }
            JsonBuilder valuesBuilder = new JsonBuilder();
            boolean topLevelDataFound = false;
            for (Map.Entry<String, Map<String, Integer>> topLevelEntry : map.entrySet()) {
                String topLevelKey = topLevelEntry.getKey();
                Map<String, Integer> innerMap = topLevelEntry.getValue();
                if (topLevelKey == null || topLevelKey.isEmpty() || innerMap == null || innerMap.isEmpty()) continue;
                JsonBuilder innerBuilder = new JsonBuilder();
                boolean innerDataFound = false;
                for (Map.Entry<String, Integer> innerEntry : innerMap.entrySet()) {
                    if (innerEntry.getKey() == null || innerEntry.getKey().isEmpty() || innerEntry.getValue() == null || innerEntry.getValue() == 0) continue;
                    innerBuilder.appendField(innerEntry.getKey(), innerEntry.getValue());
                    innerDataFound = true;
                }
                if (!innerDataFound) continue;
                valuesBuilder.appendField(topLevelKey, innerBuilder.build());
                topLevelDataFound = true;
            }
            if (!topLevelDataFound) {
                return null;
            }
            return new JsonBuilder().appendField("values", valuesBuilder.build()).build();
        }
    }

    public static final class MultiLineChart
    extends CustomChart {
        private final Callable<Map<String, Integer>> callable;

        public MultiLineChart(@NotNull String chartId, @NotNull Callable<Map<String, Integer>> callable) {
            super(chartId);
            this.callable = Objects.requireNonNull(callable);
        }

        @Override
        @Nullable
        protected JsonBuilder.JsonObject getChartData() throws Exception {
            Map<String, Integer> map = this.callable.call();
            if (map == null || map.isEmpty()) {
                return null;
            }
            JsonBuilder valuesBuilder = new JsonBuilder();
            boolean dataFound = false;
            for (Map.Entry<String, Integer> entry : map.entrySet()) {
                if (entry.getKey() == null || entry.getKey().isEmpty() || entry.getValue() == null || entry.getValue() == 0) continue;
                valuesBuilder.appendField(entry.getKey(), entry.getValue());
                dataFound = true;
            }
            if (!dataFound) {
                return null;
            }
            return new JsonBuilder().appendField("values", valuesBuilder.build()).build();
        }
    }

    public static final class AdvancedPie
    extends CustomChart {
        private final Callable<Map<String, Integer>> callable;

        public AdvancedPie(@NotNull String chartId, @NotNull Callable<Map<String, Integer>> callable) {
            super(chartId);
            this.callable = Objects.requireNonNull(callable);
        }

        @Override
        @Nullable
        protected JsonBuilder.JsonObject getChartData() throws Exception {
            Map<String, Integer> map = this.callable.call();
            if (map == null || map.isEmpty()) {
                return null;
            }
            JsonBuilder valuesBuilder = new JsonBuilder();
            boolean dataFound = false;
            for (Map.Entry<String, Integer> entry : map.entrySet()) {
                if (entry.getKey() == null || entry.getKey().isEmpty() || entry.getValue() == null || entry.getValue() == 0) continue;
                valuesBuilder.appendField(entry.getKey(), entry.getValue());
                dataFound = true;
            }
            if (!dataFound) {
                return null;
            }
            return new JsonBuilder().appendField("values", valuesBuilder.build()).build();
        }
    }

    public static final class SimplePie
    extends CustomChart {
        private final Callable<String> callable;

        public SimplePie(@NotNull String chartId, @NotNull Callable<String> callable) {
            super(chartId);
            this.callable = Objects.requireNonNull(callable);
        }

        @Override
        @Nullable
        protected JsonBuilder.JsonObject getChartData() throws Exception {
            String value = this.callable.call();
            if (value == null || value.isEmpty()) {
                return null;
            }
            return new JsonBuilder().appendField("value", value).build();
        }
    }
}

