/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rplatform.logging;

import com.raindropcentral.rplatform.logging.CentralLogger;
import com.raindropcentral.rplatform.logging.LogLevel;
import com.raindropcentral.rplatform.logging.LoggerConfig;
import java.util.logging.Handler;
import java.util.logging.Logger;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class PlatformLogger {
    private final Logger logger;
    private final LoggerConfig config;

    private PlatformLogger(@NotNull JavaPlugin plugin) {
        this.logger = CentralLogger.getLogger(plugin.getName());
        this.config = LoggerConfig.load(plugin);
        LogLevel lvl = this.config.getLevelForPackage(plugin.getClass().getPackage().getName());
        this.logger.setLevel(lvl.toJavaLevel());
        this.logger.setUseParentHandlers(true);
    }

    @NotNull
    public static PlatformLogger create(@NotNull JavaPlugin plugin) {
        return new PlatformLogger(plugin);
    }

    public void critical(@NotNull String message) {
        this.logger.log(LogLevel.CRITICAL.toJavaLevel(), message);
    }

    public void critical(@NotNull String message, @NotNull Throwable throwable) {
        this.logger.log(LogLevel.CRITICAL.toJavaLevel(), message, throwable);
    }

    public void error(@NotNull String message) {
        this.logger.log(LogLevel.ERROR.toJavaLevel(), message);
    }

    public void error(@NotNull String message, @NotNull Throwable throwable) {
        this.logger.log(LogLevel.ERROR.toJavaLevel(), message, throwable);
    }

    public void warn(@NotNull String message) {
        this.logger.log(LogLevel.WARNING.toJavaLevel(), message);
    }

    public void info(@NotNull String message) {
        this.logger.log(LogLevel.INFO.toJavaLevel(), message);
    }

    public void debug(@NotNull String message) {
        if (this.config.isDebugEnabled()) {
            this.logger.log(LogLevel.DEBUG.toJavaLevel(), message);
        }
    }

    public void trace(@NotNull String message) {
        if (this.config.isDebugEnabled()) {
            this.logger.log(LogLevel.TRACE.toJavaLevel(), message);
        }
    }

    public void setConsoleEnabled(boolean enabled) {
        CentralLogger.setConsoleLoggingEnabled(enabled);
    }

    public boolean isConsoleEnabled() {
        return CentralLogger.isConsoleLoggingEnabled();
    }

    @NotNull
    public Logger getJavaLogger() {
        return this.logger;
    }

    public void close() {
        for (Handler handler : this.logger.getHandlers()) {
            try {
                this.logger.removeHandler(handler);
                handler.flush();
                handler.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

