/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rplatform.logging;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlatformLogFormatter
extends Formatter {
    private static final DateTimeFormatter TIMESTAMP_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").withZone(ZoneId.systemDefault());
    private static final DateTimeFormatter TIME_ONLY_FORMAT = DateTimeFormatter.ofPattern("HH:mm:ss").withZone(ZoneId.systemDefault());
    private static final Pattern ANSI_PATTERN = Pattern.compile("\u001b\\[[;\\d]*[ -/]*[@-~]");
    private static final Pattern CONTROL_CHAR_PATTERN = Pattern.compile("\\p{Cntrl}");
    private static final String RESET = "\u001b[0m";
    private final boolean useColors;

    public PlatformLogFormatter(boolean useColors) {
        this.useColors = useColors && System.console() != null;
    }

    @Override
    @NotNull
    public String format(@NotNull LogRecord record) {
        StringBuilder builder = new StringBuilder();
        String timestamp = this.formatTimestamp(record.getMillis(), this.useColors);
        String levelStr = record.getLevel() != null ? record.getLevel().getName() : "INFO";
        String coloredLevel = this.useColors ? this.colorize(levelStr) : levelStr;
        builder.append("[").append(timestamp).append("] ").append("[").append(coloredLevel).append("] ");
        String loggerName = record.getLoggerName();
        if (loggerName != null && !loggerName.isEmpty()) {
            builder.append(this.abbreviateLogger(loggerName)).append(": ");
        }
        String message = this.sanitize(this.formatMessage(record));
        builder.append(message);
        if (record.getThrown() != null) {
            builder.append("\n").append(this.formatThrowable(record.getThrown()));
        }
        builder.append("\n");
        return builder.toString();
    }

    @NotNull
    private String formatTimestamp(long millis, boolean compact) {
        return (compact ? TIME_ONLY_FORMAT : TIMESTAMP_FORMAT).format(Instant.ofEpochMilli(millis));
    }

    @NotNull
    private String colorize(@NotNull String level) {
        String code;
        switch (level) {
            case "SEVERE": 
            case "CRITICAL": 
            case "ERROR": {
                code = "\u001b[31m";
                break;
            }
            case "WARNING": 
            case "WARN": {
                code = "\u001b[33m";
                break;
            }
            case "INFO": {
                code = "\u001b[32m";
                break;
            }
            case "CONFIG": {
                code = "\u001b[34m";
                break;
            }
            case "DEBUG": 
            case "TRACE": 
            case "FINE": 
            case "FINER": 
            case "FINEST": {
                code = "\u001b[36m";
                break;
            }
            default: {
                return level;
            }
        }
        return code + level + RESET;
    }

    @NotNull
    private String abbreviateLogger(@NotNull String loggerName) {
        if (loggerName.length() <= 30) {
            return loggerName;
        }
        String[] parts = loggerName.split("\\.");
        StringBuilder abbreviated = new StringBuilder();
        for (int i = 0; i < parts.length - 1; ++i) {
            if (parts[i].isEmpty()) continue;
            abbreviated.append(parts[i].charAt(0)).append(".");
        }
        abbreviated.append(parts[parts.length - 1]);
        return abbreviated.toString();
    }

    @NotNull
    private String sanitize(@Nullable String text) {
        if (text == null) {
            return "";
        }
        String cleaned = ANSI_PATTERN.matcher(text).replaceAll("");
        cleaned = CONTROL_CHAR_PATTERN.matcher(cleaned).replaceAll("");
        return cleaned;
    }

    @NotNull
    private String formatThrowable(@NotNull Throwable throwable) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        throwable.printStackTrace(pw);
        pw.flush();
        return this.sanitize(sw.toString());
    }
}

