/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rplatform.logging;

import java.io.OutputStream;
import java.util.logging.ConsoleHandler;
import java.util.logging.LogRecord;

public class PlatformConsoleHandler
extends ConsoleHandler {
    private final OutputStream target;

    public PlatformConsoleHandler() {
        this(System.out);
    }

    public PlatformConsoleHandler(OutputStream out) {
        this.target = out != null ? out : System.out;
        this.setOutputStream(this.target);
    }

    @Override
    protected synchronized void setOutputStream(OutputStream out) throws SecurityException {
        OutputStream effective = this.target != null ? this.target : (out != null ? out : System.out);
        super.setOutputStream(effective);
    }

    @Override
    public synchronized void publish(LogRecord record) {
        if (!this.isLoggable(record)) {
            return;
        }
        super.publish(record);
        this.flush();
    }

    @Override
    public synchronized void close() throws SecurityException {
        try {
            this.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

