/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rplatform.logging;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class LoggingPrintStream
extends PrintStream {
    private static final Pattern ALREADY_FORMATTED_LINE = Pattern.compile("^\\[\\d{4}-\\d{2}-\\d{2} \\d{2}:\\d{2}:\\d{2}] \\[(SEVERE|WARNING|WARN|INFO|CONFIG|DEBUG|TRACE|FINE|FINER|FINEST)].*");
    private final Logger logger;
    private final Level level;
    private final PrintStream originalStream;
    private final ByteArrayOutputStream buffer;

    public LoggingPrintStream(@NotNull Logger logger, @NotNull Level level, PrintStream originalStream) {
        super(new ByteArrayOutputStream());
        this.logger = logger;
        this.level = level;
        this.originalStream = originalStream;
        this.buffer = (ByteArrayOutputStream)this.out;
    }

    @Override
    public void write(int b) {
        this.buffer.write(b);
        if (b == 10) {
            this.flush();
        }
    }

    @Override
    public void write(byte[] buf, int off, int len) {
        this.buffer.write(buf, off, len);
        for (int i = off; i < off + len; ++i) {
            if (buf[i] != 10) continue;
            this.flush();
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        LoggingPrintStream loggingPrintStream = this;
        synchronized (loggingPrintStream) {
            if (this.buffer.size() > 0) {
                String message = this.buffer.toString().trim();
                this.buffer.reset();
                if (!(message.isEmpty() || message.startsWith("[INIT]") || message.startsWith("[DEBUG]") || message.startsWith("[EMERGENCY]") || message.startsWith("\u2554") || message.startsWith("\u2551") || message.startsWith("\u255a") || ALREADY_FORMATTED_LINE.matcher(message).matches())) {
                    String prefix = this.level == Level.SEVERE ? "\ud83d\udea8 " : "\ud83d\udcdd ";
                    this.logger.log(this.level, prefix + message);
                }
            }
        }
        if (this.originalStream != null) {
            this.originalStream.flush();
        }
    }

    @Override
    public void close() {
        this.flush();
        if (this.originalStream != null) {
            this.originalStream.close();
        }
        super.close();
    }
}

