/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rplatform.logging;

import com.raindropcentral.rplatform.config.LoggerSection;
import com.raindropcentral.rplatform.logging.LogLevel;
import de.jexcellence.evaluable.ConfigKeeper;
import de.jexcellence.evaluable.ConfigManager;
import java.io.File;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class LoggerConfig {
    private final boolean consoleEnabled;
    private final boolean debugEnabled;
    private final LogLevel defaultLevel;
    private final LogLevel consoleLevel;
    private final LogLevel fileLevel;
    private final Map<String, LogLevel> packageLevels;

    private LoggerConfig(boolean consoleEnabled, boolean debugEnabled, LogLevel defaultLevel, Map<String, LogLevel> packageLevels) {
        this.consoleEnabled = consoleEnabled;
        this.debugEnabled = debugEnabled;
        this.consoleLevel = this.defaultLevel = defaultLevel != null ? defaultLevel : LogLevel.INFO;
        this.fileLevel = this.defaultLevel;
        this.packageLevels = Collections.unmodifiableMap(new HashMap<String, LogLevel>(packageLevels));
    }

    public boolean isConsoleEnabled() {
        return this.consoleEnabled;
    }

    public boolean isDebugEnabled() {
        return this.debugEnabled;
    }

    @NotNull
    public LogLevel getConsoleLevel() {
        return this.consoleLevel;
    }

    @NotNull
    public LogLevel getFileLevel() {
        return this.fileLevel;
    }

    @NotNull
    public LogLevel getLevelForPackage(String loggerName) {
        if (loggerName == null || loggerName.isEmpty() || this.packageLevels.isEmpty()) {
            return this.defaultLevel;
        }
        String bestKey = null;
        for (String key : this.packageLevels.keySet()) {
            if (!loggerName.startsWith(key) || bestKey != null && key.length() <= bestKey.length()) continue;
            bestKey = key;
        }
        if (bestKey != null) {
            return this.packageLevels.getOrDefault(bestKey, this.defaultLevel);
        }
        return this.defaultLevel;
    }

    @NotNull
    public static LoggerConfig load(@NotNull JavaPlugin plugin) {
        Map<String, LogLevel> pkg;
        LogLevel defaultLvl;
        boolean debug;
        boolean console;
        block9: {
            Objects.requireNonNull(plugin, "plugin");
            console = true;
            debug = false;
            defaultLvl = LogLevel.INFO;
            pkg = LoggerConfig.defaultPackageDefaults();
            try {
                ConfigManager cfgManager = new ConfigManager((Plugin)plugin, "logs");
                ConfigKeeper<LoggerSection> cfgKeeper = new ConfigKeeper<LoggerSection>(cfgManager, "logging.yml", LoggerSection.class);
                LoggerSection section = (LoggerSection)cfgKeeper.rootSection;
                if (section != null) {
                    console = section.isConsoleLogging();
                    debug = section.isDebugMode();
                    try {
                        defaultLvl = LogLevel.fromString(section.getDefaultLevel());
                    }
                    catch (Exception ignored) {
                        defaultLvl = LogLevel.INFO;
                    }
                    Map<String, String> configured = section.getLoggers();
                    if (configured != null && !configured.isEmpty()) {
                        HashMap<String, LogLevel> merged = new HashMap<String, LogLevel>(pkg);
                        for (Map.Entry<String, String> e : configured.entrySet()) {
                            if (e.getKey() == null || e.getKey().isEmpty() || e.getValue() == null) continue;
                            merged.put(e.getKey(), LogLevel.fromString(e.getValue()));
                        }
                        pkg = merged;
                    }
                    break block9;
                }
                LoggerConfig.ensureDefaultConfigFile(plugin);
            }
            catch (Exception e) {
                System.err.println("[LOGGER WARN] Failed to load LoggerConfig: " + e.getMessage());
                try {
                    LoggerConfig.ensureDefaultConfigFile(plugin);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return new LoggerConfig(console, debug, defaultLvl, pkg);
    }

    private static Map<String, LogLevel> defaultPackageDefaults() {
        HashMap<String, LogLevel> map = new HashMap<String, LogLevel>();
        map.put("com.raindropcentral", LogLevel.WARNING);
        map.put("de.jexcellence", LogLevel.WARNING);
        map.put("de.jexcellence.remapped.me.devnatan.inventoryframework", LogLevel.WARNING);
        map.put("org.bukkit", LogLevel.INFO);
        map.put("net.minecraft", LogLevel.WARNING);
        map.put("org.hibernate", LogLevel.WARNING);
        map.put("org.apache", LogLevel.WARNING);
        map.put("org.springframework", LogLevel.WARNING);
        return map;
    }

    private static void ensureDefaultConfigFile(@NotNull JavaPlugin plugin) throws Exception {
        File dir = new File(plugin.getDataFolder(), "logs");
        if (!dir.exists() && !dir.mkdirs()) {
            return;
        }
        File file = new File(dir, "logging.yml");
        if (file.exists()) {
            return;
        }
        try (PrintWriter writer = new PrintWriter(file);){
            writer.println("defaultLevel: INFO");
            writer.println("consoleLogging: true");
            writer.println("debugMode: false");
            writer.println("loggers:");
            writer.println("  com.raindropcentral: WARNING");
            writer.println("  de.jexcellence: WARNING");
            writer.println("  me.devnatan.inventoryframework: WARNING");
            writer.println("  org.bukkit: INFO");
            writer.println("  net.minecraft: WARNING");
            writer.println("  org.hibernate: WARNING");
            writer.println("  org.apache: WARNING");
            writer.println("  org.springframework: WARNING");
        }
    }
}

