/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rplatform.logging;

import java.util.Locale;
import java.util.logging.Level;
import org.jetbrains.annotations.NotNull;

public enum LogLevel {
    CRITICAL(Level.SEVERE),
    ERROR(Level.SEVERE),
    WARN(Level.WARNING),
    WARNING(Level.WARNING),
    INFO(Level.INFO),
    CONFIG(Level.CONFIG),
    DEBUG(Level.FINE),
    TRACE(Level.FINER),
    FINE(Level.FINE),
    FINER(Level.FINER),
    FINEST(Level.FINEST);

    private final Level javaLevel;

    private LogLevel(Level javaLevel) {
        this.javaLevel = javaLevel;
    }

    @NotNull
    public Level toJavaLevel() {
        return this.javaLevel;
    }

    @NotNull
    public static LogLevel fromString(String s) {
        String k;
        if (s == null || s.isEmpty()) {
            return INFO;
        }
        switch (k = s.trim().toUpperCase(Locale.ROOT)) {
            case "CRITICAL": {
                return CRITICAL;
            }
            case "ERROR": {
                return ERROR;
            }
            case "WARN": {
                return WARN;
            }
            case "WARNING": {
                return WARNING;
            }
            case "INFO": {
                return INFO;
            }
            case "CONFIG": {
                return CONFIG;
            }
            case "DEBUG": {
                return DEBUG;
            }
            case "TRACE": {
                return TRACE;
            }
            case "FINE": {
                return FINE;
            }
            case "FINER": {
                return FINER;
            }
            case "FINEST": {
                return FINEST;
            }
            case "SEVERE": {
                return ERROR;
            }
        }
        return INFO;
    }
}

