/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rplatform.logging;

import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnhancedLogFormatter
extends Formatter {
    private static final DateTimeFormatter STANDARD_FORMATTER = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd HH:mm:ss").toFormatter().withZone(ZoneId.systemDefault());
    private static final DateTimeFormatter COMPACT_FORMATTER = new DateTimeFormatterBuilder().appendPattern("HH:mm:ss").appendFraction(ChronoField.MILLI_OF_SECOND, 3, 3, true).toFormatter().withZone(ZoneId.systemDefault());
    private static final Pattern ANSI_PATTERN = Pattern.compile("\u001b\\[[;\\d]*[ -/]*[@-~]");
    private static final Pattern CONTROL_CHAR_PATTERN = Pattern.compile("\\p{Cntrl}");
    private final boolean useColor;

    public EnhancedLogFormatter(boolean useColor) {
        this.useColor = useColor && System.console() != null;
    }

    @Override
    public String format(@NotNull LogRecord record) {
        if (record.getLoggerName() != null && record.getLoggerName().startsWith("com.raindropcentral.rplatform.logging")) {
            return this.simple(record) + "\n";
        }
        String message = this.clean(record.getMessage());
        StringBuilder sb = new StringBuilder();
        sb.append("[").append(COMPACT_FORMATTER.format(Instant.ofEpochMilli(record.getMillis()))).append("] ");
        sb.append("[").append(this.colorize(this.levelName(record.getLevel()))).append("] ");
        String loggerName = this.abbreviateLoggerName(record.getLoggerName());
        if (loggerName != null && !loggerName.isEmpty()) {
            sb.append(loggerName).append(": ");
        }
        sb.append(message);
        if (record.getThrown() != null) {
            sb.append("\n").append(record.getThrown().toString());
            for (StackTraceElement ste : record.getThrown().getStackTrace()) {
                sb.append("\n\tat ").append(this.clean(ste.toString()));
            }
        }
        return sb.append("\n").toString();
    }

    private String simple(LogRecord r) {
        return "[" + String.valueOf(r.getLevel()) + "] " + (r.getMessage() == null ? "" : r.getMessage());
    }

    private String levelName(Level lvl) {
        return lvl.getName();
    }

    private String clean(String in) {
        if (in == null) {
            return "";
        }
        String s = ANSI_PATTERN.matcher(in).replaceAll("");
        s = CONTROL_CHAR_PATTERN.matcher(s).replaceAll("");
        return s;
    }

    private String colorize(@NotNull String level) {
        if (!this.useColor) {
            return level;
        }
        switch (level) {
            case "SEVERE": 
            case "CRITICAL": 
            case "ERROR": {
                return "\u001b[31m" + level + "\u001b[0m";
            }
            case "WARNING": 
            case "WARN": {
                return "\u001b[33m" + level + "\u001b[0m";
            }
            case "INFO": {
                return "\u001b[32m" + level + "\u001b[0m";
            }
            case "CONFIG": {
                return "\u001b[34m" + level + "\u001b[0m";
            }
            case "DEBUG": 
            case "FINE": 
            case "FINER": 
            case "FINEST": 
            case "TRACE": {
                return "\u001b[36m" + level + "\u001b[0m";
            }
        }
        return level;
    }

    @Nullable
    private String abbreviateLoggerName(@Nullable String name) {
        if (name == null || name.length() < 30) {
            return name;
        }
        String[] parts = name.split("\\.");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < parts.length - 1; ++i) {
            if (parts[i].isEmpty()) continue;
            sb.append(parts[i].charAt(0)).append('.');
        }
        return sb.append(parts[parts.length - 1]).toString();
    }
}

