/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rplatform.logging;

import com.raindropcentral.rplatform.logging.EnhancedLogFormatter;
import com.raindropcentral.rplatform.logging.LogLevel;
import com.raindropcentral.rplatform.logging.LoggerConfig;
import com.raindropcentral.rplatform.logging.LoggingPrintStream;
import com.raindropcentral.rplatform.logging.PlatformConsoleHandler;
import com.raindropcentral.rplatform.logging.PlatformLogFormatter;
import java.io.File;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Enumeration;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Filter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class CentralLogger {
    private static final int MAX_FILE_SIZE = 0xA00000;
    private static final int MAX_FILE_COUNT = 5;
    private static final DateTimeFormatter FILE_DATE_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    private static volatile boolean INITIALIZED = false;
    private static JavaPlugin LOADED_PLUGIN;
    private static PrintStream ORIGINAL_OUT;
    private static PrintStream ORIGINAL_ERR;
    private static FileHandler FILE_HANDLER;
    private static ConsoleHandler CONSOLE_HANDLER;
    private static UniversalLogHandler UNIVERSAL_HANDLER;
    private static final AtomicBoolean EMERGENCY_MODE;
    private static final ThreadLocal<Integer> RECURSION_DEPTH;
    private static final int MAX_RECURSION_DEPTH = 3;
    private static volatile boolean CONSOLE_LOGGING_ENABLED;
    private static volatile boolean DEBUG_MODE;
    private static volatile Level CONSOLE_LEVEL;
    private static volatile Level FILE_LEVEL;
    private static final Map<String, Logger> MANAGED_LOGGERS;
    private static final long DUP_WINDOW_MS = 750L;
    private static final Map<String, Long> LAST_SEEN;

    private CentralLogger() {
    }

    public static synchronized void initialize(@NotNull JavaPlugin plugin) {
        if (INITIALIZED) {
            return;
        }
        LOADED_PLUGIN = plugin;
        try {
            ORIGINAL_OUT = System.out;
            ORIGINAL_ERR = System.err;
            LoggerConfig cfg = LoggerConfig.load(plugin);
            CONSOLE_LOGGING_ENABLED = cfg.isConsoleEnabled();
            DEBUG_MODE = cfg.isDebugEnabled();
            CONSOLE_LEVEL = cfg.getConsoleLevel().toJavaLevel();
            FILE_LEVEL = cfg.getFileLevel().toJavaLevel();
            CentralLogger.setupFileHandler(plugin);
            if (CONSOLE_LOGGING_ENABLED) {
                CentralLogger.setupConsoleHandler();
            }
            CentralLogger.setupUniversalRootCapture(cfg);
            CentralLogger.redirectSystemStreams();
            INITIALIZED = true;
            ORIGINAL_OUT.println("[INIT] CentralLogger initialized - Console: " + CONSOLE_LOGGING_ENABLED + ", ConsoleLevel: " + String.valueOf(CONSOLE_LEVEL) + ", FileLevel: " + String.valueOf(FILE_LEVEL) + ", Debug: " + DEBUG_MODE);
        }
        catch (Exception e) {
            if (ORIGINAL_ERR != null) {
                e.printStackTrace(ORIGINAL_ERR);
            }
            e.printStackTrace();
        }
    }

    private static void setupFileHandler(JavaPlugin plugin) throws Exception {
        File logDir = new File(plugin.getDataFolder(), "logs");
        if (!logDir.exists() && !logDir.mkdirs()) {
            throw new Exception("Could not create log directory: " + logDir.getAbsolutePath());
        }
        String timestamp = LocalDateTime.now().format(FILE_DATE_FORMAT);
        File logFile = new File(logDir, plugin.getName().toLowerCase() + "-" + timestamp + ".log");
        FILE_HANDLER = new FileHandler(logFile.getAbsolutePath(), 0xA00000, 5, true);
        FILE_HANDLER.setFormatter(new PlatformLogFormatter(false));
        FILE_HANDLER.setLevel(FILE_LEVEL);
        try {
            FILE_HANDLER.setEncoding("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    private static void setupConsoleHandler() {
        CONSOLE_HANDLER = new PlatformConsoleHandler(ORIGINAL_OUT);
        CONSOLE_HANDLER.setLevel(CONSOLE_LEVEL);
        CONSOLE_HANDLER.setFormatter(new EnhancedLogFormatter(true));
        try {
            CONSOLE_HANDLER.setEncoding("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    private static void setupUniversalRootCapture(LoggerConfig cfg) {
        LogManager lm = LogManager.getLogManager();
        Logger root = lm.getLogger("");
        CentralLogger.stripConsoleHandlers(root);
        Enumeration<String> names = lm.getLoggerNames();
        while (names.hasMoreElements()) {
            Logger l;
            String name = names.nextElement();
            if (name == null || name.isEmpty() || (l = lm.getLogger(name)) == null) continue;
            CentralLogger.stripConsoleHandlers(l);
            CentralLogger.applyNagFilter(l);
            MANAGED_LOGGERS.put(name, l);
        }
        UNIVERSAL_HANDLER = new UniversalLogHandler(cfg);
        root.addHandler(UNIVERSAL_HANDLER);
        root.setUseParentHandlers(false);
        root.setLevel(Level.ALL);
        CentralLogger.applyPackageLevels(cfg);
    }

    private static void applyNagFilter(Logger logger) {
        if (logger == null) {
            return;
        }
        Filter existing = logger.getFilter();
        logger.setFilter(record -> {
            if (record == null) {
                return false;
            }
            String msg = record.getMessage();
            if (msg != null && msg.contains("Nag author") && msg.contains("System.out/err")) {
                return false;
            }
            return existing == null || existing.isLoggable(record);
        });
    }

    private static void applyPackageLevels(LoggerConfig cfg) {
        LogManager lm = LogManager.getLogManager();
        Enumeration<String> names = lm.getLoggerNames();
        while (names.hasMoreElements()) {
            Logger l;
            String n = names.nextElement();
            if (n == null || n.isEmpty() || (l = lm.getLogger(n)) == null) continue;
            LogLevel target = cfg.getLevelForPackage(n);
            l.setLevel(target.toJavaLevel());
            l.setUseParentHandlers(true);
            CentralLogger.stripConsoleHandlers(l);
            MANAGED_LOGGERS.put(n, l);
        }
    }

    private static void redirectSystemStreams() {
        Logger outLogger = Logger.getLogger("System.out");
        Logger errLogger = Logger.getLogger("System.err");
        outLogger.setUseParentHandlers(true);
        errLogger.setUseParentHandlers(true);
        CentralLogger.stripConsoleHandlers(outLogger);
        CentralLogger.stripConsoleHandlers(errLogger);
        System.setOut(new LoggingPrintStream(outLogger, Level.INFO, ORIGINAL_OUT));
        System.setErr(new LoggingPrintStream(errLogger, Level.SEVERE, ORIGINAL_ERR));
    }

    private static void stripConsoleHandlers(Logger logger) {
        if (logger == null) {
            return;
        }
        for (Handler h : logger.getHandlers()) {
            if (!(h instanceof ConsoleHandler)) continue;
            try {
                logger.removeHandler(h);
                h.flush();
                h.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static Logger getLogger(Class<?> clazz) {
        return CentralLogger.getLogger(clazz.getName());
    }

    public static Logger getLogger(String name) {
        Logger l = Logger.getLogger(Objects.requireNonNullElse(name, ""));
        l.setUseParentHandlers(true);
        CentralLogger.stripConsoleHandlers(l);
        MANAGED_LOGGERS.put(name, l);
        return l;
    }

    public static synchronized void setConsoleLoggingEnabled(boolean enabled) {
        CONSOLE_LOGGING_ENABLED = enabled;
        if (enabled && CONSOLE_HANDLER == null) {
            CentralLogger.setupConsoleHandler();
        }
        for (Logger l : MANAGED_LOGGERS.values()) {
            CentralLogger.stripConsoleHandlers(l);
        }
        Logger logger = CentralLogger.getLogger("CentralLogger");
        logger.log(Level.INFO, "Console logging " + (enabled ? "ENABLED" : "DISABLED"));
    }

    public static boolean isConsoleLoggingEnabled() {
        return CONSOLE_LOGGING_ENABLED;
    }

    public static boolean isWorking() {
        return INITIALIZED && FILE_HANDLER != null && !EMERGENCY_MODE.get();
    }

    public static String getLogFilePath() {
        if (LOADED_PLUGIN == null) {
            return "Plugin not loaded";
        }
        String timestamp = LocalDateTime.now().format(FILE_DATE_FORMAT);
        return new File(LOADED_PLUGIN.getDataFolder(), "logs/" + LOADED_PLUGIN.getName().toLowerCase() + "-" + timestamp + ".log").getAbsolutePath();
    }

    public static void flush() {
        try {
            if (UNIVERSAL_HANDLER != null) {
                UNIVERSAL_HANDLER.flush();
            }
            if (FILE_HANDLER != null) {
                FILE_HANDLER.flush();
            }
            if (CONSOLE_HANDLER != null) {
                CONSOLE_HANDLER.flush();
            }
        }
        catch (Exception e) {
            CentralLogger.safeErr("[LOGGER ERROR] Failed to flush: " + e.getMessage());
        }
    }

    public static synchronized void shutdown() {
        if (!INITIALIZED) {
            return;
        }
        try {
            if (ORIGINAL_OUT != null) {
                System.setOut(ORIGINAL_OUT);
            }
            if (ORIGINAL_ERR != null) {
                System.setErr(ORIGINAL_ERR);
            }
            if (UNIVERSAL_HANDLER != null) {
                UNIVERSAL_HANDLER.flush();
                UNIVERSAL_HANDLER.close();
            }
            if (FILE_HANDLER != null) {
                FILE_HANDLER.flush();
                FILE_HANDLER.close();
            }
            if (CONSOLE_HANDLER != null) {
                CONSOLE_HANDLER.flush();
                CONSOLE_HANDLER.close();
            }
        }
        catch (Exception e) {
            CentralLogger.safeErr("[LOGGER ERROR] Error during shutdown: " + e.getMessage());
        }
        finally {
            INITIALIZED = false;
        }
    }

    private static void safeErr(String line) {
        try {
            if (ORIGINAL_ERR != null) {
                ORIGINAL_ERR.println(line);
            } else {
                System.err.println(line);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        EMERGENCY_MODE = new AtomicBoolean(false);
        RECURSION_DEPTH = ThreadLocal.withInitial(() -> 0);
        CONSOLE_LOGGING_ENABLED = true;
        DEBUG_MODE = false;
        CONSOLE_LEVEL = Level.INFO;
        FILE_LEVEL = Level.ALL;
        MANAGED_LOGGERS = new ConcurrentHashMap<String, Logger>();
        LAST_SEEN = new ConcurrentHashMap<String, Long>();
    }

    private static final class UniversalLogHandler
    extends Handler {
        private final LoggerConfig cfg;

        UniversalLogHandler(LoggerConfig cfg) {
            this.cfg = cfg;
            this.setLevel(Level.ALL);
            this.setFilter(record -> {
                Level lvl;
                if (record == null) {
                    return false;
                }
                String msg = record.getMessage();
                if (msg != null && msg.contains("Nag author") && msg.contains("System.out/err")) {
                    return false;
                }
                if (!(DEBUG_MODE || (lvl = record.getLevel()) != Level.FINE && lvl != Level.FINER && lvl != Level.FINEST)) {
                    return false;
                }
                String loggerName = record.getLoggerName() != null ? record.getLoggerName() : "";
                LogLevel target = cfg.getLevelForPackage(loggerName);
                return record.getLevel().intValue() >= target.toJavaLevel().intValue();
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void publish(LogRecord record) {
            if (record == null || !this.isLoggable(record)) {
                return;
            }
            if (EMERGENCY_MODE.get()) {
                return;
            }
            int depth = RECURSION_DEPTH.get();
            if (depth >= 3) {
                EMERGENCY_MODE.set(true);
                CentralLogger.safeErr("[EMERGENCY] Max recursion depth reached, entering emergency mode");
                return;
            }
            RECURSION_DEPTH.set(depth + 1);
            try {
                LogRecord enhanced = this.enhance(record);
                if (this.isDuplicate(enhanced)) {
                    return;
                }
                if (FILE_HANDLER != null && FILE_HANDLER.isLoggable(enhanced)) {
                    FILE_HANDLER.publish(enhanced);
                }
                if (CONSOLE_LOGGING_ENABLED && CONSOLE_HANDLER != null && CONSOLE_HANDLER.isLoggable(enhanced) && !this.isFromLoggingSystem(enhanced) && !this.isNagMessage(enhanced)) {
                    CONSOLE_HANDLER.publish(enhanced);
                }
            }
            catch (Exception e) {
                CentralLogger.safeErr("[LOGGER ERROR] Failed to publish: " + e.getMessage());
            }
            finally {
                RECURSION_DEPTH.set(depth);
                if (depth == 0) {
                    EMERGENCY_MODE.set(false);
                }
            }
        }

        private boolean isDuplicate(LogRecord r) {
            String loggerName = r.getLoggerName() != null ? r.getLoggerName() : "";
            String msg = r.getMessage() != null ? r.getMessage() : "";
            String key = String.valueOf(r.getLevel()) + "|" + this.normalize(loggerName) + "|" + this.normalize(msg);
            long now = System.currentTimeMillis();
            Long prev = LAST_SEEN.put(key, now);
            return prev != null && now - prev <= 750L;
        }

        private String normalize(String s) {
            return s.replaceAll("\\s+", " ").trim();
        }

        private boolean isFromLoggingSystem(LogRecord r) {
            String name = r.getLoggerName();
            if (name == null) {
                return false;
            }
            return name.startsWith("com.raindropcentral.rplatform.logging") || "System.out".equals(name) || "System.err".equals(name) || name.contains("LoggingPrintStream") || name.contains("CentralLogger");
        }

        private boolean isNagMessage(LogRecord r) {
            String msg = r.getMessage();
            if (msg == null) {
                return false;
            }
            return msg.contains("Nag author") && msg.contains("System.out/err");
        }

        private LogRecord enhance(LogRecord original) {
            LogRecord out = new LogRecord(original.getLevel(), original.getMessage());
            out.setLoggerName(original.getLoggerName());
            out.setInstant(Instant.ofEpochMilli(original.getMillis()));
            out.setThrown(original.getThrown());
            out.setParameters(original.getParameters());
            out.setLongThreadID(original.getLongThreadID());
            try {
                if (original.getSourceClassName() != null) {
                    String fqcn = original.getSourceClassName();
                    out.setSourceClassName(this.shortClassName(fqcn));
                } else if (original.getLoggerName() != null) {
                    out.setSourceClassName(this.shortClassName(original.getLoggerName()));
                }
                if (original.getSourceMethodName() != null) {
                    out.setSourceMethodName(original.getSourceMethodName());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return out;
        }

        private String shortClassName(String fq) {
            int idx = fq.lastIndexOf(46);
            return idx >= 0 ? fq.substring(idx + 1) : fq;
        }

        @Override
        public void flush() {
            try {
                if (FILE_HANDLER != null) {
                    FILE_HANDLER.flush();
                }
                if (CONSOLE_HANDLER != null) {
                    CONSOLE_HANDLER.flush();
                }
            }
            catch (Exception e) {
                CentralLogger.safeErr("[LOGGER ERROR] Failed to flush: " + e.getMessage());
            }
        }

        @Override
        public void close() throws SecurityException {
        }
    }
}

