/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rplatform.localization;

import de.jexcellence.jextranslate.R18nManager;
import de.jexcellence.jextranslate.config.R18nConfiguration;
import de.jexcellence.jextranslate.core.TranslationMetrics;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Logger;
import net.kyori.adventure.platform.bukkit.BukkitAudiences;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TranslationManager {
    private static final Logger LOGGER = Logger.getLogger(TranslationManager.class.getName());
    private final JavaPlugin plugin;
    private final String defaultLocale;
    private final String[] supportedLocales;
    private final boolean enableMetrics;
    private final boolean enableFileWatcher;
    private R18nManager r18n;

    public TranslationManager(@NotNull JavaPlugin plugin) {
        this(plugin, "en_US", false, false, null, "en_US", "en_GB", "de_DE", "es_ES", "fr_FR", "ja_JP", "ko_KR", "zh_CN", "zh_TW", "pt_BR", "ru_RU", "it_IT", "nl_NL", "pl_PL", "tr_TR", "sv_SE", "no_NO", "da_DK");
    }

    public TranslationManager(@NotNull JavaPlugin plugin, @NotNull String defaultLocale, String ... supportedLocales) {
        this(plugin, defaultLocale, false, false, supportedLocales);
    }

    public TranslationManager(@NotNull JavaPlugin plugin, @NotNull String defaultLocale, boolean enableMetrics, boolean enableFileWatcher, String ... supportedLocales) {
        String[] stringArray;
        this.plugin = plugin;
        this.defaultLocale = defaultLocale;
        this.enableMetrics = enableMetrics;
        this.enableFileWatcher = enableFileWatcher;
        if (supportedLocales.length > 0) {
            stringArray = supportedLocales;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = defaultLocale;
        }
        this.supportedLocales = stringArray;
    }

    @NotNull
    public CompletableFuture<Void> initialize() {
        R18nConfiguration config = R18nConfiguration.defaultConfiguration().withAutoDetectLocales().withCacheEnabled(true).withCacheMaxSize(2000).withCacheExpireMinutes(60).withMetricsEnabled(this.enableMetrics).withMissingKeyHandler((key, locale, placeholders) -> {
            LOGGER.warning("Missing translation key: " + key + " for locale: " + locale);
            return "<gray>[" + key + "]</gray>";
        });
        R18nManager.Builder builder = R18nManager.builder(this.plugin).defaultLocale(this.defaultLocale).enableKeyValidation(true).enablePlaceholderAPI(true).translationDirectory("translations").enableFileWatcher(this.enableFileWatcher).configuration(config);
        this.r18n = builder.build();
        return this.r18n.initialize();
    }

    public void shutdown() {
        if (this.r18n != null) {
            this.r18n.shutdown();
            this.r18n = null;
        }
    }

    @NotNull
    public CompletableFuture<Void> reload() {
        if (this.r18n == null) {
            return CompletableFuture.failedFuture(new IllegalStateException("TranslationManager not initialized"));
        }
        return this.r18n.reload();
    }

    @Nullable
    public R18nManager getR18n() {
        return this.r18n;
    }

    @Nullable
    public BukkitAudiences getAudiences() {
        return this.r18n != null ? this.r18n.getAudiences() : null;
    }

    public boolean isInitialized() {
        return this.r18n != null && this.r18n.isInitialized();
    }

    @NotNull
    public String getDefaultLocale() {
        return this.defaultLocale;
    }

    public int getKeyCount() {
        return this.r18n != null ? this.r18n.getTranslationLoader().getTotalKeyCount() : 0;
    }

    public int getLocaleCount() {
        return this.r18n != null ? this.r18n.getTranslationLoader().getLoadedLocales().size() : 0;
    }

    @Nullable
    public TranslationMetrics getMetrics() {
        return this.r18n != null ? this.r18n.getMetrics() : null;
    }

    public boolean isFileWatcherEnabled() {
        return this.enableFileWatcher;
    }

    public boolean isMetricsEnabled() {
        return this.enableMetrics;
    }

    public static Builder builder(@NotNull JavaPlugin plugin) {
        return new Builder(plugin);
    }

    public static class Builder {
        private final JavaPlugin plugin;
        private String defaultLocale = "en_US";
        private String[] supportedLocales = new String[]{"en_US", "en_GB", "de_DE", "es_ES", "fr_FR", "ja_JP", "ko_KR", "zh_CN", "zh_TW", "pt_BR", "ru_RU", "it_IT", "nl_NL", "pl_PL", "tr_TR", "sv_SE", "no_NO", "da_DK"};
        private boolean enableMetrics = false;
        private boolean enableFileWatcher = false;

        public Builder(@NotNull JavaPlugin plugin) {
            this.plugin = plugin;
        }

        public Builder defaultLocale(@NotNull String locale) {
            this.defaultLocale = locale;
            return this;
        }

        public Builder supportedLocales(String ... locales) {
            this.supportedLocales = locales;
            return this;
        }

        public Builder enableMetrics(boolean enable) {
            this.enableMetrics = enable;
            return this;
        }

        public Builder enableFileWatcher(boolean enable) {
            this.enableFileWatcher = enable;
            return this;
        }

        public TranslationManager build() {
            return new TranslationManager(this.plugin, this.defaultLocale, this.enableMetrics, this.enableFileWatcher, this.supportedLocales);
        }
    }
}

