/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rplatform.integration.geyser;

import com.raindropcentral.rplatform.integration.geyser.FloodgateAdapter;
import com.raindropcentral.rplatform.service.ServiceRegistry;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GeyserService {
    private static final Logger LOGGER = Logger.getLogger(GeyserService.class.getName());
    private static final String FLOODGATE_API_CLASS = "org.geysermc.floodgate.api.FloodgateApi";
    private static final String FLOODGATE_UUID_PREFIX = "00000000";
    private final AtomicBoolean floodgateAvailable = new AtomicBoolean(false);
    private final AtomicBoolean uuidPrefixFallback = new AtomicBoolean(false);
    private final AtomicReference<FloodgateAdapter> floodgateAdapter = new AtomicReference<Object>(null);

    public GeyserService() {
        this.initialize(null);
    }

    public GeyserService(@Nullable ServiceRegistry registry) {
        this.initialize(registry);
    }

    private void initialize(@Nullable ServiceRegistry registry) {
        boolean pluginPresent;
        Plugin floodgatePlugin = Bukkit.getPluginManager().getPlugin("floodgate");
        Plugin geyserPlugin = Bukkit.getPluginManager().getPlugin("Geyser-Spigot");
        boolean bl = pluginPresent = floodgatePlugin != null || geyserPlugin != null;
        if (!pluginPresent) {
            LOGGER.info("No Geyser/Floodgate detected - Bedrock player detection unavailable");
            return;
        }
        if (floodgatePlugin != null) {
            this.tryLoadFloodgateApi(floodgatePlugin.getClass().getClassLoader());
        }
        if (!this.floodgateAvailable.get() && geyserPlugin != null) {
            this.tryLoadFloodgateApi(geyserPlugin.getClass().getClassLoader());
        }
        if (!this.floodgateAvailable.get()) {
            this.tryLoadFloodgateApi(this.getClass().getClassLoader());
        }
        if (!this.floodgateAvailable.get() && pluginPresent) {
            this.uuidPrefixFallback.set(true);
            LOGGER.info("Floodgate plugin detected but API not accessible - using UUID prefix detection");
        }
        if (registry != null && !this.floodgateAvailable.get()) {
            registry.register(FLOODGATE_API_CLASS, "floodgate").optional().maxAttempts(5).retryDelay(1000L).onSuccess(api -> {
                try {
                    this.floodgateAdapter.set(new FloodgateAdapter());
                    this.floodgateAvailable.set(true);
                    this.uuidPrefixFallback.set(false);
                    LOGGER.info("Floodgate API discovered via ServiceRegistry - Bedrock support enabled");
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, "Failed to create FloodgateAdapter after discovery", e);
                }
            }).load();
        }
    }

    private void tryLoadFloodgateApi(@NotNull ClassLoader classLoader) {
        try {
            Class.forName(FLOODGATE_API_CLASS, true, classLoader);
            this.floodgateAdapter.set(new FloodgateAdapter());
            this.floodgateAvailable.set(true);
            LOGGER.info("Floodgate API detected - Bedrock player support enabled");
        }
        catch (ClassNotFoundException | NoClassDefFoundError throwable) {
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Error initializing Floodgate adapter", e);
        }
    }

    public boolean isFloodgateAvailable() {
        return this.floodgateAvailable.get() || this.uuidPrefixFallback.get();
    }

    public boolean hasFloodgateApi() {
        return this.floodgateAvailable.get();
    }

    public boolean isBedrockPlayer(@NotNull Player player) {
        if (player == null) {
            return false;
        }
        return this.isBedrockPlayer(player.getUniqueId());
    }

    public boolean isBedrockPlayer(@NotNull UUID uuid) {
        if (uuid == null) {
            return false;
        }
        FloodgateAdapter adapter = this.floodgateAdapter.get();
        if (this.floodgateAvailable.get() && adapter != null) {
            try {
                return adapter.isFloodgatePlayer(uuid);
            }
            catch (Exception e) {
                LOGGER.log(Level.FINE, "Error checking Bedrock player via Floodgate API, falling back to UUID check", e);
            }
        }
        if (this.uuidPrefixFallback.get() || this.floodgateAvailable.get()) {
            return this.isFloodgateUuid(uuid);
        }
        return false;
    }

    private boolean isFloodgateUuid(@NotNull UUID uuid) {
        String uuidString = uuid.toString();
        return uuidString.startsWith(FLOODGATE_UUID_PREFIX);
    }

    @Nullable
    public String getBedrockUsername(@NotNull UUID uuid) {
        if (uuid == null) {
            return null;
        }
        FloodgateAdapter adapter = this.floodgateAdapter.get();
        if (this.floodgateAvailable.get() && adapter != null) {
            try {
                return adapter.getBedrockUsername(uuid);
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Error getting Bedrock username", e);
            }
        }
        return null;
    }
}

