/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rplatform.head;

import com.raindropcentral.rplatform.head.HeadCategory;
import java.util.UUID;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public abstract class CustomHead {
    private final String identifier;
    private final UUID textureUuid;
    private final String textureValue;
    private final HeadCategory category;
    private final String translationKey;

    protected CustomHead(@NotNull String identifier, @NotNull UUID textureUuid, @NotNull String textureValue, @NotNull HeadCategory category) {
        this.identifier = identifier;
        this.textureUuid = textureUuid;
        this.textureValue = textureValue;
        this.category = category;
        this.translationKey = "head." + identifier;
    }

    protected CustomHead(@NotNull String identifier, @NotNull String textureUuid, @NotNull String textureValue, @NotNull HeadCategory category) {
        this(identifier, UUID.fromString(textureUuid), textureValue, category);
    }

    protected CustomHead(@NotNull String identifier, @NotNull String textureUuid, @NotNull String textureValue) {
        this(identifier, textureUuid, textureValue, HeadCategory.INVENTORY);
    }

    @NotNull
    public abstract ItemStack createItem();

    @NotNull
    public String getIdentifier() {
        return this.identifier;
    }

    @NotNull
    public UUID getTextureUuid() {
        return this.textureUuid;
    }

    @NotNull
    public String getTextureValue() {
        return this.textureValue;
    }

    @NotNull
    public HeadCategory getCategory() {
        return this.category;
    }

    @NotNull
    public String getTranslationKey() {
        return this.translationKey;
    }
}

