/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rplatform.discord;

import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiscordWebhook {
    private static final Executor EXECUTOR = Executors.newCachedThreadPool();
    private static final String CONTENT_TYPE = "application/json";
    private static final String USER_AGENT = "RPlatform-Discord-Webhook/2.0";
    private static final int TIMEOUT_MS = 5000;
    private final Logger logger;
    private final String webhookUrl;

    public DiscordWebhook(@NotNull JavaPlugin plugin, @NotNull String webhookUrl) {
        this.logger = plugin.getLogger();
        this.webhookUrl = webhookUrl;
    }

    @NotNull
    public CompletableFuture<Boolean> sendMessage(@NotNull String content) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                String payload = this.buildJsonPayload(content);
                return this.sendPayload(payload);
            }
            catch (Exception e) {
                this.logger.log(Level.WARNING, "Failed to send Discord message", e);
                return false;
            }
        }, EXECUTOR);
    }

    @NotNull
    public CompletableFuture<Boolean> sendEmbed(@NotNull String title, @NotNull String description, int color) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                String payload = this.buildEmbedPayload(title, description, color);
                return this.sendPayload(payload);
            }
            catch (Exception e) {
                this.logger.log(Level.WARNING, "Failed to send Discord embed", e);
                return false;
            }
        }, EXECUTOR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean sendPayload(@NotNull String payload) throws Exception {
        HttpURLConnection connection = (HttpURLConnection)URI.create(this.webhookUrl).toURL().openConnection();
        try {
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", CONTENT_TYPE);
            connection.setRequestProperty("User-Agent", USER_AGENT);
            connection.setConnectTimeout(5000);
            connection.setReadTimeout(5000);
            connection.setDoOutput(true);
            try (OutputStream output = connection.getOutputStream();){
                output.write(payload.getBytes(StandardCharsets.UTF_8));
                output.flush();
            }
            int responseCode = connection.getResponseCode();
            boolean bl = responseCode >= 200 && responseCode < 300;
            return bl;
        }
        finally {
            connection.disconnect();
        }
    }

    @NotNull
    private String buildJsonPayload(@NotNull String content) {
        return String.format("{\"content\":\"%s\"}", this.escapeJson(content));
    }

    @NotNull
    private String buildEmbedPayload(@NotNull String title, @NotNull String description, int color) {
        return String.format("{\"embeds\":[{\"title\":\"%s\",\"description\":\"%s\",\"color\":%d}]}", this.escapeJson(title), this.escapeJson(description), color);
    }

    @NotNull
    private String escapeJson(@NotNull String text) {
        return text.replace("\\", "\\\\").replace("\"", "\\\"").replace("\n", "\\n").replace("\r", "\\r").replace("\t", "\\t");
    }

    public static final class Builder {
        private JavaPlugin plugin;
        private String webhookUrl;

        @NotNull
        public Builder plugin(@NotNull JavaPlugin plugin) {
            this.plugin = plugin;
            return this;
        }

        @NotNull
        public Builder webhookUrl(@NotNull String webhookUrl) {
            this.webhookUrl = webhookUrl;
            return this;
        }

        @Nullable
        public DiscordWebhook build() {
            if (this.plugin == null || this.webhookUrl == null || this.webhookUrl.isBlank()) {
                return null;
            }
            return new DiscordWebhook(this.plugin, this.webhookUrl);
        }
    }
}

