/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rplatform.database.converter;

import jakarta.persistence.AttributeConverter;
import jakarta.persistence.Converter;
import java.util.UUID;
import org.jetbrains.annotations.Nullable;

@Converter(autoApply=true)
public class UUIDConverter
implements AttributeConverter<UUID, String> {
    public String convertToDatabaseColumn(@Nullable UUID uuid) {
        return uuid == null ? null : uuid.toString();
    }

    public UUID convertToEntityAttribute(@Nullable String columnValue) {
        if (columnValue == null || columnValue.isBlank()) {
            return null;
        }
        try {
            return UUID.fromString(columnValue.trim());
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException("Invalid UUID string in column: '" + columnValue + "'", ex);
        }
    }
}

