/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rplatform.database.converter;

import jakarta.persistence.AttributeConverter;
import jakarta.persistence.Converter;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import org.bukkit.Material;
import org.jetbrains.annotations.Nullable;

@Converter(autoApply=true)
public class MaterialListConverter
implements AttributeConverter<List<Material>, String> {
    private static final String DELIM = ";";

    public String convertToDatabaseColumn(@Nullable List<Material> materials) {
        if (materials == null) {
            return null;
        }
        if (materials.isEmpty()) {
            return "";
        }
        return materials.stream().filter(Objects::nonNull).map(Enum::name).collect(Collectors.joining(DELIM));
    }

    public List<Material> convertToEntityAttribute(@Nullable String columnValue) {
        if (columnValue == null) {
            return null;
        }
        if (columnValue.isBlank()) {
            return new ArrayList<Material>();
        }
        String[] parts = columnValue.split(DELIM, -1);
        ArrayList<Material> result = new ArrayList<Material>(parts.length);
        for (String raw : parts) {
            String token;
            String string = token = raw == null ? "" : raw.trim();
            if (token.isEmpty()) continue;
            try {
                result.add(Material.valueOf((String)token.toUpperCase(Locale.ROOT)));
            }
            catch (IllegalArgumentException ex) {
                throw new IllegalArgumentException("Invalid Material in list: '" + raw + "'", ex);
            }
        }
        return result;
    }
}

