/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rplatform.database.converter;

import jakarta.persistence.AttributeConverter;
import jakarta.persistence.Converter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;

@Converter(autoApply=true)
public class LoreConverter
implements AttributeConverter<List<String>, String> {
    private static final String DELIM = ";";
    private static final Base64.Encoder B64_ENCODER = Base64.getEncoder();
    private static final Base64.Decoder B64_DECODER = Base64.getDecoder();

    public String convertToDatabaseColumn(@Nullable List<String> lore) {
        if (lore == null) {
            return null;
        }
        if (lore.isEmpty()) {
            return "";
        }
        return lore.stream().map(line -> {
            if (line == null) {
                return "";
            }
            byte[] bytes = line.getBytes(StandardCharsets.UTF_8);
            return B64_ENCODER.encodeToString(bytes);
        }).collect(Collectors.joining(DELIM));
    }

    public List<String> convertToEntityAttribute(@Nullable String columnValue) {
        if (columnValue == null) {
            return null;
        }
        if (columnValue.isBlank()) {
            return new ArrayList<String>();
        }
        String[] tokens = columnValue.split(DELIM, -1);
        ArrayList<String> result = new ArrayList<String>(tokens.length);
        for (String token : tokens) {
            if (token == null || token.isEmpty()) {
                result.add("");
                continue;
            }
            try {
                byte[] bytes = B64_DECODER.decode(token);
                result.add(new String(bytes, StandardCharsets.UTF_8));
            }
            catch (IllegalArgumentException ex) {
                throw new IllegalArgumentException("Invalid Base64 lore token encountered.", ex);
            }
        }
        return result;
    }
}

