/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rplatform.database.converter;

import jakarta.persistence.AttributeConverter;
import jakarta.persistence.Converter;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.jetbrains.annotations.Nullable;

@Converter(autoApply=true)
public class LocationConverter
implements AttributeConverter<Location, String> {
    private static final String DELIM = ";";

    public String convertToDatabaseColumn(@Nullable Location location) {
        if (location == null) {
            return null;
        }
        World world = location.getWorld();
        if (world == null) {
            throw new IllegalArgumentException("Location has no world; cannot persist.");
        }
        String worldId = world.getUID().toString();
        return worldId + DELIM + location.getX() + DELIM + location.getY() + DELIM + location.getZ() + DELIM + location.getYaw() + DELIM + location.getPitch();
    }

    public Location convertToEntityAttribute(@Nullable String columnValue) {
        if (columnValue == null || columnValue.isBlank()) {
            return null;
        }
        String[] tokens = columnValue.split(DELIM, -1);
        if (tokens.length != 6) {
            throw new IllegalArgumentException("Invalid Location token count: expected 6 but got " + tokens.length);
        }
        try {
            UUID worldUuid = UUID.fromString(tokens[0].trim());
            World world = Bukkit.getWorld((UUID)worldUuid);
            if (world == null) {
                throw new IllegalArgumentException("No world found for UUID: " + String.valueOf(worldUuid));
            }
            double x = Double.parseDouble(tokens[1].trim());
            double y = Double.parseDouble(tokens[2].trim());
            double z = Double.parseDouble(tokens[3].trim());
            float yaw = Float.parseFloat(tokens[4].trim());
            float pitch = Float.parseFloat(tokens[5].trim());
            return new Location(world, x, y, z, yaw, pitch);
        }
        catch (RuntimeException ex) {
            throw new IllegalArgumentException("Failed parsing Location from: '" + columnValue + "'", ex);
        }
    }
}

