/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rplatform.database.converter;

import jakarta.persistence.AttributeConverter;
import jakarta.persistence.Converter;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Nullable;

@Converter(autoApply=false)
public class ItemStackMapConverter
implements AttributeConverter<Map<String, ItemStack>, String> {
    private static final String ENTRY_DELIM = ";";
    private static final String KV_DELIM = ":";
    private static final Base64.Encoder B64_ENCODER = Base64.getEncoder();
    private static final Base64.Decoder B64_DECODER = Base64.getDecoder();

    public String convertToDatabaseColumn(@Nullable Map<String, ItemStack> map) {
        if (map == null) {
            return null;
        }
        if (map.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder(map.size() * 64);
        boolean first = true;
        for (Map.Entry<String, ItemStack> e : map.entrySet()) {
            String key = e.getKey();
            if (key == null) continue;
            String keyToken = B64_ENCODER.encodeToString(key.getBytes(StandardCharsets.UTF_8));
            ItemStack value = e.getValue();
            String valueToken = value == null || value.isEmpty() ? "" : B64_ENCODER.encodeToString(value.serializeAsBytes());
            if (!first) {
                sb.append(ENTRY_DELIM);
            } else {
                first = false;
            }
            sb.append(keyToken).append(KV_DELIM).append(valueToken);
        }
        return sb.toString();
    }

    public Map<String, ItemStack> convertToEntityAttribute(@Nullable String columnValue) {
        String[] entries;
        if (columnValue == null) {
            return null;
        }
        HashMap<String, ItemStack> result = new HashMap<String, ItemStack>();
        if (columnValue.isBlank()) {
            return result;
        }
        for (String entry : entries = columnValue.split(ENTRY_DELIM, -1)) {
            if (entry == null || entry.isEmpty()) continue;
            int sep = entry.indexOf(KV_DELIM);
            if (sep < 0) {
                throw new IllegalArgumentException("Invalid map entry (missing key/value delimiter): '" + entry + "'");
            }
            String keyToken = entry.substring(0, sep);
            String valueToken = entry.substring(sep + 1);
            try {
                String key = new String(B64_DECODER.decode(keyToken), StandardCharsets.UTF_8);
                ItemStack item = valueToken.isEmpty() ? new ItemStack(Material.AIR) : ItemStack.deserializeBytes((byte[])B64_DECODER.decode(valueToken));
                result.put(key, item);
            }
            catch (IllegalArgumentException ex) {
                throw new IllegalArgumentException("Invalid Base64 in map entry: '" + entry + "'", ex);
            }
        }
        return result;
    }
}

