/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rplatform.database.converter;

import jakarta.persistence.AttributeConverter;
import jakarta.persistence.Converter;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Nullable;

@Converter(autoApply=true)
public class ItemStackListConverter
implements AttributeConverter<List<ItemStack>, String> {
    private static final String DELIM = ";";
    private static final Base64.Encoder B64_ENCODER = Base64.getEncoder();
    private static final Base64.Decoder B64_DECODER = Base64.getDecoder();

    public String convertToDatabaseColumn(@Nullable List<ItemStack> items) {
        if (items == null) {
            return null;
        }
        if (items.isEmpty()) {
            return "";
        }
        return items.stream().filter(item -> item != null && !item.isEmpty()).map(item -> B64_ENCODER.encodeToString(item.serializeAsBytes())).collect(Collectors.joining(DELIM));
    }

    public List<ItemStack> convertToEntityAttribute(@Nullable String columnValue) {
        if (columnValue == null) {
            return null;
        }
        if (columnValue.isBlank()) {
            return new ArrayList<ItemStack>();
        }
        String[] parts = columnValue.split(DELIM, -1);
        ArrayList<ItemStack> result = new ArrayList<ItemStack>(parts.length);
        for (String part : parts) {
            String token;
            String string = token = part == null ? "" : part.trim();
            if (token.isEmpty()) {
                result.add(new ItemStack(Material.AIR));
                continue;
            }
            try {
                result.add(ItemStack.deserializeBytes((byte[])B64_DECODER.decode(token)));
            }
            catch (IllegalArgumentException ex) {
                throw new IllegalArgumentException("Invalid Base64 ItemStack in list.", ex);
            }
        }
        return result;
    }
}

