/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rplatform.database.converter;

import jakarta.persistence.AttributeConverter;
import jakarta.persistence.Converter;
import java.util.Base64;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Nullable;

@Converter(autoApply=true)
public class ItemStackConverter
implements AttributeConverter<ItemStack, String> {
    private static final Base64.Encoder B64_ENCODER = Base64.getEncoder();
    private static final Base64.Decoder B64_DECODER = Base64.getDecoder();

    public String convertToDatabaseColumn(@Nullable ItemStack itemStack) {
        if (itemStack == null) {
            return null;
        }
        if (itemStack.isEmpty()) {
            return "";
        }
        return B64_ENCODER.encodeToString(itemStack.serializeAsBytes());
    }

    public ItemStack convertToEntityAttribute(@Nullable String columnValue) {
        if (columnValue == null) {
            return null;
        }
        if (columnValue.isEmpty()) {
            return new ItemStack(Material.AIR);
        }
        try {
            return ItemStack.deserializeBytes((byte[])B64_DECODER.decode(columnValue));
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException("Invalid Base64 ItemStack data in column.", ex);
        }
    }
}

