/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rplatform.database.converter;

import jakarta.persistence.AttributeConverter;
import jakarta.persistence.Converter;
import org.bukkit.util.BoundingBox;
import org.jetbrains.annotations.Nullable;

@Converter(autoApply=true)
public class BoundingBoxConverter
implements AttributeConverter<BoundingBox, String> {
    private static final String DELIM = ",";

    public String convertToDatabaseColumn(@Nullable BoundingBox box) {
        if (box == null) {
            return null;
        }
        return box.getMinX() + DELIM + box.getMinY() + DELIM + box.getMinZ() + DELIM + box.getMaxX() + DELIM + box.getMaxY() + DELIM + box.getMaxZ();
    }

    public BoundingBox convertToEntityAttribute(@Nullable String columnValue) {
        if (columnValue == null || columnValue.isBlank()) {
            return null;
        }
        String[] tokens = columnValue.split(DELIM, -1);
        if (tokens.length != 6) {
            throw new IllegalArgumentException("Invalid BoundingBox token count: expected 6 but got " + tokens.length);
        }
        try {
            double minX = Double.parseDouble(tokens[0].trim());
            double minY = Double.parseDouble(tokens[1].trim());
            double minZ = Double.parseDouble(tokens[2].trim());
            double maxX = Double.parseDouble(tokens[3].trim());
            double maxY = Double.parseDouble(tokens[4].trim());
            double maxZ = Double.parseDouble(tokens[5].trim());
            return new BoundingBox(minX, minY, minZ, maxX, maxY, maxZ);
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException("Failed parsing BoundingBox numbers from: '" + columnValue + "'", ex);
        }
    }
}

