/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rplatform.database.converter;

import jakarta.persistence.AttributeConverter;
import jakarta.persistence.Converter;
import java.util.Locale;
import org.bukkit.Material;
import org.jetbrains.annotations.Nullable;

@Converter(autoApply=true)
public class BasicMaterialConverter
implements AttributeConverter<Material, String> {
    public String convertToDatabaseColumn(@Nullable Material material) {
        return material == null ? null : material.name();
    }

    public Material convertToEntityAttribute(@Nullable String columnValue) {
        if (columnValue == null || columnValue.isBlank()) {
            return null;
        }
        String normalized = columnValue.trim().toUpperCase(Locale.ROOT);
        try {
            return Material.valueOf((String)normalized);
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException("Invalid Material value in column: '" + columnValue + "'", ex);
        }
    }
}

