/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rplatform.console;

import de.jexcellence.jextranslate.i18n.I18n;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ConsoleMessenger {
    private final Logger logger;
    private final boolean withPrefix;

    public ConsoleMessenger(@NotNull Logger logger) {
        this(logger, true);
    }

    public ConsoleMessenger(@NotNull Logger logger, boolean withPrefix) {
        this.logger = Objects.requireNonNull(logger, "Logger cannot be null");
        this.withPrefix = withPrefix;
    }

    public void info(@NotNull String key, @NotNull Map<String, Object> placeholders) {
        this.log(Level.INFO, key, placeholders);
    }

    public void info(@NotNull String key) {
        this.log(Level.INFO, key, Map.of());
    }

    public void warn(@NotNull String key, @NotNull Map<String, Object> placeholders) {
        this.log(Level.WARNING, key, placeholders);
    }

    public void warn(@NotNull String key) {
        this.log(Level.WARNING, key, Map.of());
    }

    public void error(@NotNull String key, @NotNull Map<String, Object> placeholders) {
        this.log(Level.SEVERE, key, placeholders);
    }

    public void error(@NotNull String key) {
        this.log(Level.SEVERE, key, Map.of());
    }

    public void log(@NotNull Level level, @NotNull String key, @NotNull Map<String, Object> placeholders) {
        Objects.requireNonNull(level, "Level cannot be null");
        Objects.requireNonNull(key, "Key cannot be null");
        Objects.requireNonNull(placeholders, "Placeholders cannot be null");
        try {
            String message = this.translate(key, placeholders);
            this.logger.log(level, message);
        }
        catch (Exception exception) {
            this.logger.log(Level.WARNING, "Failed to render console translation for key: " + key, exception);
            this.logger.log(level, "[" + key + "]");
        }
    }

    @NotNull
    public String translate(@NotNull String key, @NotNull Map<String, Object> placeholders) {
        I18n i18n;
        Object component;
        Objects.requireNonNull(key, "Key cannot be null");
        Objects.requireNonNull(placeholders, "Placeholders cannot be null");
        I18n.Builder builder = new I18n.Builder(key);
        if (!placeholders.isEmpty()) {
            builder.withPlaceholders(placeholders);
        }
        if (this.withPrefix) {
            builder.includePrefix();
        }
        if ((component = (i18n = builder.build()).component()) instanceof Component) {
            Component adventureComponent = (Component)component;
            return PlainTextComponentSerializer.plainText().serialize(adventureComponent);
        }
        if (component instanceof String) {
            String string = (String)component;
            return string;
        }
        return component != null ? component.toString() : "[" + key + "]";
    }

    @NotNull
    public static Map<String, Object> placeholders() {
        return new HashMap<String, Object>();
    }

    @NotNull
    public static Map<String, Object> placeholder(@NotNull String key, @Nullable Object value) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(key, value);
        return map;
    }
}

