/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rplatform.config.permission;

import com.raindropcentral.rplatform.config.DurationSection;
import com.raindropcentral.rplatform.config.permission.APermissionBasedSection;
import de.jexcellence.configmapper.sections.CSAlways;
import de.jexcellence.gpeee.interpreter.EvaluationEnvironmentBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.bukkit.entity.Player;

@CSAlways
public class PermissionDurationSection
extends APermissionBasedSection<Long> {
    private DurationSection defaultDuration;
    private Map<String, DurationSection> permissionDurations;
    private DurationSection maxDuration;
    private DurationSection minDuration;

    public PermissionDurationSection(EvaluationEnvironmentBuilder evaluationEnvironmentBuilder) {
        super(evaluationEnvironmentBuilder);
    }

    public Long getDefaultDurationSeconds() {
        return this.getDefaultValue() == null ? 0L : this.getDefaultValue();
    }

    public DurationSection getDefaultDuration() {
        return this.defaultDuration != null ? this.defaultDuration : new DurationSection(new EvaluationEnvironmentBuilder());
    }

    public Map<String, Long> getPermissionDurationsSeconds() {
        return this.getPermissionValues();
    }

    public Map<String, DurationSection> getPermissionDurations() {
        HashMap<String, DurationSection> durations = new HashMap<String, DurationSection>();
        if (this.permissionDurations != null) {
            durations.putAll(this.permissionDurations);
        }
        return durations;
    }

    public Long getMaxDurationSeconds() {
        if (this.maxDuration != null && this.maxDuration.hasDuration()) {
            return this.maxDuration.getSeconds();
        }
        return null;
    }

    public Long getMinDurationSeconds() {
        if (this.minDuration != null && this.minDuration.hasDuration()) {
            return this.minDuration.getSeconds();
        }
        return null;
    }

    public DurationSection getMaxDuration() {
        return this.maxDuration;
    }

    public DurationSection getMinDuration() {
        return this.minDuration;
    }

    public Long getEffectiveDuration(Player player) {
        return (Long)this.getEffectiveValue(player);
    }

    public Long getEffectiveDuration(Set<String> playerPermissions) {
        return (Long)this.getEffectiveValue(playerPermissions);
    }

    public String getFormattedEffectiveDuration(Player player) {
        if (player == null) {
            return this.getFormattedEffectiveDuration((Set<String>)null);
        }
        Set<String> playerPermissions = this.extractPlayerPermissions(player);
        return this.getFormattedEffectiveDuration(playerPermissions);
    }

    public String getFormattedEffectiveDuration(Set<String> playerPermissions) {
        DurationSection defaultDuration;
        Long seconds = this.getEffectiveDuration(playerPermissions);
        if (seconds == 0L) {
            return "Permanent";
        }
        if (playerPermissions != null) {
            Map<String, DurationSection> durations = this.getPermissionDurations();
            for (String permission : playerPermissions) {
                DurationSection duration = durations.get(permission);
                if (duration == null || !duration.hasDuration()) continue;
                return duration.getFormattedDuration();
            }
        }
        if ((defaultDuration = this.getDefaultDuration()) != null && defaultDuration.hasDuration()) {
            return defaultDuration.getFormattedDuration();
        }
        return this.formatSeconds(seconds);
    }

    public Long getDurationForPermission(String permission) {
        return (Long)this.getValueForPermission(permission);
    }

    public DurationSection getDurationSectionForPermission(String permission) {
        if (permission == null || permission.trim().isEmpty()) {
            return null;
        }
        Map<String, DurationSection> durations = this.getPermissionDurations();
        return durations.get(permission);
    }

    public boolean hasPermissionDurations() {
        return this.hasPermissionValues();
    }

    public boolean isDurationWithinBounds(Long durationSeconds) {
        if (durationSeconds == null) {
            return false;
        }
        Long minDuration = this.getMinDurationSeconds();
        Long maxDuration = this.getMaxDurationSeconds();
        if (minDuration != null && durationSeconds < minDuration) {
            return false;
        }
        return maxDuration == null || durationSeconds <= maxDuration;
    }

    public Long clampDuration(Long durationSeconds) {
        if (durationSeconds == null) {
            return this.getDefaultDurationSeconds();
        }
        Long result = durationSeconds;
        Long minDuration = this.getMinDurationSeconds();
        Long maxDuration = this.getMaxDurationSeconds();
        if (minDuration != null && result < minDuration) {
            result = minDuration;
        }
        if (maxDuration != null && result > maxDuration) {
            result = maxDuration;
        }
        return result;
    }

    @Override
    protected Long getDefaultValue() {
        if (this.defaultDuration != null && this.defaultDuration.hasDuration()) {
            return this.defaultDuration.getSeconds();
        }
        return 0L;
    }

    @Override
    protected Map<String, Long> getPermissionValues() {
        HashMap<String, Long> durations = new HashMap<String, Long>();
        if (this.permissionDurations != null) {
            for (Map.Entry<String, DurationSection> entry : this.permissionDurations.entrySet()) {
                if (entry.getValue() == null) continue;
                durations.put(entry.getKey(), entry.getValue().getSeconds());
            }
        }
        return durations;
    }

    @Override
    protected boolean getDefaultUseBestValue() {
        return true;
    }

    @Override
    protected Long chooseBestValue(Long current, Long candidate) {
        return Math.max(current, candidate);
    }

    @Override
    protected boolean isBetterValue(Long candidate, Long current) {
        return candidate > current;
    }

    @Override
    protected Long applyBounds(Long value) {
        return this.clampDuration(value);
    }

    @Override
    protected boolean isValidValue(Long value) {
        return value != null && value >= 0L;
    }

    @Override
    protected void performAdditionalValidation() {
        if (this.defaultDuration != null) {
            this.defaultDuration.validate();
        }
        if (this.minDuration != null) {
            this.minDuration.validate();
        }
        if (this.maxDuration != null) {
            this.maxDuration.validate();
        }
        Long minDuration = this.getMinDurationSeconds();
        Long maxDuration = this.getMaxDurationSeconds();
        if (minDuration != null && minDuration < 0L) {
            throw new IllegalStateException("Minimum duration cannot be negative: " + minDuration);
        }
        if (maxDuration != null && maxDuration < 0L) {
            throw new IllegalStateException("Maximum duration cannot be negative: " + maxDuration);
        }
        if (minDuration != null && maxDuration != null && minDuration > maxDuration) {
            throw new IllegalStateException("Minimum duration (" + minDuration + ") cannot be greater than maximum duration (" + maxDuration + ")");
        }
        Map<String, DurationSection> durations = this.getPermissionDurations();
        for (Map.Entry<String, DurationSection> entry : durations.entrySet()) {
            if (entry.getValue() == null) continue;
            entry.getValue().validate();
        }
    }

    private String formatSeconds(long totalSeconds) {
        if (totalSeconds == 0L) {
            return "Permanent";
        }
        StringBuilder sb = new StringBuilder();
        long days = totalSeconds / 86400L;
        long hours = totalSeconds % 86400L / 3600L;
        long minutes = totalSeconds % 3600L / 60L;
        long seconds = totalSeconds % 60L;
        if (days > 0L) {
            sb.append(days).append(days == 1L ? " day" : " days");
        }
        if (hours > 0L) {
            if (!sb.isEmpty()) {
                sb.append(" ");
            }
            sb.append(hours).append(hours == 1L ? " hour" : " hours");
        }
        if (minutes > 0L) {
            if (!sb.isEmpty()) {
                sb.append(" ");
            }
            sb.append(minutes).append(minutes == 1L ? " minute" : " minutes");
        }
        if (seconds > 0L) {
            if (!sb.isEmpty()) {
                sb.append(" ");
            }
            sb.append(seconds).append(seconds == 1L ? " second" : " seconds");
        }
        return sb.toString();
    }
}

