/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rplatform.config.permission;

import com.raindropcentral.rplatform.config.permission.APermissionBasedSection;
import de.jexcellence.configmapper.sections.CSAlways;
import de.jexcellence.gpeee.interpreter.EvaluationEnvironmentBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.bukkit.entity.Player;

@CSAlways
public class PermissionAmplifierSection
extends APermissionBasedSection<Integer> {
    private Integer defaultAmplifier;
    private Map<String, Integer> permissionAmplifiers;
    private Integer maxAmplifier;
    private Integer minAmplifier;

    public PermissionAmplifierSection(EvaluationEnvironmentBuilder evaluationEnvironmentBuilder) {
        super(evaluationEnvironmentBuilder);
    }

    public Integer getDefaultAmplifier() {
        return this.getDefaultValue();
    }

    public Map<String, Integer> getPermissionAmplifiers() {
        return this.getPermissionValues();
    }

    public Integer getAmplifierForPermission(String permission) {
        return (Integer)this.getValueForPermission(permission);
    }

    public boolean hasPermissionAmplifiers() {
        return this.hasPermissionValues();
    }

    public Integer getEffectiveAmplifier(Player player) {
        return (Integer)this.getEffectiveValue(player);
    }

    public Integer getEffectiveAmplifier(Set<String> playerPermissions) {
        return (Integer)this.getEffectiveValue(playerPermissions);
    }

    public Integer getMaxAmplifier() {
        return this.maxAmplifier;
    }

    public Integer getMinAmplifier() {
        return this.minAmplifier;
    }

    public boolean isAmplifierWithinBounds(Integer amplifier) {
        if (amplifier == null) {
            return false;
        }
        if (this.minAmplifier != null && amplifier < this.minAmplifier) {
            return false;
        }
        return this.maxAmplifier == null || amplifier <= this.maxAmplifier;
    }

    public Integer clampAmplifier(Integer amplifier) {
        if (amplifier == null) {
            return this.getDefaultAmplifier();
        }
        Integer result = amplifier;
        if (this.minAmplifier != null && result < this.minAmplifier) {
            result = this.minAmplifier;
        }
        if (this.maxAmplifier != null && result > this.maxAmplifier) {
            result = this.maxAmplifier;
        }
        return result;
    }

    @Override
    protected Integer getDefaultValue() {
        if (this.defaultAmplifier != null) {
            return this.defaultAmplifier;
        }
        return 0;
    }

    @Override
    protected Map<String, Integer> getPermissionValues() {
        HashMap<String, Integer> amplifiers = new HashMap<String, Integer>();
        if (this.permissionAmplifiers != null) {
            amplifiers.putAll(this.permissionAmplifiers);
        }
        return amplifiers;
    }

    @Override
    protected boolean getDefaultUseBestValue() {
        return true;
    }

    @Override
    protected Integer chooseBestValue(Integer current, Integer candidate) {
        return Math.max(current, candidate);
    }

    @Override
    protected boolean isBetterValue(Integer candidate, Integer current) {
        return candidate > current;
    }

    @Override
    protected Integer applyBounds(Integer value) {
        return this.clampAmplifier(value);
    }

    @Override
    protected boolean isValidValue(Integer value) {
        return value != null && value >= 0;
    }

    @Override
    protected void performAdditionalValidation() {
        if (this.minAmplifier != null && this.minAmplifier < 0) {
            throw new IllegalStateException("Minimum amplifier cannot be negative: " + this.minAmplifier);
        }
        if (this.maxAmplifier != null && this.maxAmplifier < 0) {
            throw new IllegalStateException("Maximum amplifier cannot be negative: " + this.maxAmplifier);
        }
        if (this.minAmplifier != null && this.maxAmplifier != null && this.minAmplifier > this.maxAmplifier) {
            throw new IllegalStateException("Minimum amplifier (" + this.minAmplifier + ") cannot be greater than maximum amplifier (" + this.maxAmplifier + ")");
        }
    }
}

