/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rplatform.config.permission;

import de.jexcellence.configmapper.sections.AConfigSection;
import de.jexcellence.configmapper.sections.CSAlways;
import de.jexcellence.gpeee.interpreter.EvaluationEnvironmentBuilder;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.bukkit.entity.Player;
import org.bukkit.permissions.PermissionAttachmentInfo;

@CSAlways
public abstract class APermissionBasedSection<T>
extends AConfigSection {
    private Boolean enabled;
    private Boolean useBestValue;

    protected APermissionBasedSection(EvaluationEnvironmentBuilder evaluationEnvironmentBuilder) {
        super(evaluationEnvironmentBuilder);
    }

    public Boolean getEnabled() {
        return this.enabled != null ? this.enabled : true;
    }

    public Boolean getUseBestValue() {
        return this.useBestValue != null ? this.useBestValue.booleanValue() : this.getDefaultUseBestValue();
    }

    public T getEffectiveValue(Player player) {
        if (player == null) {
            return this.getDefaultValue();
        }
        return this.getEffectiveValue(this.extractPlayerPermissions(player));
    }

    public T getEffectiveValue(Set<String> playerPermissions) {
        if (!this.getEnabled().booleanValue()) {
            return this.getDefaultValue();
        }
        if (playerPermissions == null || playerPermissions.isEmpty()) {
            return this.getDefaultValue();
        }
        Map<String, T> permissionValues = this.getPermissionValues();
        if (permissionValues.isEmpty()) {
            return this.getDefaultValue();
        }
        Object effectiveValue = null;
        for (String permission : playerPermissions) {
            T value = permissionValues.get(permission);
            if (value == null) continue;
            if (effectiveValue == null) {
                effectiveValue = value;
                continue;
            }
            if (!this.getUseBestValue().booleanValue()) continue;
            effectiveValue = this.chooseBestValue(effectiveValue, value);
        }
        Object result = effectiveValue != null ? effectiveValue : this.getDefaultValue();
        return this.applyBounds(result);
    }

    public String getEffectivePermission(Player player) {
        if (player == null) {
            return null;
        }
        Set<String> playerPermissions = this.extractPlayerPermissions(player);
        Map<String, T> permissionValues = this.getPermissionValues();
        if (permissionValues.isEmpty()) {
            return null;
        }
        String effectivePermission = null;
        T effectiveValue = null;
        for (String permission : playerPermissions) {
            T value = permissionValues.get(permission);
            if (value == null) continue;
            if (effectiveValue == null) {
                effectivePermission = permission;
                effectiveValue = value;
                continue;
            }
            if (this.getUseBestValue().booleanValue() && this.isBetterValue(value, effectiveValue)) {
                effectivePermission = permission;
                effectiveValue = value;
                continue;
            }
            if (this.getUseBestValue().booleanValue()) continue;
            break;
        }
        return effectivePermission;
    }

    public boolean hasRelevantPermissions(Player player) {
        if (player == null) {
            return false;
        }
        Set<String> playerPermissions = this.extractPlayerPermissions(player);
        Map<String, T> permissionValues = this.getPermissionValues();
        for (String permission : playerPermissions) {
            if (!permissionValues.containsKey(permission)) continue;
            return true;
        }
        return false;
    }

    public T getValueForPermission(String permission) {
        if (permission == null || permission.trim().isEmpty()) {
            return null;
        }
        Map<String, T> values = this.getPermissionValues();
        return values.get(permission);
    }

    public boolean hasPermissionValues() {
        return !this.getPermissionValues().isEmpty();
    }

    protected Set<String> extractPlayerPermissions(Player player) {
        HashSet<String> relevantPermissions = new HashSet<String>();
        Map<String, T> configuredValues = this.getPermissionValues();
        if (configuredValues.isEmpty()) {
            return relevantPermissions;
        }
        Set playerPermissions = player.getEffectivePermissions();
        for (PermissionAttachmentInfo permissionInfo : playerPermissions) {
            if (!permissionInfo.getValue()) continue;
            String permission = permissionInfo.getPermission();
            if (configuredValues.containsKey(permission)) {
                relevantPermissions.add(permission);
                continue;
            }
            for (String configuredPermission : configuredValues.keySet()) {
                if (!this.matchesWildcard(permission, configuredPermission)) continue;
                relevantPermissions.add(configuredPermission);
            }
        }
        return relevantPermissions;
    }

    protected boolean matchesWildcard(String playerPermission, String configuredPermission) {
        if (playerPermission == null || configuredPermission == null) {
            return false;
        }
        if (playerPermission.equals(configuredPermission)) {
            return true;
        }
        if (configuredPermission.endsWith("*")) {
            String prefix = configuredPermission.substring(0, configuredPermission.length() - 1);
            return playerPermission.startsWith(prefix);
        }
        if (playerPermission.endsWith("*")) {
            String prefix = playerPermission.substring(0, playerPermission.length() - 1);
            return configuredPermission.startsWith(prefix);
        }
        return false;
    }

    public void validate() {
        T defaultValue = this.getDefaultValue();
        if (!this.isValidValue(defaultValue)) {
            throw new IllegalStateException("Invalid default value: " + String.valueOf(defaultValue));
        }
        Map<String, T> permissionValues = this.getPermissionValues();
        for (Map.Entry<String, T> entry : permissionValues.entrySet()) {
            if (entry.getKey() == null || entry.getKey().trim().isEmpty()) {
                throw new IllegalStateException("Permission cannot be null or empty");
            }
            if (this.isValidValue(entry.getValue())) continue;
            throw new IllegalStateException("Invalid value for permission '" + entry.getKey() + "': " + String.valueOf(entry.getValue()));
        }
        this.performAdditionalValidation();
    }

    protected abstract T getDefaultValue();

    protected abstract Map<String, T> getPermissionValues();

    protected abstract boolean getDefaultUseBestValue();

    protected abstract T chooseBestValue(T var1, T var2);

    protected abstract boolean isBetterValue(T var1, T var2);

    protected T applyBounds(T value) {
        return value;
    }

    protected boolean isValidValue(T value) {
        return value != null;
    }

    protected void performAdditionalValidation() {
    }
}

