/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rplatform.config;

import de.jexcellence.configmapper.sections.AConfigSection;
import de.jexcellence.configmapper.sections.CSAlways;
import de.jexcellence.gpeee.interpreter.EvaluationEnvironmentBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@CSAlways
public class DurationSection
extends AConfigSection {
    private static final Pattern DURATION_PATTERN = Pattern.compile("(?:(\\d+)\\s*(?:w|week|weeks)\\s*)?(?:(\\d+)\\s*(?:d|day|days)\\s*)?(?:(\\d+)\\s*(?:h|hr|hour|hours)\\s*)?(?:(\\d+)\\s*(?:m|min|minute|minutes)\\s*)?(?:(\\d+)\\s*(?:s|sec|second|seconds)\\s*)?", 2);
    private static final Pattern NUMBER_PATTERN = Pattern.compile("^\\d+$");
    private static final Map<String, Long> TIME_UNITS = new HashMap<String, Long>();
    private String duration;
    private String time;
    private String period;
    private Long seconds;
    private Long minutes;
    private Long hours;
    private Long days;

    public DurationSection(@NotNull EvaluationEnvironmentBuilder evaluationEnvironmentBuilder) {
        super(evaluationEnvironmentBuilder);
    }

    @Nullable
    public String getRawDuration() {
        if (this.duration != null && !this.duration.trim().isEmpty()) {
            return this.duration.trim();
        }
        if (this.time != null && !this.time.trim().isEmpty()) {
            return this.time.trim();
        }
        if (this.period != null && !this.period.trim().isEmpty()) {
            return this.period.trim();
        }
        return null;
    }

    @NotNull
    public Long getSeconds() {
        Long parsed;
        String rawDuration = this.getRawDuration();
        if (rawDuration != null && (parsed = this.parseDurationString(rawDuration)) != null) {
            return parsed;
        }
        if (this.seconds != null) {
            return this.seconds;
        }
        if (this.minutes != null) {
            return this.minutes * 60L;
        }
        if (this.hours != null) {
            return this.hours * 3600L;
        }
        if (this.days != null) {
            return this.days * 86400L;
        }
        return 0L;
    }

    @NotNull
    public Long getMilliseconds() {
        return this.getSeconds() * 1000L;
    }

    @NotNull
    public Long getMinutes() {
        return this.getSeconds() / 60L;
    }

    @NotNull
    public Long getHours() {
        return this.getSeconds() / 3600L;
    }

    @NotNull
    public Long getDays() {
        return this.getSeconds() / 86400L;
    }

    @Nullable
    private Long parseDurationString(@Nullable String durationStr) {
        if (durationStr == null || durationStr.trim().isEmpty()) {
            return null;
        }
        String trimmed = durationStr.trim().toLowerCase();
        if (NUMBER_PATTERN.matcher(trimmed).matches()) {
            try {
                return Long.parseLong(trimmed);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        Matcher matcher = DURATION_PATTERN.matcher(trimmed);
        if (!matcher.matches()) {
            return this.parseSimpleDuration(trimmed);
        }
        long totalSeconds = this.getTotalSeconds(matcher);
        return totalSeconds > 0L ? Long.valueOf(totalSeconds) : null;
    }

    private long getTotalSeconds(@NotNull Matcher matcher) {
        long totalSeconds = 0L;
        if (matcher.group(1) != null) {
            totalSeconds += Long.parseLong(matcher.group(1)) * 604800L;
        }
        if (matcher.group(2) != null) {
            totalSeconds += Long.parseLong(matcher.group(2)) * 86400L;
        }
        if (matcher.group(3) != null) {
            totalSeconds += Long.parseLong(matcher.group(3)) * 3600L;
        }
        if (matcher.group(4) != null) {
            totalSeconds += Long.parseLong(matcher.group(4)) * 60L;
        }
        if (matcher.group(5) != null) {
            totalSeconds += Long.parseLong(matcher.group(5));
        }
        return totalSeconds;
    }

    @Nullable
    private Long parseSimpleDuration(@NotNull String durationStr) {
        Pattern simplePattern = Pattern.compile("^(\\d+)\\s*([a-z]+)$", 2);
        Matcher matcher = simplePattern.matcher(durationStr);
        if (!matcher.matches()) {
            return null;
        }
        try {
            long value = Long.parseLong(matcher.group(1));
            String unit = matcher.group(2).toLowerCase();
            Long multiplier = TIME_UNITS.get(unit);
            if (multiplier != null) {
                return value * multiplier;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return null;
    }

    public boolean hasDuration() {
        return this.getSeconds() > 0L;
    }

    @NotNull
    public String getFormattedDuration() {
        long totalSeconds = this.getSeconds();
        if (totalSeconds == 0L) {
            return "0 seconds";
        }
        StringBuilder sb = new StringBuilder();
        long days = totalSeconds / 86400L;
        long hours = totalSeconds % 86400L / 3600L;
        long minutes = totalSeconds % 3600L / 60L;
        long seconds = totalSeconds % 60L;
        if (days > 0L) {
            sb.append(days).append(days == 1L ? " day" : " days");
        }
        if (hours > 0L) {
            if (!sb.isEmpty()) {
                sb.append(" ");
            }
            sb.append(hours).append(hours == 1L ? " hour" : " hours");
        }
        if (minutes > 0L) {
            if (!sb.isEmpty()) {
                sb.append(" ");
            }
            sb.append(minutes).append(minutes == 1L ? " minute" : " minutes");
        }
        if (seconds > 0L) {
            if (!sb.isEmpty()) {
                sb.append(" ");
            }
            sb.append(seconds).append(seconds == 1L ? " second" : " seconds");
        }
        return sb.toString();
    }

    public void validate() {
        Long seconds = this.getSeconds();
        if (seconds < 0L) {
            throw new IllegalStateException("Duration cannot be negative: " + seconds + " seconds");
        }
        String rawDuration = this.getRawDuration();
        if (rawDuration != null && this.parseDurationString(rawDuration) == null) {
            throw new IllegalStateException("Invalid duration format: " + rawDuration);
        }
    }

    static {
        TIME_UNITS.put("s", 1L);
        TIME_UNITS.put("sec", 1L);
        TIME_UNITS.put("second", 1L);
        TIME_UNITS.put("seconds", 1L);
        TIME_UNITS.put("m", 60L);
        TIME_UNITS.put("min", 60L);
        TIME_UNITS.put("minute", 60L);
        TIME_UNITS.put("minutes", 60L);
        TIME_UNITS.put("h", 3600L);
        TIME_UNITS.put("hr", 3600L);
        TIME_UNITS.put("hour", 3600L);
        TIME_UNITS.put("hours", 3600L);
        TIME_UNITS.put("d", 86400L);
        TIME_UNITS.put("day", 86400L);
        TIME_UNITS.put("days", 86400L);
        TIME_UNITS.put("w", 604800L);
        TIME_UNITS.put("week", 604800L);
        TIME_UNITS.put("weeks", 604800L);
    }
}

