/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rplatform.api.luckperms;

import com.raindropcentral.rplatform.RPlatform;
import com.raindropcentral.rplatform.api.luckperms.IRank;
import com.raindropcentral.rplatform.logging.CentralLogger;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import net.luckperms.api.LuckPerms;
import net.luckperms.api.LuckPermsProvider;
import net.luckperms.api.model.group.Group;
import net.luckperms.api.model.user.User;
import net.luckperms.api.model.user.UserManager;
import net.luckperms.api.node.Node;
import net.luckperms.api.node.NodeType;
import net.luckperms.api.node.ScopedNode;
import net.luckperms.api.node.types.DisplayNameNode;
import net.luckperms.api.node.types.InheritanceNode;
import net.luckperms.api.node.types.PermissionNode;
import net.luckperms.api.node.types.PrefixNode;
import net.luckperms.api.node.types.SuffixNode;
import net.luckperms.api.node.types.WeightNode;
import net.luckperms.api.query.QueryOptions;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LuckPermsService {
    private static final Logger LOGGER = CentralLogger.getLogger(LuckPermsService.class.getName());
    private final RPlatform platform;

    public LuckPermsService(@NotNull RPlatform platform) {
        this.platform = platform;
    }

    @Nullable
    public User getLuckPermsUser(@NotNull UUID uuid) {
        if (Bukkit.getPlayer((UUID)uuid) == null) {
            return null;
        }
        return this.get().getUserManager().getUser(uuid);
    }

    @Nullable
    public User getLuckPermsUser(@NotNull OfflinePlayer offlinePlayer) {
        UserManager userManager = this.get().getUserManager();
        try {
            return (User)userManager.loadUser(offlinePlayer.getUniqueId()).join();
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, "Failed to load LuckPerms user for offline player " + String.valueOf(offlinePlayer.getUniqueId()), exception);
            return null;
        }
    }

    @NotNull
    public String getPrefix(@NotNull UUID uuid) {
        User user = this.getLuckPermsUser(uuid);
        if (user != null) {
            String prefix = user.getCachedData().getMetaData(QueryOptions.defaultContextualOptions()).getPrefix();
            return prefix != null ? prefix : "";
        }
        OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)uuid);
        User offlineUser = this.getLuckPermsUser(offlinePlayer);
        if (offlineUser != null) {
            String prefix = offlineUser.getCachedData().getMetaData(QueryOptions.defaultContextualOptions()).getPrefix();
            return prefix != null ? prefix : "";
        }
        return "";
    }

    @NotNull
    public String getSuffix(@NotNull UUID uuid) {
        User user = this.getLuckPermsUser(uuid);
        if (user != null) {
            String suffix = user.getCachedData().getMetaData(QueryOptions.defaultContextualOptions()).getSuffix();
            return suffix != null ? suffix : "";
        }
        OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)uuid);
        User offlineUser = this.getLuckPermsUser(offlinePlayer);
        if (offlineUser != null) {
            String suffix = offlineUser.getCachedData().getMetaData(QueryOptions.defaultContextualOptions()).getSuffix();
            return suffix != null ? suffix : "";
        }
        return "";
    }

    public void applyRank(@NotNull UUID uuid, @NotNull String group) {
        this.checkArguments(uuid, group);
        User user = this.requireUser(uuid);
        InheritanceNode node = (InheritanceNode)((InheritanceNode.Builder)InheritanceNode.builder((String)group.toLowerCase(Locale.ENGLISH)).value(true)).build();
        user.data().add((Node)node);
        this.saveUserAsync(user);
    }

    public void removeRank(@NotNull UUID uuid, @NotNull String group) {
        this.checkArguments(uuid, group);
        User user = this.requireUser(uuid);
        InheritanceNode node = (InheritanceNode)((InheritanceNode.Builder)InheritanceNode.builder((String)group.toLowerCase(Locale.ENGLISH)).value(true)).build();
        user.data().remove((Node)node);
        this.saveUserAsync(user);
    }

    public CompletableFuture<Boolean> assignPermission(@NotNull String groupName, @NotNull String permission) {
        return ((CompletableFuture)((CompletableFuture)this.get().getGroupManager().loadGroup(groupName).thenComposeAsync(optionalGroup -> {
            if (optionalGroup.isPresent()) {
                return CompletableFuture.completedFuture((Group)optionalGroup.get());
            }
            LOGGER.info("Group '" + groupName + "' doesn't exist, creating it...");
            return this.get().getGroupManager().createAndLoadGroup(groupName);
        })).thenApplyAsync(group -> {
            PermissionNode node = (PermissionNode)PermissionNode.builder((String)permission).build();
            group.data().add((Node)node);
            this.saveGroupAsync((Group)group);
            LOGGER.info("Assigned permission '" + permission + "' to group '" + groupName + "'");
            return true;
        })).exceptionally(ex -> {
            LOGGER.log(Level.SEVERE, "Error assigning permission to group " + groupName + ": " + ex.getMessage());
            return false;
        });
    }

    public CompletableFuture<Group> createGroup(@NotNull String groupName) {
        return ((CompletableFuture)this.get().getGroupManager().loadGroup(groupName).thenComposeAsync(optionalGroup -> {
            if (optionalGroup.isPresent()) {
                LOGGER.info("Group '" + groupName + "' already exists");
                return CompletableFuture.completedFuture((Group)optionalGroup.get());
            }
            LOGGER.info("Creating group '" + groupName + "'...");
            return this.get().getGroupManager().createAndLoadGroup(groupName);
        })).thenApplyAsync(group -> {
            this.saveGroupAsync((Group)group);
            LOGGER.info("Group '" + groupName + "' is ready");
            return group;
        });
    }

    public CompletableFuture<Boolean> groupExists(@NotNull String groupName) {
        return this.get().getGroupManager().loadGroup(groupName).thenApply(Optional::isPresent);
    }

    @NotNull
    public Set<String> getPlayerGroups(@NotNull Player player) {
        User user = this.requireUser(player.getUniqueId());
        return this.getGroupNamesFromUser(user);
    }

    @NotNull
    public Set<String> getPlayerGroups(@NotNull OfflinePlayer player) {
        User user = this.requireUser(player);
        return this.getGroupNamesFromUser(user);
    }

    @Deprecated
    @NotNull
    public Collection<String> getPlayerGroupsCollection(@NotNull Player player) {
        return this.getPlayerGroups(player);
    }

    @NotNull
    public CompletableFuture<Boolean> hasPermissionAsync(@NotNull OfflinePlayer player, @NotNull String permission) {
        return ((CompletableFuture)this.get().getUserManager().loadUser(player.getUniqueId()).thenApply(user -> {
            if (user == null) {
                return false;
            }
            return user.getCachedData().getPermissionData(QueryOptions.defaultContextualOptions()).checkPermission(permission).asBoolean();
        })).exceptionally(ex -> {
            LOGGER.log(Level.SEVERE, "Error checking permission '" + permission + "' for " + String.valueOf(player.getUniqueId()) + ": " + ex.getMessage());
            return false;
        });
    }

    @NotNull
    public List<String> getPermissions(@NotNull OfflinePlayer player) {
        User user = this.requireUser(player);
        return user.resolveInheritedNodes(QueryOptions.defaultContextualOptions()).stream().filter(arg_0 -> ((NodeType)NodeType.PERMISSION).matches(arg_0)).map(Node::getKey).filter(k -> !k.toLowerCase(Locale.ENGLISH).startsWith("displayname.")).filter(k -> !k.toLowerCase(Locale.ENGLISH).startsWith("weight.")).filter(k -> !k.toLowerCase(Locale.ENGLISH).startsWith("group.")).distinct().sorted().toList();
    }

    public boolean hasGroup(@NotNull Player player, @NotNull String group) {
        if (group.isBlank()) {
            return false;
        }
        return this.getPlayerGroups(player).contains(group.toLowerCase(Locale.ENGLISH));
    }

    public boolean hasGroup(@NotNull OfflinePlayer player, @NotNull String group) {
        if (group.isBlank()) {
            return false;
        }
        return this.getPlayerGroups(player).contains(group.toLowerCase(Locale.ENGLISH));
    }

    public int createOrUpdateGroups(@NotNull Map<String, List<IRank>> ranks) throws ExecutionException, InterruptedException {
        Set currentGroups = this.get().getGroupManager().getLoadedGroups();
        int currentGroupCount = currentGroups.size();
        Map<String, Group> currentGroupsMap = currentGroups.stream().collect(Collectors.toMap(g -> g.getName().toLowerCase(Locale.ENGLISH), g -> g));
        LOGGER.info("Creating permissions groups for " + currentGroups.size() + " rank(s)");
        for (Map.Entry<String, List<IRank>> entry : ranks.entrySet()) {
            for (IRank rank : entry.getValue()) {
                Group group = currentGroupsMap.getOrDefault(rank.id(), null);
                if (group == null) {
                    LOGGER.log(Level.INFO, "Creating group " + rank.id() + " for " + String.valueOf(rank));
                    group = (Group)this.get().getGroupManager().createAndLoadGroup(rank.id()).get();
                }
                if (group.getWeight().isEmpty()) {
                    LOGGER.log(Level.INFO, "Group weight is not set, setting rank weight: " + rank.weight());
                    group.data().add((Node)WeightNode.builder((int)rank.weight()).build());
                } else if (group.getWeight().getAsInt() != rank.weight()) {
                    LOGGER.log(Level.INFO, "Group weight differs (group=" + String.valueOf(group.getWeight()) + ", rank=" + rank.weight() + "). Not overriding.");
                }
                if (group.getDisplayName() == null || group.getDisplayName().isEmpty()) {
                    LOGGER.log(Level.INFO, "Group display name empty, setting to: " + rank.displayName());
                    group.data().add((Node)DisplayNameNode.builder((String)rank.displayName()).build());
                } else if (!group.getDisplayName().equals(rank.displayName())) {
                    LOGGER.log(Level.INFO, "Group display name differs (group=" + group.getDisplayName() + ", rank=" + rank.displayName() + "). Not overriding.");
                }
                group.data().add((Node)InheritanceNode.builder((String)("group." + rank.id())).build());
                this.saveGroupAsync(group);
                LOGGER.log(Level.INFO, "Permissions group processed for " + rank.id());
            }
        }
        int newCount = this.get().getGroupManager().getLoadedGroups().size();
        return newCount == currentGroupCount ? 0 : newCount - currentGroupCount;
    }

    public boolean checkGroupsExist(@NotNull Map<String, IRank> ranks) {
        Set currentGroupNamesLower = this.get().getGroupManager().getLoadedGroups().stream().map(g -> g.getName().toLowerCase(Locale.ENGLISH)).collect(Collectors.toSet());
        for (IRank rank : ranks.values()) {
            if (currentGroupNamesLower.contains(rank.id().toLowerCase(Locale.ENGLISH))) continue;
            LOGGER.info("Missing required group: " + rank.id());
            return false;
        }
        return true;
    }

    public void setPlayerPrefix(@NotNull Player player, @NotNull String prefix, int priority) {
        this.setPlayerMeta(player, prefix, priority, true);
    }

    public void setPlayerSuffix(@NotNull Player player, @NotNull String suffix, int priority) {
        this.setPlayerMeta(player, suffix, priority, false);
    }

    public void removePlayerPrefix(@NotNull Player player, int priority) {
        this.removePlayerMeta(player, priority, true);
    }

    public void removePlayerSuffix(@NotNull Player player, int priority) {
        this.removePlayerMeta(player, priority, false);
    }

    private LuckPerms get() {
        return LuckPermsProvider.get();
    }

    private void checkArguments(UUID uuid, String group) {
        if (uuid == null) {
            LOGGER.severe("UUID cannot be null");
        }
        if (group == null || group.isBlank()) {
            LOGGER.severe("Group name cannot be null or blank");
        }
    }

    @NotNull
    private User requireUser(UUID uuid) {
        User user = this.getLuckPermsUser(uuid);
        if (user == null) {
            if (Bukkit.getPlayer((UUID)uuid) == null) {
                LOGGER.warning("LuckPerms user could not be obtained for offline player UUID: " + String.valueOf(uuid));
                throw new IllegalStateException("LuckPerms user could not be loaded for online player UUID: " + String.valueOf(uuid));
            }
            LOGGER.info("LuckPerms user not initially found via getUser for online player UUID: " + String.valueOf(uuid) + ". Attempting loadUser...");
            User loadedUser = this.getLuckPermsUser(Bukkit.getOfflinePlayer((UUID)uuid));
            if (loadedUser == null) {
                throw new IllegalStateException("LuckPerms user could not be loaded for online player UUID: " + String.valueOf(uuid));
            }
            return loadedUser;
        }
        return user;
    }

    @NotNull
    private User requireUser(@NotNull OfflinePlayer player) {
        User user = this.getLuckPermsUser(player);
        if (user == null) {
            LOGGER.info("LuckPerms user not initially found via getUser for offline player UUID: " + String.valueOf(player.getUniqueId()) + ". Attempting loadUser...");
            User loadedUser = this.getLuckPermsUser(player);
            if (loadedUser == null) {
                throw new IllegalStateException("LuckPerms user could not be loaded for offline player UUID: " + String.valueOf(player.getUniqueId()));
            }
            return loadedUser;
        }
        return user;
    }

    private void saveUserAsync(@NotNull User user) {
        this.get().getUserManager().saveUser(user);
    }

    private void saveGroupAsync(@NotNull Group group) {
        this.get().getGroupManager().saveGroup(group);
        LOGGER.info("Saving group: " + group.getName());
    }

    @NotNull
    private Set<String> getGroupNamesFromUser(@NotNull User user) {
        return user.resolveInheritedNodes(QueryOptions.defaultContextualOptions()).stream().filter(arg_0 -> ((NodeType)NodeType.INHERITANCE).matches(arg_0)).map(n -> ((InheritanceNode)NodeType.INHERITANCE.cast(n)).getGroupName()).map(n -> n.toLowerCase(Locale.ENGLISH)).collect(Collectors.toUnmodifiableSet());
    }

    private void setPlayerMeta(@NotNull Player player, String meta, int priority, boolean isPrefix) {
        if (meta == null) {
            meta = "";
        }
        meta = meta.replace("<", "{").replace(">", "}");
        User user = this.requireUser(player.getUniqueId());
        ScopedNode node = isPrefix ? PrefixNode.builder((String)meta, (int)priority).build() : SuffixNode.builder((String)meta, (int)priority).build();
        user.data().clear(n -> (isPrefix ? NodeType.PREFIX.matches(n) : NodeType.SUFFIX.matches(n)) && this.getPriorityFromMetaNode((Node)n) == priority);
        user.data().add((Node)node);
        this.saveUserAsync(user);
    }

    private int getPriorityFromMetaNode(Node node) {
        if (NodeType.PREFIX.matches(node)) {
            return ((PrefixNode)NodeType.PREFIX.cast(node)).getPriority();
        }
        if (NodeType.SUFFIX.matches(node)) {
            return ((SuffixNode)NodeType.SUFFIX.cast(node)).getPriority();
        }
        return 0;
    }

    private void removePlayerMeta(@NotNull Player player, int priority, boolean isPrefix) {
        User user = this.requireUser(player.getUniqueId());
        Predicate<Node> predicate = node -> (isPrefix ? NodeType.PREFIX.matches(node) : NodeType.SUFFIX.matches(node)) && this.getPriorityFromMetaNode((Node)node) == priority;
        boolean hadAny = user.getNodes().stream().anyMatch(predicate);
        user.data().clear(predicate);
        if (hadAny) {
            this.saveUserAsync(user);
        } else {
            LOGGER.info("No " + (isPrefix ? "prefix" : "suffix") + " found with priority " + priority + " to remove for player " + player.getName());
        }
    }
}

