/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rplatform.api.impl;

import com.raindropcentral.rplatform.api.PlatformAPI;
import com.raindropcentral.rplatform.api.PlatformType;
import com.raindropcentral.rplatform.scheduler.ISchedulerAdapter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SpigotPlatformAPI
implements PlatformAPI {
    private static final LegacyComponentSerializer LEGACY = LegacyComponentSerializer.legacySection();
    private final JavaPlugin plugin;
    private final ISchedulerAdapter scheduler;

    public SpigotPlatformAPI(@NotNull JavaPlugin plugin) {
        this.plugin = Objects.requireNonNull(plugin, "plugin");
        this.scheduler = ISchedulerAdapter.create(plugin, PlatformType.SPIGOT);
    }

    @Override
    @NotNull
    public PlatformType getType() {
        return PlatformType.SPIGOT;
    }

    @Override
    public boolean supportsAdventure() {
        return false;
    }

    @Override
    public boolean supportsFolia() {
        return false;
    }

    @Override
    public void close() {
    }

    @Override
    public void sendMessage(@NotNull Player player, @NotNull Component message) {
        player.sendMessage(LEGACY.serialize(message));
    }

    @Override
    public void sendMessages(@NotNull Player player, @NotNull List<Component> messages) {
        for (Component m : messages) {
            player.sendMessage(LEGACY.serialize(m));
        }
    }

    @Override
    public void sendActionBar(@NotNull Player player, @NotNull Component message) {
        player.sendActionBar(LEGACY.serialize(message));
    }

    @Override
    public void sendTitle(@NotNull Player player, @NotNull Component title, @Nullable Component subtitle, int fadeInTicks, int stayTicks, int fadeOutTicks) {
        player.sendTitle(LEGACY.serialize(title), subtitle != null ? LEGACY.serialize(subtitle) : "", fadeInTicks, stayTicks, fadeOutTicks);
    }

    @Override
    @NotNull
    public Component getDisplayName(@NotNull Player player) {
        String dn = player.getDisplayName();
        return dn != null ? LEGACY.deserialize(dn) : Component.empty();
    }

    @Override
    public void setDisplayName(@NotNull Player player, @NotNull Component displayName) {
        player.setDisplayName(LEGACY.serialize(displayName));
    }

    @Override
    @Nullable
    public Component getItemDisplayName(@NotNull ItemStack itemStack) {
        ItemMeta meta = itemStack.getItemMeta();
        if (meta == null || !meta.hasDisplayName()) {
            return null;
        }
        String dn = meta.getDisplayName();
        return dn != null ? LEGACY.deserialize(dn) : null;
    }

    @Override
    @NotNull
    public ItemStack setItemDisplayName(@NotNull ItemStack itemStack, @Nullable Component displayName) {
        ItemMeta meta = itemStack.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(displayName != null ? LEGACY.serialize(displayName) : null);
            itemStack.setItemMeta(meta);
        }
        return itemStack;
    }

    @Override
    @NotNull
    public List<Component> getItemLore(@NotNull ItemStack itemStack) {
        ItemMeta meta = itemStack.getItemMeta();
        if (meta == null || !meta.hasLore()) {
            return List.of();
        }
        List lore = meta.getLore();
        if (lore == null || lore.isEmpty()) {
            return List.of();
        }
        ArrayList<Component> out = new ArrayList<Component>(lore.size());
        for (String line : lore) {
            out.add((Component)LEGACY.deserialize(line));
        }
        return out;
    }

    @Override
    @NotNull
    public ItemStack setItemLore(@NotNull ItemStack itemStack, @NotNull List<Component> lore) {
        ItemMeta meta = itemStack.getItemMeta();
        if (meta != null) {
            ArrayList<String> out = new ArrayList<String>(lore.size());
            for (Component c : lore) {
                out.add(LEGACY.serialize(c));
            }
            meta.setLore(out);
            itemStack.setItemMeta(meta);
        }
        return itemStack;
    }

    @Override
    @NotNull
    public ItemStack createPlayerHead(@Nullable Player player) {
        ItemStack head = new ItemStack(Material.PLAYER_HEAD);
        if (player == null) {
            return head;
        }
        SkullMeta meta = (SkullMeta)head.getItemMeta();
        if (meta != null) {
            meta.setOwningPlayer((OfflinePlayer)player);
            head.setItemMeta((ItemMeta)meta);
        }
        return head;
    }

    @Override
    @NotNull
    public ItemStack createPlayerHead(@Nullable OfflinePlayer offlinePlayer) {
        ItemStack head = new ItemStack(Material.PLAYER_HEAD);
        if (offlinePlayer == null) {
            return head;
        }
        SkullMeta meta = (SkullMeta)head.getItemMeta();
        if (meta != null) {
            meta.setOwningPlayer(offlinePlayer);
            head.setItemMeta((ItemMeta)meta);
        }
        return head;
    }

    @Override
    @NotNull
    public ItemStack createCustomHead(@NotNull UUID uuid, @NotNull String textureData) {
        return this.createCustomHead(uuid, textureData, null);
    }

    @Override
    @NotNull
    public ItemStack createCustomHead(@NotNull UUID uuid, @NotNull String textureData, @Nullable Component displayName) {
        ItemStack head = new ItemStack(Material.PLAYER_HEAD);
        SkullMeta meta = (SkullMeta)head.getItemMeta();
        if (meta != null) {
            if (displayName != null) {
                meta.setDisplayName(LEGACY.serialize(displayName));
            }
            SpigotPlatformAPI.applyCustomTextureReflective(meta, uuid, textureData);
            head.setItemMeta((ItemMeta)meta);
        }
        return head;
    }

    @Override
    @NotNull
    public ItemStack applyCustomTexture(@NotNull ItemStack skull, @NotNull UUID uuid, @NotNull String textureData) {
        if (skull.getType() != Material.PLAYER_HEAD) {
            return skull;
        }
        SkullMeta meta = (SkullMeta)skull.getItemMeta();
        if (meta != null) {
            SpigotPlatformAPI.applyCustomTextureReflective(meta, uuid, textureData);
            skull.setItemMeta((ItemMeta)meta);
        }
        return skull;
    }

    private static void applyCustomTextureReflective(@NotNull SkullMeta meta, @NotNull UUID uuid, @NotNull String textureData) {
        try {
            Class<?> gameProfileClass = Class.forName("com.mojang.authlib.GameProfile");
            Class<?> propertyClass = Class.forName("com.mojang.authlib.properties.Property");
            Constructor<?> gpCtor = gameProfileClass.getConstructor(UUID.class, String.class);
            Object profile = gpCtor.newInstance(uuid, null);
            Constructor<?> propCtor = propertyClass.getConstructor(String.class, String.class);
            Object texturesProperty = propCtor.newInstance("textures", textureData);
            Method getProps = gameProfileClass.getMethod("getProperties", new Class[0]);
            Object props = getProps.invoke(profile, new Object[0]);
            Method putMethod = props.getClass().getMethod("put", Object.class, Object.class);
            putMethod.invoke(props, "textures", texturesProperty);
            Field profileField = meta.getClass().getDeclaredField("profile");
            profileField.setAccessible(true);
            profileField.set(meta, profile);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    @NotNull
    public String getServerVersion() {
        return Bukkit.getVersion();
    }

    @Override
    @NotNull
    public ISchedulerAdapter scheduler() {
        return this.scheduler;
    }
}

