/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rplatform.api.impl;

import com.destroystokyo.paper.profile.PlayerProfile;
import com.destroystokyo.paper.profile.ProfileProperty;
import com.raindropcentral.rplatform.api.PlatformAPI;
import com.raindropcentral.rplatform.api.PlatformType;
import com.raindropcentral.rplatform.scheduler.ISchedulerAdapter;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.title.Title;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FoliaPlatformAPI
implements PlatformAPI {
    private final JavaPlugin plugin;
    private final ISchedulerAdapter scheduler;

    public FoliaPlatformAPI(@NotNull JavaPlugin plugin) {
        this.plugin = Objects.requireNonNull(plugin, "plugin");
        this.scheduler = ISchedulerAdapter.create(plugin, PlatformType.FOLIA);
    }

    @Override
    @NotNull
    public PlatformType getType() {
        return PlatformType.FOLIA;
    }

    @Override
    public boolean supportsAdventure() {
        return true;
    }

    @Override
    public boolean supportsFolia() {
        return true;
    }

    @Override
    public void close() {
    }

    @Override
    public void sendMessage(@NotNull Player player, @NotNull Component message) {
        player.sendMessage(message);
    }

    @Override
    public void sendMessages(@NotNull Player player, @NotNull List<Component> messages) {
        for (Component message : messages) {
            player.sendMessage(message);
        }
    }

    @Override
    public void sendActionBar(@NotNull Player player, @NotNull Component message) {
        player.sendActionBar(message);
    }

    @Override
    public void sendTitle(@NotNull Player player, @NotNull Component title, @Nullable Component subtitle, int fadeInTicks, int stayTicks, int fadeOutTicks) {
        Title.Times times = Title.Times.times((Duration)Duration.ofMillis((long)fadeInTicks * 50L), (Duration)Duration.ofMillis((long)stayTicks * 50L), (Duration)Duration.ofMillis((long)fadeOutTicks * 50L));
        player.showTitle(Title.title((Component)title, (Component)(subtitle != null ? subtitle : Component.empty()), (Title.Times)times));
    }

    @Override
    @NotNull
    public Component getDisplayName(@NotNull Player player) {
        return player.displayName();
    }

    @Override
    public void setDisplayName(@NotNull Player player, @NotNull Component displayName) {
        player.displayName(displayName);
    }

    @Override
    @Nullable
    public Component getItemDisplayName(@NotNull ItemStack itemStack) {
        ItemMeta meta = itemStack.getItemMeta();
        if (meta == null) {
            return null;
        }
        return meta.displayName();
    }

    @Override
    @NotNull
    public ItemStack setItemDisplayName(@NotNull ItemStack itemStack, @Nullable Component displayName) {
        ItemMeta meta = itemStack.getItemMeta();
        if (meta != null) {
            meta.displayName(displayName);
            itemStack.setItemMeta(meta);
        }
        return itemStack;
    }

    @Override
    @NotNull
    public List<Component> getItemLore(@NotNull ItemStack itemStack) {
        ItemMeta meta = itemStack.getItemMeta();
        if (meta == null) {
            return List.of();
        }
        List<Component> lore = meta.lore();
        return lore != null ? lore : List.of();
    }

    @Override
    @NotNull
    public ItemStack setItemLore(@NotNull ItemStack itemStack, @NotNull List<Component> lore) {
        ItemMeta meta = itemStack.getItemMeta();
        if (meta != null) {
            meta.lore(lore);
            itemStack.setItemMeta(meta);
        }
        return itemStack;
    }

    @Override
    @NotNull
    public ItemStack createPlayerHead(@Nullable Player player) {
        ItemStack head = new ItemStack(Material.PLAYER_HEAD);
        if (player == null) {
            return head;
        }
        SkullMeta meta = (SkullMeta)head.getItemMeta();
        if (meta != null) {
            meta.setPlayerProfile(player.getPlayerProfile());
            head.setItemMeta((ItemMeta)meta);
        }
        return head;
    }

    @Override
    @NotNull
    public ItemStack createPlayerHead(@Nullable OfflinePlayer offlinePlayer) {
        ItemStack head = new ItemStack(Material.PLAYER_HEAD);
        if (offlinePlayer == null) {
            return head;
        }
        SkullMeta meta = (SkullMeta)head.getItemMeta();
        if (meta != null) {
            meta.setPlayerProfile(offlinePlayer.getPlayerProfile());
            meta.setOwningPlayer(offlinePlayer);
            head.setItemMeta((ItemMeta)meta);
        }
        return head;
    }

    @Override
    @NotNull
    public ItemStack createCustomHead(@NotNull UUID uuid, @NotNull String textureData) {
        return this.createCustomHead(uuid, textureData, null);
    }

    @Override
    @NotNull
    public ItemStack createCustomHead(@NotNull UUID uuid, @NotNull String textureData, @Nullable Component displayName) {
        ItemStack head = new ItemStack(Material.PLAYER_HEAD);
        SkullMeta meta = (SkullMeta)head.getItemMeta();
        if (meta != null) {
            PlayerProfile profile = Bukkit.createProfile((UUID)uuid, null);
            profile.setProperty(new ProfileProperty("textures", textureData, null));
            meta.setPlayerProfile(profile);
            if (displayName != null) {
                meta.displayName(displayName);
            }
            head.setItemMeta((ItemMeta)meta);
        }
        return head;
    }

    @Override
    @NotNull
    public ItemStack applyCustomTexture(@NotNull ItemStack skull, @NotNull UUID uuid, @NotNull String textureData) {
        if (skull.getType() != Material.PLAYER_HEAD) {
            return skull;
        }
        SkullMeta meta = (SkullMeta)skull.getItemMeta();
        if (meta != null) {
            PlayerProfile profile = Bukkit.createProfile((UUID)uuid, null);
            profile.setProperty(new ProfileProperty("textures", textureData, null));
            meta.setPlayerProfile(profile);
            skull.setItemMeta((ItemMeta)meta);
        }
        return skull;
    }

    @Override
    @NotNull
    public String getServerVersion() {
        return Bukkit.getVersion();
    }

    @Override
    @NotNull
    public ISchedulerAdapter scheduler() {
        return this.scheduler;
    }
}

