/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rplatform.api;

import com.raindropcentral.rplatform.RPlatform;
import com.raindropcentral.rplatform.api.PlatformAPI;
import com.raindropcentral.rplatform.api.PlatformType;
import com.raindropcentral.rplatform.logging.CentralLogger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class PlatformAPIFactory {
    private static final Logger LOGGER = CentralLogger.getLogger(RPlatform.class);

    private PlatformAPIFactory() {
        throw new UnsupportedOperationException("Utility class");
    }

    @NotNull
    public static PlatformType detectPlatformType() {
        try {
            Class.forName("io.papermc.paper.threadedregions.RegionizedServer");
            return PlatformType.FOLIA;
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                Class.forName("io.papermc.paper.plugin.entrypoint.LaunchEntryPointHandler");
                return PlatformType.PAPER;
            }
            catch (ClassNotFoundException classNotFoundException2) {
                return PlatformType.SPIGOT;
            }
        }
    }

    @NotNull
    public static PlatformAPI create(@NotNull JavaPlugin plugin) {
        PlatformType type = PlatformAPIFactory.detectPlatformType();
        return switch (type) {
            default -> throw new MatchException(null, null);
            case PlatformType.FOLIA -> PlatformAPIFactory.createFoliaAPI(plugin);
            case PlatformType.PAPER -> PlatformAPIFactory.createPaperAPI(plugin);
            case PlatformType.SPIGOT -> PlatformAPIFactory.createSpigotAPI(plugin);
        };
    }

    @NotNull
    private static PlatformAPI createFoliaAPI(@NotNull JavaPlugin plugin) {
        try {
            Class<?> clazz = Class.forName("com.raindropcentral.rplatform.api.impl.FoliaPlatformAPI");
            return (PlatformAPI)clazz.getConstructor(JavaPlugin.class).newInstance(plugin);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "FoliaPlatformAPI unavailable, falling back to Paper", e);
            return PlatformAPIFactory.createPaperAPI(plugin);
        }
    }

    @NotNull
    private static PlatformAPI createPaperAPI(@NotNull JavaPlugin plugin) {
        try {
            Class<?> clazz = Class.forName("com.raindropcentral.rplatform.api.impl.PaperPlatformAPI");
            return (PlatformAPI)clazz.getConstructor(JavaPlugin.class).newInstance(plugin);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "PaperPlatformAPI unavailable, falling back to Spigot", e);
            return PlatformAPIFactory.createSpigotAPI(plugin);
        }
    }

    @NotNull
    private static PlatformAPI createSpigotAPI(@NotNull JavaPlugin plugin) {
        try {
            Class<?> clazz = Class.forName("com.raindropcentral.rplatform.api.impl.SpigotPlatformAPI");
            return (PlatformAPI)clazz.getConstructor(JavaPlugin.class).newInstance(plugin);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "SpigotPlatformAPI unavailable", e);
            throw new RuntimeException("Failed to create platform API: Could not load SpigotPlatformAPI (class missing or constructor signature mismatch)", e);
        }
    }
}

