/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rplatform;

import com.raindropcentral.rplatform.api.PlatformAPI;
import com.raindropcentral.rplatform.api.PlatformAPIFactory;
import com.raindropcentral.rplatform.api.PlatformType;
import com.raindropcentral.rplatform.integration.geyser.GeyserService;
import com.raindropcentral.rplatform.localization.TranslationManager;
import com.raindropcentral.rplatform.logging.CentralLogger;
import com.raindropcentral.rplatform.logging.PlatformLogger;
import com.raindropcentral.rplatform.metrics.MetricsManager;
import com.raindropcentral.rplatform.placeholder.PlaceholderManager;
import com.raindropcentral.rplatform.scheduler.ISchedulerAdapter;
import com.raindropcentral.rplatform.service.ServiceRegistry;
import de.jexcellence.evaluable.CommandUpdater;
import de.jexcellence.hibernate.JEHibernate;
import jakarta.persistence.EntityManagerFactory;
import java.io.File;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RPlatform {
    private final JavaPlugin plugin;
    private final PlatformType platformType;
    private final PlatformAPI platformAPI;
    private final ISchedulerAdapter scheduler;
    private final ServiceRegistry serviceRegistry;
    private final PlatformLogger logger;
    private CommandUpdater commandUpdater;
    private TranslationManager translationManager;
    private EntityManagerFactory entityManagerFactory;
    private MetricsManager metricsManager;
    private PlaceholderManager placeholderManager;
    private GeyserService geyserService;
    private boolean premiumVersion;
    private boolean initialized;

    public RPlatform(@NotNull JavaPlugin plugin) {
        this.plugin = plugin;
        this.platformType = PlatformAPIFactory.detectPlatformType();
        this.platformAPI = PlatformAPIFactory.create(plugin);
        this.scheduler = ISchedulerAdapter.create(plugin, this.platformType);
        this.serviceRegistry = new ServiceRegistry();
        this.logger = PlatformLogger.create(plugin);
        this.premiumVersion = false;
        this.initialized = false;
    }

    @NotNull
    public CompletableFuture<Void> initialize() {
        if (this.initialized) {
            return CompletableFuture.completedFuture(null);
        }
        return CompletableFuture.runAsync(() -> {
            this.logger.info("Initializing RPlatform for " + this.platformType.name());
            this.initializeDatabaseResources();
            this.translationManager = TranslationManager.builder(this.plugin).defaultLocale("de_DE").supportedLocales("de_DE", "en_US").enableMetrics(true).build();
            this.commandUpdater = new CommandUpdater((Plugin)this.plugin);
            this.logger.info("RPlatform initialized successfully");
            this.initialized = true;
        }, this.scheduler::runAsync).thenCompose(v -> {
            this.logger.info("Initializing translation system...");
            return this.translationManager.initialize().thenRun(() -> this.logger.info("Translation system initialized with " + this.translationManager.getKeyCount() + " keys in " + this.translationManager.getLocaleCount() + " locales"));
        });
    }

    public void initializeGeyser() {
        if (this.geyserService == null) {
            this.geyserService = new GeyserService();
            if (this.geyserService.isFloodgateAvailable()) {
                this.logger.info("Geyser/Floodgate integration initialized");
            }
        }
    }

    public void initializeMetrics(int serviceId) {
        if (serviceId > 0 && this.metricsManager == null) {
            this.metricsManager = new MetricsManager(this.plugin, serviceId, this.platformType);
            this.logger.info("Metrics initialized with service ID: " + serviceId);
        }
    }

    public void initializePlaceholders(@NotNull String identifier) {
        if (this.placeholderManager == null) {
            this.placeholderManager = new PlaceholderManager(this.plugin, identifier);
            this.placeholderManager.register();
            this.logger.info("PlaceholderAPI integration initialized");
        }
    }

    public void detectPremiumVersion(@NotNull Class<?> resourceClass, @NotNull String resourcePath) {
        if (resourceClass.getClassLoader().getResource(resourcePath) != null) {
            this.premiumVersion = true;
            this.logger.info("Premium version detected");
        }
    }

    public void shutdown() {
        this.logger.info("Shutting down RPlatform");
        if (this.placeholderManager != null) {
            this.placeholderManager.unregister();
        }
        this.platformAPI.close();
        this.logger.close();
    }

    @NotNull
    public JavaPlugin getPlugin() {
        return this.plugin;
    }

    @NotNull
    public PlatformType getPlatformType() {
        return this.platformType;
    }

    @NotNull
    public PlatformAPI getPlatformAPI() {
        return this.platformAPI;
    }

    @NotNull
    public ISchedulerAdapter getScheduler() {
        return this.scheduler;
    }

    @NotNull
    public ServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }

    @NotNull
    public PlatformLogger getLogger() {
        return this.logger;
    }

    @NotNull
    public CommandUpdater getCommandUpdater() {
        return this.commandUpdater;
    }

    @NotNull
    public TranslationManager getTranslationManager() {
        return this.translationManager;
    }

    @Nullable
    public GeyserService getGeyserService() {
        return this.geyserService;
    }

    public boolean isPremiumVersion() {
        return this.premiumVersion;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    @Nullable
    public EntityManagerFactory getEntityManagerFactory() {
        return this.entityManagerFactory;
    }

    private void initializeDatabaseResources() {
        File databaseFolder = new File(this.plugin.getDataFolder(), "database");
        if (databaseFolder.exists() || databaseFolder.mkdirs()) {
            this.plugin.saveResource("database/hibernate.properties", false);
            File hiberateFile = new File(String.valueOf(databaseFolder) + "/hibernate.properties");
            this.entityManagerFactory = new JEHibernate(hiberateFile.getPath()).getEntityManagerFactory();
            CentralLogger.getLogger(RPlatform.class.getName()).log(Level.INFO, "Database resources initialized successfully.");
        }
    }
}

