/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rdq.view.ranks.util;

import com.raindropcentral.rdq.RDQ;
import com.raindropcentral.rplatform.utility.unified.UnifiedBuilderFactory;
import de.jexcellence.remapped.me.devnatan.inventoryframework.component.BukkitItemComponentBuilder;
import de.jexcellence.remapped.me.devnatan.inventoryframework.context.RenderContext;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class RequirementProgressRenderer {
    public static final int[] PROGRESS_SLOTS = new int[]{10, 11, 12, 13, 14, 15, 16};
    private static final Material EMPTY_MATERIAL = Material.GRAY_STAINED_GLASS_PANE;
    private static final Material PARTIAL_MATERIAL = Material.YELLOW_STAINED_GLASS_PANE;
    private static final Material FILLED_MATERIAL = Material.LIME_STAINED_GLASS_PANE;

    public void renderProgressBar(@NotNull RenderContext context, @NotNull Player player, double progress, int completedCount, int totalCount) {
        int totalSlots = PROGRESS_SLOTS.length;
        int filledSlots = (int)Math.floor(progress * (double)totalSlots);
        double remainder = progress * (double)totalSlots - (double)filledSlots;
        for (int i = 0; i < totalSlots; ++i) {
            String stateKey;
            Material material;
            int slotIndex = i;
            if (i < filledSlots) {
                material = FILLED_MATERIAL;
                stateKey = "filled";
            } else if (i == filledSlots && remainder > 0.3) {
                material = PARTIAL_MATERIAL;
                stateKey = "partial";
            } else {
                material = EMPTY_MATERIAL;
                stateKey = "empty";
            }
            int percentage = (int)Math.round(progress * 100.0);
            ((BukkitItemComponentBuilder)context.slot(PROGRESS_SLOTS[i])).renderWith(() -> this.createProgressSlotItem(material, slotIndex + 1, totalSlots, percentage, completedCount, totalCount, stateKey));
        }
    }

    @NotNull
    private ItemStack createProgressSlotItem(@NotNull Material material, int slotNumber, int totalSlots, int percentage, int completedCount, int totalCount, String stateKey) {
        TextComponent name = Component.text((String)" ");
        return UnifiedBuilderFactory.item(material).setName((Component)name).addItemFlags(ItemFlag.HIDE_ATTRIBUTES).build();
    }

    @NotNull
    public static Component createMiniProgressBar(double progress, int barLength) {
        int i;
        int filled = (int)Math.floor(progress * (double)barLength);
        int empty = barLength - filled;
        StringBuilder bar = new StringBuilder();
        bar.append("<green>");
        for (i = 0; i < filled; ++i) {
            bar.append("\u2588");
        }
        bar.append("</green><gray>");
        for (i = 0; i < empty; ++i) {
            bar.append("\u2591");
        }
        bar.append("</gray>");
        int percentage = (int)Math.floor(progress * 100.0);
        bar.append(" <white>").append(percentage).append("%</white>");
        return MiniMessage.miniMessage().deserialize((Object)bar.toString());
    }

    @NotNull
    public static Component createMiniProgressBar(double progress) {
        return RequirementProgressRenderer.createMiniProgressBar(progress, 10);
    }

    public void animateProgressChange(@NotNull RenderContext context, @NotNull RDQ rdq, double oldProgress, double newProgress) {
        if (newProgress <= oldProgress) {
            return;
        }
        int totalSlots = PROGRESS_SLOTS.length;
        int oldFilledSlots = (int)Math.floor(oldProgress * (double)totalSlots);
        int newFilledSlots = (int)Math.floor(newProgress * (double)totalSlots);
        if (newFilledSlots <= oldFilledSlots) {
            return;
        }
        int slotsToFill = newFilledSlots - oldFilledSlots;
        long delayPerSlot = Math.max(1L, 10L / (long)slotsToFill);
        for (int i = 0; i < slotsToFill; ++i) {
            int slotToFill = oldFilledSlots + i;
            long delay = delayPerSlot * (long)(i + 1);
            rdq.getPlatform().getScheduler().runDelayed(() -> {
                if (slotToFill < PROGRESS_SLOTS.length) {
                    ((BukkitItemComponentBuilder)context.slot(PROGRESS_SLOTS[slotToFill])).renderWith(() -> UnifiedBuilderFactory.item(FILLED_MATERIAL).setName((Component)Component.text((String)" ")).addItemFlags(ItemFlag.HIDE_ATTRIBUTES).build());
                }
            }, delay);
        }
    }
}

