/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rdq.view.ranks.util;

import com.raindropcentral.rdq.database.entity.rank.RRankUpgradeRequirement;
import com.raindropcentral.rdq.manager.RankRequirementProgressManager;
import com.raindropcentral.rdq.requirement.AbstractRequirement;
import com.raindropcentral.rdq.requirement.ItemRequirement;
import com.raindropcentral.rdq.requirement.Requirement;
import com.raindropcentral.rdq.view.ranks.util.RequirementProgressRenderer;
import com.raindropcentral.rplatform.utility.unified.UnifiedBuilderFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class RequirementCardRenderer {
    private static final Map<Requirement.Type, Material> TYPE_ICONS = Map.of(Requirement.Type.ITEM, Material.CHEST, Requirement.Type.CURRENCY, Material.EMERALD, Requirement.Type.EXPERIENCE_LEVEL, Material.EXPERIENCE_BOTTLE, Requirement.Type.PLAYTIME, Material.CLOCK, Requirement.Type.PERMISSION, Material.PAPER, Requirement.Type.LOCATION, Material.COMPASS);
    private static final Map<RankRequirementProgressManager.RequirementStatus, Material> STATUS_BORDERS = Map.of(RankRequirementProgressManager.RequirementStatus.COMPLETED, Material.LIME_STAINED_GLASS_PANE, RankRequirementProgressManager.RequirementStatus.READY_TO_COMPLETE, Material.YELLOW_STAINED_GLASS_PANE, RankRequirementProgressManager.RequirementStatus.IN_PROGRESS, Material.ORANGE_STAINED_GLASS_PANE, RankRequirementProgressManager.RequirementStatus.NOT_STARTED, Material.RED_STAINED_GLASS_PANE, RankRequirementProgressManager.RequirementStatus.ERROR, Material.GRAY_STAINED_GLASS_PANE);
    private static final MiniMessage MINI_MESSAGE = MiniMessage.miniMessage();

    @NotNull
    public ItemStack createRequirementCard(@NotNull Player player, @NotNull RRankUpgradeRequirement requirement, @NotNull RankRequirementProgressManager.RequirementProgressData progress) {
        AbstractRequirement abstractReq = requirement.getRequirement().getRequirement();
        Requirement.Type type = abstractReq.getType();
        Material icon = RequirementCardRenderer.getIconForType(type);
        boolean shouldGlow = progress.getStatus() == RankRequirementProgressManager.RequirementStatus.READY_TO_COMPLETE || progress.getStatus() == RankRequirementProgressManager.RequirementStatus.COMPLETED;
        List<Component> lore = this.buildCardLore(player, requirement, progress);
        String typeName = RequirementCardRenderer.formatTypeName(type);
        return UnifiedBuilderFactory.item(icon).setName((Component)Component.text((String)typeName)).setLore(lore).setGlowing(shouldGlow).addItemFlags(ItemFlag.HIDE_ATTRIBUTES, ItemFlag.HIDE_ENCHANTS).build();
    }

    @NotNull
    private List<Component> buildCardLore(@NotNull Player player, @NotNull RRankUpgradeRequirement requirement, @NotNull RankRequirementProgressManager.RequirementProgressData progress) {
        ArrayList<Component> lore = new ArrayList<Component>();
        AbstractRequirement abstractReq = requirement.getRequirement().getRequirement();
        lore.add((Component)Component.empty());
        List<TaskPreview> tasks = this.generateTaskPreviews(requirement, player);
        if (!tasks.isEmpty()) {
            for (int i = 0; i < Math.min(3, tasks.size()); ++i) {
                TaskPreview task = tasks.get(i);
                String prefix = task.completed() ? "\u2713" : "\u25cb";
                String prefixColor = task.completed() ? "<green>" : "<gray>";
                String closingTag = task.completed() ? "</green>" : "</gray>";
                lore.add(MiniMessage.miniMessage().deserialize((Object)(prefixColor + prefix + closingTag + " <gray>" + task.name() + "</gray>")));
            }
            if (tasks.size() > 3) {
                lore.add(MINI_MESSAGE.deserialize((Object)("<gray>...and " + (tasks.size() - 3) + " more</gray>")));
            }
            lore.add((Component)Component.empty());
        }
        double progressValue = progress.getProgressPercentage();
        lore.add(RequirementProgressRenderer.createMiniProgressBar(progressValue, 10));
        lore.add((Component)Component.empty());
        switch (progress.getStatus()) {
            case READY_TO_COMPLETE: {
                lore.add(MINI_MESSAGE.deserialize((Object)"<green>Click to complete!</green>"));
                break;
            }
            case COMPLETED: {
                lore.add(MINI_MESSAGE.deserialize((Object)"<green>\u2713 Completed</green>"));
                break;
            }
            case IN_PROGRESS: 
            case NOT_STARTED: {
                lore.add(MINI_MESSAGE.deserialize((Object)"<gray>Right-click for details</gray>"));
                break;
            }
        }
        return lore;
    }

    @NotNull
    public static Material getIconForType(@NotNull Requirement.Type type) {
        return TYPE_ICONS.getOrDefault((Object)type, Material.BOOK);
    }

    @NotNull
    private static String formatTypeName(@NotNull Requirement.Type type) {
        return switch (type) {
            case Requirement.Type.ITEM -> "\ud83d\udce6 Item Collection";
            case Requirement.Type.CURRENCY -> "\ud83d\udcb0 Currency";
            case Requirement.Type.EXPERIENCE_LEVEL -> "\u2b50 Experience Level";
            case Requirement.Type.PLAYTIME -> "\ud83d\udd50 Playtime";
            case Requirement.Type.PERMISSION -> "\ud83d\udcc4 Permission";
            case Requirement.Type.LOCATION -> "\ud83e\udded Location";
            default -> type.name().replace("_", " ");
        };
    }

    @NotNull
    public static Material getBorderForStatus(@NotNull RankRequirementProgressManager.RequirementStatus status) {
        return STATUS_BORDERS.getOrDefault((Object)status, Material.GRAY_STAINED_GLASS_PANE);
    }

    @NotNull
    public List<TaskPreview> generateTaskPreviews(@NotNull RRankUpgradeRequirement requirement, @NotNull Player player) {
        ArrayList<TaskPreview> previews = new ArrayList<TaskPreview>();
        AbstractRequirement abstractReq = requirement.getRequirement().getRequirement();
        if (abstractReq instanceof ItemRequirement) {
            ItemRequirement itemReq = (ItemRequirement)abstractReq;
            List<ItemRequirement.ItemProgress> itemProgressList = itemReq.getDetailedProgress(player);
            for (int i = 0; i < itemProgressList.size(); ++i) {
                ItemRequirement.ItemProgress itemProgress = itemProgressList.get(i);
                String itemName = this.formatItemName(itemProgress.requiredItem());
                previews.add(new TaskPreview(itemName + " x" + itemProgress.requiredAmount(), itemProgress.completed(), itemProgress.currentAmount(), itemProgress.requiredAmount()));
            }
        } else {
            String typeName = abstractReq.getType().name().toLowerCase().replace("_", " ");
            String capitalizedName = typeName.substring(0, 1).toUpperCase() + typeName.substring(1);
            previews.add(new TaskPreview(capitalizedName, false, 0, 1));
        }
        return previews;
    }

    @NotNull
    private String formatItemName(@NotNull ItemStack item) {
        if (item.hasItemMeta() && item.getItemMeta().hasDisplayName()) {
            return PlainTextComponentSerializer.plainText().serialize(item.getItemMeta().displayName());
        }
        String materialName = item.getType().name().toLowerCase().replace("_", " ");
        String[] words = materialName.split(" ");
        StringBuilder formatted = new StringBuilder();
        for (String word : words) {
            if (word.isEmpty()) continue;
            formatted.append(Character.toUpperCase(word.charAt(0))).append(word.substring(1)).append(" ");
        }
        return formatted.toString().trim();
    }

    public record TaskPreview(String name, boolean completed, int current, int required) {
    }
}

