/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rdq.view.ranks.interaction;

import com.raindropcentral.rdq.RDQ;
import com.raindropcentral.rdq.database.entity.player.RDQPlayer;
import com.raindropcentral.rdq.database.entity.rank.RPlayerRank;
import com.raindropcentral.rdq.database.entity.rank.RPlayerRankUpgradeProgress;
import com.raindropcentral.rdq.database.entity.rank.RRank;
import com.raindropcentral.rdq.database.entity.rank.RRankTree;
import com.raindropcentral.rdq.database.entity.rank.RRankUpgradeRequirement;
import com.raindropcentral.rdq.requirement.AbstractRequirement;
import com.raindropcentral.rdq.service.RankUpgradeProgressService;
import com.raindropcentral.rdq.view.ranks.hierarchy.RankNode;
import com.raindropcentral.rplatform.logging.CentralLogger;
import de.jexcellence.jextranslate.i18n.I18n;
import de.jexcellence.remapped.me.devnatan.inventoryframework.context.SlotClickContext;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RankProgressionManager {
    private static final Logger LOGGER = CentralLogger.getLogger(RankProgressionManager.class.getName());
    private final RDQ rdq;
    private final RankUpgradeProgressService rankUpgradeProgressService;

    public RankProgressionManager(@NotNull RDQ rdq) {
        this.rdq = rdq;
        this.rankUpgradeProgressService = new RankUpgradeProgressService(this.rdq);
    }

    public void assignInitialRankForPath(@NotNull RDQPlayer rdqPlayer, @NotNull RRankTree rankTree) {
        try {
            RRank initialRank = this.findInitialRankForTree(rankTree);
            if (initialRank == null) {
                LOGGER.log(Level.WARNING, "No initial rank found for rank tree: " + rankTree.getIdentifier());
                return;
            }
            if (this.playerHasRank(rdqPlayer, initialRank)) {
                LOGGER.log(Level.FINE, "Player " + rdqPlayer.getPlayerName() + " already has initial rank " + initialRank.getIdentifier());
                return;
            }
            this.processRankAssignment(rdqPlayer, initialRank, rankTree, true);
            LOGGER.log(Level.INFO, "Automatically assigned initial rank " + initialRank.getIdentifier() + " to player " + rdqPlayer.getPlayerName() + " for path " + rankTree.getIdentifier());
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, "Failed to assign initial rank for path", exception);
        }
    }

    public void startRankProgression(@NotNull SlotClickContext clickContext, @NotNull RankNode rankNode, @NotNull RDQPlayer rdqPlayer) {
        try {
            Player player = clickContext.getPlayer();
            Set<RRankUpgradeRequirement> upgradeRequirements = rankNode.rank.getUpgradeRequirements();
            if (upgradeRequirements.isEmpty()) {
                this.sendNoRequirementsMessage(player, rankNode.rank);
                this.processRankAssignmentWithPlayer(player, rdqPlayer, rankNode.rank, rankNode.rank.getRankTree(), false);
                return;
            }
            this.createProgressTrackingEntries(rdqPlayer, upgradeRequirements);
            new I18n.Builder("rank_progression.started", player).withPlaceholders(Map.of("rank_name", rankNode.rank.getIdentifier(), "requirement_count", upgradeRequirements.size())).includePrefix().build().sendMessage();
            LOGGER.log(Level.INFO, "Started rank progression for player " + player.getName() + " on rank " + rankNode.rank.getIdentifier());
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, "Failed to start rank progression", exception);
            this.sendErrorMessage(clickContext.getPlayer(), "rank_progression.start_failed");
        }
    }

    public void attemptRankRedemption(@NotNull SlotClickContext clickContext, @NotNull RankNode rankNode) {
        try {
            Player player = clickContext.getPlayer();
            RDQPlayer rdqPlayer = this.getRDQPlayer(clickContext);
            if (rdqPlayer == null) {
                this.sendErrorMessage(player, "rank_progression.player_not_found");
                return;
            }
            if (this.rankUpgradeProgressService.hasCompletedAllUpgradeRequirements(rdqPlayer, rankNode.rank)) {
                this.processRankAssignmentWithPlayer(player, rdqPlayer, rankNode.rank, rankNode.rank.getRankTree(), false);
                return;
            }
            boolean allCompleted = this.attemptAutoCompleteAllRequirements(player, rdqPlayer, rankNode.rank);
            if (allCompleted) {
                this.processRankAssignmentWithPlayer(player, rdqPlayer, rankNode.rank, rankNode.rank.getRankTree(), false);
            } else {
                this.handleIncompleteRequirements(player, rdqPlayer, rankNode.rank);
            }
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, "Failed to attempt rank redemption", exception);
            this.sendErrorMessage(clickContext.getPlayer(), "rank_progression.redemption_failed");
        }
    }

    private boolean attemptAutoCompleteAllRequirements(@NotNull Player player, @NotNull RDQPlayer rdqPlayer, @NotNull RRank rank) {
        try {
            Set<RRankUpgradeRequirement> upgradeRequirements = rank.getUpgradeRequirements();
            if (upgradeRequirements.isEmpty()) {
                return true;
            }
            boolean allCompleted = true;
            for (RRankUpgradeRequirement requirement : upgradeRequirements) {
                if (this.rankUpgradeProgressService.hasCompletedUpgradeRequirement(rdqPlayer, requirement)) continue;
                AbstractRequirement abstractRequirement = requirement.getRequirement().getRequirement();
                if (abstractRequirement.isMet(player)) {
                    try {
                        abstractRequirement.consume(player);
                        RPlayerRankUpgradeProgress progress = this.getOrCreateProgress(rdqPlayer, requirement);
                        progress.setProgress(1.0);
                        this.rdq.getPlayerRankUpgradeProgressRepository().update(progress);
                        LOGGER.log(Level.INFO, "Auto-completed requirement " + requirement.getId() + " for player " + player.getName() + " during rank redemption");
                    }
                    catch (Exception consumeException) {
                        LOGGER.log(Level.WARNING, "Failed to auto-complete requirement " + requirement.getId(), consumeException);
                        allCompleted = false;
                    }
                    continue;
                }
                allCompleted = false;
            }
            return allCompleted;
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Failed to auto-complete requirements for rank " + rank.getIdentifier(), exception);
            return false;
        }
    }

    private RPlayerRankUpgradeProgress getOrCreateProgress(@NotNull RDQPlayer rdqPlayer, @NotNull RRankUpgradeRequirement requirement) {
        List progressList = this.rdq.getPlayerRankUpgradeProgressRepository().findAllByAttributes(Map.of("player.uniqueId", rdqPlayer.getUniqueId(), "upgradeRequirement.id", requirement.getId()));
        if (!progressList.isEmpty()) {
            return (RPlayerRankUpgradeProgress)progressList.get(0);
        }
        RPlayerRankUpgradeProgress newProgress = new RPlayerRankUpgradeProgress(rdqPlayer, requirement);
        this.rdq.getPlayerRankUpgradeProgressRepository().create(newProgress);
        return newProgress;
    }

    public void openRequirementsView(@NotNull SlotClickContext clickContext, @NotNull RankNode rankNode) {
        try {
            Player player = clickContext.getPlayer();
            RDQPlayer rdqPlayer = this.getRDQPlayer(clickContext);
            if (rdqPlayer == null) {
                this.sendErrorMessage(player, "rank_progression.player_not_found");
                return;
            }
            new I18n.Builder("rank_progression.requirements_view_opened", player).includePrefix().withPlaceholder("rank_name", rankNode.rank.getIdentifier()).build().sendMessage();
            LOGGER.log(Level.FINE, "Opened requirements view for rank " + rankNode.rank.getIdentifier() + " for player " + player.getName());
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Failed to open requirements view", exception);
            this.sendErrorMessage(clickContext.getPlayer(), "rank_progression.requirements_view_failed");
        }
    }

    public void processAutoCompletableRanks(@NotNull RDQPlayer rdqPlayer, @NotNull RRankTree rankTree) {
        try {
            List<RRank> availableRanks = this.getAvailableRanksFoRDQPlayer(rdqPlayer, rankTree);
            for (RRank rank : availableRanks) {
                if (this.playerHasRank(rdqPlayer, rank) || !rank.getUpgradeRequirements().isEmpty()) continue;
                this.processRankAssignment(rdqPlayer, rank, rankTree, false);
                LOGGER.log(Level.INFO, "Auto-completed rank " + rank.getIdentifier() + " for player " + rdqPlayer.getPlayerName() + " (no requirements)");
            }
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Failed to process auto-completable ranks", exception);
        }
    }

    private void processRankAssignmentWithPlayer(@NotNull Player player, @NotNull RDQPlayer rdqPlayer, @NotNull RRank rank, @NotNull RRankTree rankTree, boolean isInitialRank) {
        try {
            this.handleRankAssignmentInTree(rdqPlayer, rankTree, rank, isInitialRank);
            this.handleLuckPermsIntegration(rdqPlayer, rank);
            String messageKey = isInitialRank ? "rank_progression.initial_rank_assigned" : "rank_progression.redeemed_successfully";
            new I18n.Builder(messageKey, player).includePrefix().withPlaceholder("rank_name", rank.getIdentifier()).build().sendMessage();
            this.executeRankRewards(rdqPlayer, rank);
            if (!isInitialRank) {
                this.processAutoCompletableRanks(rdqPlayer, rankTree);
            }
            LOGGER.log(Level.INFO, "Player " + rdqPlayer.getPlayerName() + " successfully " + (isInitialRank ? "received initial" : "redeemed") + " rank " + rank.getIdentifier());
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, "Failed to process rank assignment", exception);
            this.sendErrorMessage(player, "rank_progression.assignment_failed");
        }
    }

    private void processRankAssignment(@NotNull RDQPlayer rdqPlayer, @NotNull RRank rank, @NotNull RRankTree rankTree, boolean isInitialRank) {
        try {
            this.handleRankAssignmentInTree(rdqPlayer, rankTree, rank, isInitialRank);
            this.handleLuckPermsIntegration(rdqPlayer, rank);
            this.executeRankRewards(rdqPlayer, rank);
            if (!isInitialRank) {
                this.processAutoCompletableRanks(rdqPlayer, rankTree);
            }
            LOGGER.log(Level.INFO, "Player " + rdqPlayer.getPlayerName() + " successfully " + (isInitialRank ? "received initial" : "redeemed") + " rank " + rank.getIdentifier());
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, "Failed to process rank assignment", exception);
            throw new RuntimeException("Rank assignment failed", exception);
        }
    }

    private void handleRankAssignmentInTree(@NotNull RDQPlayer rdqPlayer, @NotNull RRankTree rankTree, @NotNull RRank newRank, boolean isInitialRank) {
        try {
            RPlayerRank existingRankInTree = this.getPlayerRankForTree(rdqPlayer, rankTree);
            if (existingRankInTree != null) {
                RPlayerRank freshRank = this.rdq.getPlayerRankRepository().findById(existingRankInTree.getId()).orElse(null);
                if (freshRank == null) {
                    throw new RuntimeException("Could not find existing rank to update");
                }
                freshRank.setCurrentRank(newRank);
                freshRank.setActive(true);
                this.rdq.getPlayerRankRepository().update(freshRank);
                LOGGER.log(Level.INFO, "Updated existing rank for player " + rdqPlayer.getPlayerName() + " to " + newRank.getIdentifier());
            } else {
                RPlayerRank newPlayerRank = new RPlayerRank(rdqPlayer, newRank, rankTree, true);
                rdqPlayer.addPlayerRank(newPlayerRank);
                this.rdq.getPlayerRankRepository().create(newPlayerRank);
                LOGGER.log(Level.INFO, "Created new rank assignment for player " + rdqPlayer.getPlayerName() + " with rank " + newRank.getIdentifier());
            }
            RDQPlayer freshPlayer = this.rdq.getPlayerRepository().findById(rdqPlayer.getId()).orElse(null);
            if (freshPlayer != null) {
                this.rdq.getPlayerRepository().update(freshPlayer);
            }
            if (isInitialRank) {
                this.markProgressEntriesCompleted(rdqPlayer, newRank);
            }
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, "Failed to handle rank assignment in tree", exception);
            throw new RuntimeException("Database rank assignment failed", exception);
        }
    }

    private void markProgressEntriesCompleted(@NotNull RDQPlayer rdqPlayer, @NotNull RRank newRank) {
        try {
            for (RRankUpgradeRequirement upgradeRequirement : newRank.getUpgradeRequirements()) {
                List progressList = this.rdq.getPlayerRankUpgradeProgressRepository().findAllByAttributes(Map.of("player.id", rdqPlayer.getId(), "upgradeRequirement.id", upgradeRequirement.getId()));
                for (RPlayerRankUpgradeProgress progress : progressList) {
                    RPlayerRankUpgradeProgress freshProgress;
                    if (progress.isCompleted() || (freshProgress = (RPlayerRankUpgradeProgress)this.rdq.getPlayerRankUpgradeProgressRepository().findById(progress.getId()).orElse(null)) == null) continue;
                    freshProgress.setProgress(1.0);
                    this.rdq.getPlayerRankUpgradeProgressRepository().update(freshProgress);
                }
            }
            LOGGER.log(Level.FINE, "Marked progress entries as completed for rank " + newRank.getIdentifier());
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Failed to mark progress entries as completed", exception);
        }
    }

    private void createProgressTrackingEntries(@NotNull RDQPlayer rdqPlayer, @NotNull Set<RRankUpgradeRequirement> upgradeRequirements) {
        for (RRankUpgradeRequirement requirement : upgradeRequirements) {
            List existingProgress = this.rdq.getPlayerRankUpgradeProgressRepository().findAllByAttributes(Map.of("player.uniqueId", rdqPlayer.getUniqueId(), "upgradeRequirement.id", requirement.getId()));
            if (!existingProgress.isEmpty()) continue;
            RPlayerRankUpgradeProgress newProgress = new RPlayerRankUpgradeProgress(rdqPlayer, requirement);
            this.rdq.getPlayerRankUpgradeProgressRepository().create(newProgress);
            LOGGER.log(Level.FINE, "Created progress tracking for requirement " + requirement.getId());
        }
    }

    private void handleLuckPermsIntegration(@NotNull RDQPlayer rdqPlayer, @NotNull RRank newRank) {
        try {
            if (this.rdq.getLuckPermsService() == null) {
                LOGGER.log(Level.WARNING, "LuckPerms service not available for rank assignment");
                return;
            }
            String luckPermsGroup = newRank.getAssignedLuckPermsGroup();
            if (luckPermsGroup == null || luckPermsGroup.isEmpty()) {
                LOGGER.log(Level.WARNING, "No LuckPerms group defined for rank " + newRank.getIdentifier());
                return;
            }
            this.removePlayerFromPreviousRankGroups(rdqPlayer, newRank);
            LOGGER.log(Level.INFO, "Assigned LuckPerms group '" + luckPermsGroup + "' to player " + rdqPlayer.getPlayerName());
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Failed to handle LuckPerms integration", exception);
        }
    }

    private void removePlayerFromPreviousRankGroups(@NotNull RDQPlayer rdqPlayer, @NotNull RRank newRank) {
        try {
            RRankTree rankTree = newRank.getRankTree();
            if (rankTree == null) {
                return;
            }
            for (RRank rank : rankTree.getRanks()) {
                String groupToRemove;
                if (!rank.equals(newRank) && (groupToRemove = rank.getAssignedLuckPermsGroup()) != null && !groupToRemove.isEmpty()) continue;
            }
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Failed to remove player from previous rank groups", exception);
        }
    }

    private void handleIncompleteRequirements(@NotNull Player player, @NotNull RDQPlayer rdqPlayer, @NotNull RRank rank) {
        try {
            double completionPercentage = this.rankUpgradeProgressService.getOverallCompletionPercentage(rdqPlayer, rank);
            int completionPercent = (int)Math.round(completionPercentage * 100.0);
            new I18n.Builder("rank_progression.requirements_incomplete", player).withPlaceholders(Map.of("rank_name", rank.getIdentifier(), "completion_percentage", String.valueOf(completionPercent))).includePrefix().build().sendMessage();
            this.showIncompleteRequirements(player, rdqPlayer, rank);
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Failed to handle incomplete requirements", exception);
        }
    }

    private void showIncompleteRequirements(@NotNull Player player, @NotNull RDQPlayer rdqPlayer, @NotNull RRank rank) {
        try {
            Set<RRankUpgradeRequirement> upgradeRequirements = rank.getUpgradeRequirements();
            for (RRankUpgradeRequirement requirement : upgradeRequirements) {
                RPlayerRankUpgradeProgress progress;
                if (this.rankUpgradeProgressService.hasCompletedUpgradeRequirement(rdqPlayer, requirement) || (progress = this.rankUpgradeProgressService.getProgressForRequirement(rdqPlayer, requirement)) == null) continue;
                double currentProgress = progress.getProgress();
                double requiredProgress = 1.0;
                int progressPercent = (int)Math.round(currentProgress / 1.0 * 100.0);
                new I18n.Builder("rank_progression.requirement_incomplete", player).includePrefix().withPlaceholders(Map.of("requirement_type", requirement.getRequirement().getRequirement().getType().name(), "current_progress", String.valueOf((int)currentProgress), "required_progress", String.valueOf(1), "progress_percentage", String.valueOf(progressPercent))).build().sendMessage();
            }
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Failed to show incomplete requirements", exception);
        }
    }

    private void executeRankRewards(@NotNull RDQPlayer rdqPlayer, @NotNull RRank rank) {
        try {
            LOGGER.log(Level.FINE, "Executed rank rewards for " + rdqPlayer.getPlayerName() + " on rank " + rank.getIdentifier());
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Failed to execute rank rewards", exception);
        }
    }

    private void sendNoRequirementsMessage(@NotNull Player player, @NotNull RRank rank) {
        try {
            new I18n.Builder("rank_progression.no_requirements", player).includePrefix().withPlaceholder("rank_name", rank.getIdentifier()).build().sendMessage();
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Failed to send no requirements message", exception);
        }
    }

    @Nullable
    private RRank findInitialRankForTree(@NotNull RRankTree rankTree) {
        return rankTree.getRanks().stream().filter(RRank::isInitialRank).findFirst().orElse(null);
    }

    private boolean playerHasRank(@NotNull RDQPlayer rdqPlayer, @NotNull RRank rank) {
        try {
            List playerRanks = this.rdq.getPlayerRankRepository().findAllByAttributes(Map.of("player.uniqueId", rdqPlayer.getUniqueId()));
            return playerRanks.stream().anyMatch(playerRank -> Objects.equals(playerRank.getCurrentRank(), rank));
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Failed to check if player has rank", exception);
            return false;
        }
    }

    @NotNull
    private List<RRank> getAvailableRanksFoRDQPlayer(@NotNull RDQPlayer rdqPlayer, @NotNull RRankTree rankTree) {
        return List.of();
    }

    @Nullable
    private RPlayerRank getPlayerRankForTree(@NotNull RDQPlayer rdqPlayer, @NotNull RRankTree rankTree) {
        try {
            List playerRanks = this.rdq.getPlayerRankRepository().findAllByAttributes(Map.of("player.uniqueId", rdqPlayer.getUniqueId()));
            return playerRanks.stream().filter(playerRank -> {
                RRankTree playerRankTree = playerRank.getRankTree();
                return playerRankTree != null && Objects.equals(playerRankTree, rankTree);
            }).findFirst().orElse(null);
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Failed to get player rank for tree", exception);
            return null;
        }
    }

    @Nullable
    private RDQPlayer getRDQPlayer(@NotNull SlotClickContext clickContext) {
        try {
            return this.rdq.getPlayerRepository().findByAttributes(Map.of("uniqueId", clickContext.getPlayer().getUniqueId())).orElse(null);
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Failed to get RDQPlayer for player", exception);
            return null;
        }
    }

    private void sendErrorMessage(@NotNull Player player, @NotNull String messageKey) {
        try {
            new I18n.Builder(messageKey, player).includePrefix().build().sendMessage();
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Failed to send error message", exception);
        }
    }
}

