/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rdq.view.ranks.interaction;

import com.raindropcentral.rdq.database.entity.player.RDQPlayer;
import com.raindropcentral.rdq.type.ERankStatus;
import com.raindropcentral.rdq.view.ranks.hierarchy.RankNode;
import com.raindropcentral.rdq.view.ranks.interaction.RankProgressionManager;
import com.raindropcentral.rplatform.logging.CentralLogger;
import de.jexcellence.jextranslate.i18n.I18n;
import de.jexcellence.remapped.me.devnatan.inventoryframework.context.SlotClickContext;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.jetbrains.annotations.NotNull;

public class RankClickHandler {
    private static final Logger LOGGER = CentralLogger.getLogger(RankClickHandler.class.getName());
    private final RankProgressionManager progressionManager;

    public RankClickHandler(@NotNull RankProgressionManager progressionManager) {
        this.progressionManager = progressionManager;
    }

    public void handleRankClick(@NotNull SlotClickContext clickContext, @NotNull RankNode rankNode, @NotNull ERankStatus rankStatus, @NotNull RDQPlayer rdqPlayer, boolean previewMode) {
        try {
            Player player = clickContext.getPlayer();
            ClickType clickType = clickContext.getClickOrigin().getClick();
            LOGGER.log(Level.FINE, "Handling rank click: " + rankNode.rank.getIdentifier() + " - Status: " + String.valueOf((Object)rankStatus) + " - Preview: " + previewMode + " - Click: " + String.valueOf(clickType));
            if (previewMode) {
                this.handlePreviewModeClick(player, rankNode);
                return;
            }
            switch (rankStatus) {
                case OWNED: {
                    this.handleOwnedRankClick(player, rankNode);
                    break;
                }
                case AVAILABLE: {
                    this.handleAvailableRankClick(clickContext, rankNode, clickType, rdqPlayer);
                    break;
                }
                case IN_PROGRESS: {
                    this.handleInProgressRankClick(clickContext, rankNode, clickType);
                    break;
                }
                case LOCKED: {
                    this.handleLockedRankClick(player, rankNode);
                }
            }
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, "Failed to handle rank click", exception);
            this.sendErrorMessage(clickContext.getPlayer(), "rank_click.error.general");
        }
    }

    private void handlePreviewModeClick(@NotNull Player player, @NotNull RankNode rankNode) {
        try {
            new I18n.Builder("rank_click.preview_mode", player).withPlaceholder("rank_name", rankNode.rank.getIdentifier()).includePrefix().build().sendMessage();
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Failed to send preview mode message", exception);
        }
    }

    private void handleOwnedRankClick(@NotNull Player player, @NotNull RankNode rankNode) {
        try {
            new I18n.Builder("rank_click.owned", player).withPlaceholder("rank_name", rankNode.rank.getIdentifier()).includePrefix().build().sendMessage();
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Failed to send owned rank message", exception);
        }
    }

    private void handleAvailableRankClick(@NotNull SlotClickContext clickContext, @NotNull RankNode rankNode, @NotNull ClickType clickType, @NotNull RDQPlayer rdqPlayer) {
        if (clickType == ClickType.LEFT) {
            this.progressionManager.startRankProgression(clickContext, rankNode, rdqPlayer);
        } else if (clickType == ClickType.RIGHT) {
            this.progressionManager.openRequirementsView(clickContext, rankNode);
        }
    }

    private void handleInProgressRankClick(@NotNull SlotClickContext clickContext, @NotNull RankNode rankNode, @NotNull ClickType clickType) {
        if (clickType == ClickType.LEFT) {
            this.progressionManager.attemptRankRedemption(clickContext, rankNode);
        } else if (clickType == ClickType.RIGHT) {
            this.progressionManager.openRequirementsView(clickContext, rankNode);
        }
    }

    private void handleLockedRankClick(@NotNull Player player, @NotNull RankNode rankNode) {
        try {
            new I18n.Builder("rank_click.locked", player).withPlaceholder("rank_name", rankNode.rank.getIdentifier()).includePrefix().build().sendMessage();
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Failed to send locked rank message", exception);
        }
    }

    private void sendErrorMessage(@NotNull Player player, @NotNull String messageKey) {
        try {
            new I18n.Builder(messageKey, player).includePrefix().build().sendMessage();
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Failed to send error message", exception);
        }
    }
}

