/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rdq.view.ranks.hierarchy;

import com.raindropcentral.rdq.database.entity.rank.RRank;
import com.raindropcentral.rdq.database.entity.rank.RRankTree;
import com.raindropcentral.rdq.view.ranks.hierarchy.RankNode;
import com.raindropcentral.rplatform.logging.CentralLogger;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;

public class RankHierarchyBuilder {
    private static final Logger LOGGER = CentralLogger.getLogger(RankHierarchyBuilder.class.getName());

    @NotNull
    public Map<String, RankNode> buildHierarchy(@NotNull RRankTree rankTree) {
        HashMap<String, RankNode> nodeHierarchy = new HashMap<String, RankNode>();
        try {
            for (RRank rank : rankTree.getRanks()) {
                nodeHierarchy.put(rank.getIdentifier(), new RankNode(rank));
            }
            for (RRank rank : rankTree.getRanks()) {
                RankNode currentNode = (RankNode)nodeHierarchy.get(rank.getIdentifier());
                if (currentNode == null) continue;
                this.establishNodeRelationships(currentNode, rank, nodeHierarchy);
            }
            LOGGER.log(Level.FINE, "Built hierarchy with {} nodes", nodeHierarchy.size());
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Error building rank node hierarchy", exception);
        }
        return nodeHierarchy;
    }

    private void establishNodeRelationships(@NotNull RankNode currentNode, @NotNull RRank rank, @NotNull Map<String, RankNode> nodeHierarchy) {
        for (String nextRankId : rank.getNextRanks()) {
            RankNode childNode = nodeHierarchy.get(nextRankId);
            if (childNode != null) {
                currentNode.children.add(childNode);
                childNode.parents.add(currentNode);
                continue;
            }
            LOGGER.log(Level.WARNING, "Child rank not found: {}", nextRankId);
        }
        for (String previousRankId : rank.getPreviousRanks()) {
            RankNode parentNode = nodeHierarchy.get(previousRankId);
            if (parentNode == null || currentNode.parents.contains(parentNode)) continue;
            currentNode.parents.add(parentNode);
            if (parentNode.children.contains(currentNode)) continue;
            parentNode.children.add(currentNode);
        }
    }
}

