/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rdq.view.ranks.grid;

import com.raindropcentral.rdq.view.ranks.grid.GridPosition;
import com.raindropcentral.rdq.view.ranks.grid.GridSlotMapper;
import com.raindropcentral.rdq.view.ranks.hierarchy.RankNode;
import com.raindropcentral.rplatform.logging.CentralLogger;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;

public class RankPositionCalculator {
    private static final Logger LOGGER = CentralLogger.getLogger(RankPositionCalculator.class.getName());
    private static final GridPosition INITIAL_RANK_POSITION = new GridPosition(3, 2);
    private static final int RANK_SPACING_DISTANCE = 5;

    @NotNull
    public Map<String, GridPosition> calculatePositions(@NotNull Map<String, RankNode> rankNodeHierarchy) {
        HashMap<String, GridPosition> worldPositions = new HashMap<String, GridPosition>();
        HashSet<String> positionedRanks = new HashSet<String>();
        try {
            List<RankNode> initialRanks = this.findInitialRanks(rankNodeHierarchy);
            if (initialRanks.isEmpty()) {
                LOGGER.log(Level.WARNING, "No initial ranks found in hierarchy");
                return worldPositions;
            }
            LOGGER.log(Level.FINE, "Found " + initialRanks.size() + " initial ranks");
            if (initialRanks.size() == 1) {
                this.positionSingleInitialRank(initialRanks.get(0), worldPositions, positionedRanks, rankNodeHierarchy);
            } else {
                this.positionMultipleInitialRanks(initialRanks, worldPositions, positionedRanks, rankNodeHierarchy);
            }
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Error calculating rank world positions", exception);
        }
        return worldPositions;
    }

    @NotNull
    private List<RankNode> findInitialRanks(@NotNull Map<String, RankNode> rankNodeHierarchy) {
        return rankNodeHierarchy.values().stream().filter(RankNode::isRoot).sorted(Comparator.comparingInt(node -> node.rank.getTier())).toList();
    }

    private void positionSingleInitialRank(@NotNull RankNode initialRank, @NotNull Map<String, GridPosition> worldPositions, @NotNull Set<String> positionedRanks, @NotNull Map<String, RankNode> rankNodeHierarchy) {
        worldPositions.put(initialRank.rank.getIdentifier(), INITIAL_RANK_POSITION);
        positionedRanks.add(initialRank.rank.getIdentifier());
        Integer slotNumber = GridSlotMapper.getSlotForPosition(INITIAL_RANK_POSITION);
        LOGGER.log(Level.FINE, "Positioned single initial rank '" + initialRank.rank.getIdentifier() + "' at center: " + String.valueOf(INITIAL_RANK_POSITION) + " (slot " + slotNumber + ")");
        this.positionRankChildren(initialRank, INITIAL_RANK_POSITION, worldPositions, positionedRanks, rankNodeHierarchy);
    }

    private void positionMultipleInitialRanks(@NotNull List<RankNode> initialRanks, @NotNull Map<String, GridPosition> worldPositions, @NotNull Set<String> positionedRanks, @NotNull Map<String, RankNode> rankNodeHierarchy) {
        int startX = RankPositionCalculator.INITIAL_RANK_POSITION.x - (initialRanks.size() - 1) * 5 / 2;
        for (int i = 0; i < initialRanks.size(); ++i) {
            RankNode initialRank = initialRanks.get(i);
            GridPosition position = new GridPosition(startX + i * 5, RankPositionCalculator.INITIAL_RANK_POSITION.y);
            worldPositions.put(initialRank.rank.getIdentifier(), position);
            positionedRanks.add(initialRank.rank.getIdentifier());
            Integer slotNumber = GridSlotMapper.getSlotForPosition(position);
            LOGGER.log(Level.FINE, "Positioned initial rank '" + initialRank.rank.getIdentifier() + "' at: " + String.valueOf(position) + " (slot " + slotNumber + ")");
            this.positionRankChildren(initialRank, position, worldPositions, positionedRanks, rankNodeHierarchy);
        }
    }

    private void positionRankChildren(@NotNull RankNode parentNode, @NotNull GridPosition parentPosition, @NotNull Map<String, GridPosition> worldPositions, @NotNull Set<String> positionedRanks, @NotNull Map<String, RankNode> allNodes) {
        if (parentNode.children.isEmpty()) {
            return;
        }
        ArrayList<RankNode> sortedChildren = new ArrayList<RankNode>(parentNode.children);
        sortedChildren.sort(Comparator.comparingInt(node -> node.rank.getTier()));
        if (sortedChildren.size() == 1) {
            this.positionSingleChild((RankNode)sortedChildren.get(0), parentPosition, worldPositions, positionedRanks, allNodes);
        } else {
            this.positionMultipleChildren(sortedChildren, parentPosition, worldPositions, positionedRanks, allNodes);
        }
    }

    private void positionSingleChild(@NotNull RankNode childNode, @NotNull GridPosition parentPosition, @NotNull Map<String, GridPosition> worldPositions, @NotNull Set<String> positionedRanks, @NotNull Map<String, RankNode> allNodes) {
        if (positionedRanks.contains(childNode.rank.getIdentifier())) {
            return;
        }
        GridPosition childPosition = parentPosition.offset(0, 5);
        worldPositions.put(childNode.rank.getIdentifier(), childPosition);
        positionedRanks.add(childNode.rank.getIdentifier());
        Integer slotNumber = GridSlotMapper.getSlotForPosition(childPosition);
        LOGGER.log(Level.FINE, "Positioned single child '" + childNode.rank.getIdentifier() + "' below parent at: " + String.valueOf(childPosition) + " (slot " + slotNumber + ")");
        this.positionRankChildren(childNode, childPosition, worldPositions, positionedRanks, allNodes);
    }

    private void positionMultipleChildren(@NotNull List<RankNode> children, @NotNull GridPosition parentPosition, @NotNull Map<String, GridPosition> worldPositions, @NotNull Set<String> positionedRanks, @NotNull Map<String, RankNode> allNodes) {
        int childY = parentPosition.y + 5;
        int totalWidth = (children.size() - 1) * 5;
        int startX = parentPosition.x - totalWidth / 2;
        for (int i = 0; i < children.size(); ++i) {
            RankNode child = children.get(i);
            if (positionedRanks.contains(child.rank.getIdentifier())) continue;
            GridPosition childPosition = new GridPosition(startX + i * 5, childY);
            worldPositions.put(child.rank.getIdentifier(), childPosition);
            positionedRanks.add(child.rank.getIdentifier());
            Integer slotNumber = GridSlotMapper.getSlotForPosition(childPosition);
            LOGGER.log(Level.FINE, "Positioned child '" + child.rank.getIdentifier() + "' at balanced position: " + String.valueOf(childPosition) + " (slot " + slotNumber + ")");
            this.positionRankChildren(child, childPosition, worldPositions, positionedRanks, allNodes);
        }
    }
}

