/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rdq.view.ranks.grid;

import com.raindropcentral.rdq.view.ranks.grid.GridPosition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GridSlotMapper {
    private static final Map<GridPosition, Integer> RANK_SLOT_MAPPING = GridSlotMapper.createRankSlotMapping();
    private static final List<Integer> ALL_RANK_SLOT_NUMBERS = GridSlotMapper.createAllRankSlotNumbers();

    @Nullable
    public static Integer getSlotForPosition(@NotNull GridPosition position) {
        return RANK_SLOT_MAPPING.get(position);
    }

    @Nullable
    public static GridPosition getPositionForSlot(int slotNumber) {
        for (Map.Entry<GridPosition, Integer> entry : RANK_SLOT_MAPPING.entrySet()) {
            if (!entry.getValue().equals(slotNumber)) continue;
            return entry.getKey();
        }
        return null;
    }

    @NotNull
    public static List<Integer> getAllRankSlotNumbers() {
        return new ArrayList<Integer>(ALL_RANK_SLOT_NUMBERS);
    }

    @NotNull
    public static Map<GridPosition, Integer> getSlotMapping() {
        return new HashMap<GridPosition, Integer>(RANK_SLOT_MAPPING);
    }

    public static boolean isValidRankSlot(int slotNumber) {
        return ALL_RANK_SLOT_NUMBERS.contains(slotNumber);
    }

    @NotNull
    private static Map<GridPosition, Integer> createRankSlotMapping() {
        HashMap<GridPosition, Integer> mapping = new HashMap<GridPosition, Integer>();
        mapping.put(new GridPosition(0, 0), 1);
        mapping.put(new GridPosition(1, 0), 2);
        mapping.put(new GridPosition(2, 0), 3);
        mapping.put(new GridPosition(3, 0), 5);
        mapping.put(new GridPosition(4, 0), 6);
        mapping.put(new GridPosition(5, 0), 7);
        mapping.put(new GridPosition(0, 1), 10);
        mapping.put(new GridPosition(1, 1), 11);
        mapping.put(new GridPosition(2, 1), 12);
        mapping.put(new GridPosition(3, 1), 13);
        mapping.put(new GridPosition(4, 1), 14);
        mapping.put(new GridPosition(5, 1), 15);
        mapping.put(new GridPosition(6, 1), 16);
        mapping.put(new GridPosition(0, 2), 19);
        mapping.put(new GridPosition(1, 2), 20);
        mapping.put(new GridPosition(2, 2), 21);
        mapping.put(new GridPosition(3, 2), 22);
        mapping.put(new GridPosition(4, 2), 23);
        mapping.put(new GridPosition(5, 2), 24);
        mapping.put(new GridPosition(6, 2), 25);
        mapping.put(new GridPosition(0, 3), 28);
        mapping.put(new GridPosition(1, 3), 29);
        mapping.put(new GridPosition(2, 3), 30);
        mapping.put(new GridPosition(3, 3), 31);
        mapping.put(new GridPosition(4, 3), 32);
        mapping.put(new GridPosition(5, 3), 33);
        mapping.put(new GridPosition(6, 3), 34);
        mapping.put(new GridPosition(0, 4), 37);
        mapping.put(new GridPosition(1, 4), 38);
        mapping.put(new GridPosition(2, 4), 39);
        mapping.put(new GridPosition(3, 4), 40);
        mapping.put(new GridPosition(4, 4), 41);
        mapping.put(new GridPosition(5, 4), 42);
        mapping.put(new GridPosition(6, 4), 43);
        return mapping;
    }

    @NotNull
    private static List<Integer> createAllRankSlotNumbers() {
        ArrayList<Integer> slots = new ArrayList<Integer>();
        slots.addAll(List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(5), Integer.valueOf(6), Integer.valueOf(7)));
        slots.addAll(List.of(Integer.valueOf(10), Integer.valueOf(11), Integer.valueOf(12), Integer.valueOf(13), Integer.valueOf(14), Integer.valueOf(15), Integer.valueOf(16)));
        slots.addAll(List.of(Integer.valueOf(19), Integer.valueOf(20), Integer.valueOf(21), Integer.valueOf(22), Integer.valueOf(23), Integer.valueOf(24), Integer.valueOf(25)));
        slots.addAll(List.of(Integer.valueOf(28), Integer.valueOf(29), Integer.valueOf(30), Integer.valueOf(31), Integer.valueOf(32), Integer.valueOf(33), Integer.valueOf(34)));
        slots.addAll(List.of(Integer.valueOf(37), Integer.valueOf(38), Integer.valueOf(39), Integer.valueOf(40), Integer.valueOf(41), Integer.valueOf(42), Integer.valueOf(43)));
        return slots;
    }
}

