/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rdq.view.ranks.grid;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class GridPosition {
    public final int x;
    public final int y;

    public GridPosition(int x, int y) {
        this.x = x;
        this.y = y;
    }

    @NotNull
    public GridPosition offset(int deltaX, int deltaY) {
        return new GridPosition(this.x + deltaX, this.y + deltaY);
    }

    public double distanceTo(@NotNull GridPosition other) {
        int deltaX = this.x - other.x;
        int deltaY = this.y - other.y;
        return Math.sqrt(deltaX * deltaX + deltaY * deltaY);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        GridPosition that = (GridPosition)obj;
        return this.x == that.x && this.y == that.y;
    }

    public int hashCode() {
        return Objects.hash(this.x, this.y);
    }

    public String toString() {
        return "GridPosition{x=" + this.x + ", y=" + this.y + "}";
    }
}

