/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rdq.view.ranks.cache;

import com.raindropcentral.rdq.RDQ;
import com.raindropcentral.rdq.database.entity.player.RDQPlayer;
import com.raindropcentral.rdq.database.entity.rank.RRankTree;
import com.raindropcentral.rdq.type.ERankStatus;
import com.raindropcentral.rdq.view.ranks.grid.GridPosition;
import com.raindropcentral.rdq.view.ranks.grid.RankPositionCalculator;
import com.raindropcentral.rdq.view.ranks.hierarchy.RankHierarchyBuilder;
import com.raindropcentral.rdq.view.ranks.hierarchy.RankNode;
import com.raindropcentral.rplatform.logging.CentralLogger;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;

public class RankDataCache {
    private static final Logger LOGGER = CentralLogger.getLogger(RankDataCache.class.getName());
    private final RankHierarchyBuilder hierarchyBuilder = new RankHierarchyBuilder();
    private final RankPositionCalculator positionCalculator = new RankPositionCalculator();
    private Map<String, RankNode> cachedRankHierarchy = new HashMap<String, RankNode>();
    private Map<String, GridPosition> cachedWorldPositions = new HashMap<String, GridPosition>();
    private Map<String, ERankStatus> cachedRankStatuses = new HashMap<String, ERankStatus>();
    private Set<String> cachedOwnedRanks = new HashSet<String>();
    private Set<String> cachedInProgressRanks = new HashSet<String>();
    private long lastRefreshTimestamp = 0L;

    public void initializeCache(@NotNull RRankTree rankTree, @NotNull RDQ plugin, @NotNull RDQPlayer rdqPlayer, boolean previewMode) {
        try {
            LOGGER.log(Level.FINE, "Initializing rank data cache...");
            this.cachedRankHierarchy = this.hierarchyBuilder.buildHierarchy(rankTree);
            this.cachedWorldPositions = this.positionCalculator.calculatePositions(this.cachedRankHierarchy);
            if (!previewMode) {
                this.cachedOwnedRanks = this.loadOwnedRanks(plugin, rdqPlayer, rankTree);
                this.cachedInProgressRanks = this.loadInProgressRanks(plugin, rdqPlayer, rankTree);
                this.cachedRankStatuses = this.calculateAllRankStatuses(previewMode);
                LOGGER.log(Level.FINE, "Cached data: " + this.cachedOwnedRanks.size() + " owned ranks, " + this.cachedInProgressRanks.size() + " in-progress ranks");
            } else {
                this.cachedRankStatuses = this.calculatePreviewStatuses();
            }
            this.lastRefreshTimestamp = System.currentTimeMillis();
            LOGGER.log(Level.FINE, "Data caching completed successfully");
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, "Failed to initialize cache", exception);
            this.clearCache();
        }
    }

    public void clearCache() {
        this.cachedRankHierarchy.clear();
        this.cachedWorldPositions.clear();
        this.cachedRankStatuses.clear();
        this.cachedOwnedRanks.clear();
        this.cachedInProgressRanks.clear();
        this.lastRefreshTimestamp = 0L;
    }

    public boolean needsRefresh(long maxAgeMillis) {
        return System.currentTimeMillis() - this.lastRefreshTimestamp > maxAgeMillis;
    }

    @NotNull
    public Map<String, RankNode> getRankHierarchy() {
        return new HashMap<String, RankNode>(this.cachedRankHierarchy);
    }

    @NotNull
    public Map<String, GridPosition> getWorldPositions() {
        return new HashMap<String, GridPosition>(this.cachedWorldPositions);
    }

    @NotNull
    public Map<String, ERankStatus> getRankStatuses() {
        return new HashMap<String, ERankStatus>(this.cachedRankStatuses);
    }

    @NotNull
    public Set<String> getOwnedRanks() {
        return new HashSet<String>(this.cachedOwnedRanks);
    }

    @NotNull
    public Set<String> getInProgressRanks() {
        return new HashSet<String>(this.cachedInProgressRanks);
    }

    public long getLastRefreshTimestamp() {
        return this.lastRefreshTimestamp;
    }

    @NotNull
    private Set<String> loadOwnedRanks(@NotNull RDQ plugin, @NotNull RDQPlayer rdqPlayer, @NotNull RRankTree rankTree) {
        return new HashSet<String>();
    }

    @NotNull
    private Set<String> loadInProgressRanks(@NotNull RDQ plugin, @NotNull RDQPlayer rdqPlayer, @NotNull RRankTree rankTree) {
        return new HashSet<String>();
    }

    @NotNull
    private Map<String, ERankStatus> calculateAllRankStatuses(boolean previewMode) {
        HashMap<String, ERankStatus> statuses = new HashMap<String, ERankStatus>();
        if (previewMode) {
            return this.calculatePreviewStatuses();
        }
        for (Map.Entry<String, RankNode> entry : this.cachedRankHierarchy.entrySet()) {
            String rankId = entry.getKey();
            RankNode rankNode = entry.getValue();
            if (this.cachedOwnedRanks.contains(rankId)) {
                statuses.put(rankId, ERankStatus.OWNED);
                continue;
            }
            if (this.cachedInProgressRanks.contains(rankId)) {
                statuses.put(rankId, ERankStatus.IN_PROGRESS);
                continue;
            }
            if (this.arePrerequisitesMet(rankNode)) {
                statuses.put(rankId, ERankStatus.AVAILABLE);
                continue;
            }
            statuses.put(rankId, ERankStatus.LOCKED);
        }
        return statuses;
    }

    @NotNull
    private Map<String, ERankStatus> calculatePreviewStatuses() {
        HashMap<String, ERankStatus> previewStatuses = new HashMap<String, ERankStatus>();
        Iterator<Map.Entry<String, RankNode>> iterator = this.cachedRankHierarchy.entrySet().iterator();
        while (iterator.hasNext()) {
            RankNode rankNode;
            Map.Entry<String, RankNode> entry;
            previewStatuses.put(entry.getKey(), (rankNode = (entry = iterator.next()).getValue()).isRoot() ? ERankStatus.OWNED : ERankStatus.AVAILABLE);
        }
        return previewStatuses;
    }

    private boolean arePrerequisitesMet(@NotNull RankNode rankNode) {
        if (rankNode.parents.isEmpty() || rankNode.rank.isInitialRank()) {
            return true;
        }
        return rankNode.parents.stream().anyMatch(parent -> this.cachedOwnedRanks.contains(parent.rank.getIdentifier()));
    }
}

