/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rdq.view.ranks;

import com.raindropcentral.rdq.RDQ;
import com.raindropcentral.rdq.database.entity.player.RDQPlayer;
import com.raindropcentral.rdq.database.entity.rank.RPlayerRankPath;
import com.raindropcentral.rdq.database.entity.rank.RRank;
import com.raindropcentral.rdq.database.entity.rank.RRankTree;
import com.raindropcentral.rdq.rank.IRankSystemService;
import com.raindropcentral.rdq.service.RankPathService;
import com.raindropcentral.rdq.view.ranks.RankMainView;
import com.raindropcentral.rdq.view.ranks.RankPathOverview;
import com.raindropcentral.rplatform.logging.CentralLogger;
import com.raindropcentral.rplatform.utility.heads.view.Proceed;
import com.raindropcentral.rplatform.utility.unified.UnifiedBuilderFactory;
import com.raindropcentral.rplatform.view.APaginatedView;
import de.jexcellence.remapped.me.devnatan.inventoryframework.component.BukkitItemComponentBuilder;
import de.jexcellence.remapped.me.devnatan.inventoryframework.context.Context;
import de.jexcellence.remapped.me.devnatan.inventoryframework.context.RenderContext;
import de.jexcellence.remapped.me.devnatan.inventoryframework.context.SlotClickContext;
import de.jexcellence.remapped.me.devnatan.inventoryframework.state.MutableState;
import de.jexcellence.remapped.me.devnatan.inventoryframework.state.State;
import de.jexcellence.remapped.me.devnatan.inventoryframework.state.StateValueHost;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.kyori.adventure.text.Component;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemFlag;
import org.hibernate.Hibernate;
import org.jetbrains.annotations.NotNull;

public class RankTreeOverviewView
extends APaginatedView<RRankTree> {
    private static final Logger LOGGER = CentralLogger.getLogger("RDQ");
    private final State<RDQ> rdq = this.initialState("plugin");
    private final MutableState<RDQPlayer> rdqPlayer = this.initialState("player");

    public RankTreeOverviewView() {
        super(RankMainView.class);
    }

    @Override
    protected String getKey() {
        return "rank_tree_overview_ui";
    }

    @Override
    protected String[] getLayout() {
        return new String[]{"         ", "  OOOOO  ", "   <p>   ", "         ", "         ", "b       c"};
    }

    @Override
    protected CompletableFuture<List<RRankTree>> getAsyncPaginationSource(@NotNull Context context) {
        RDQ plugin = (RDQ)this.rdq.get((StateValueHost)context);
        Map<String, RRankTree> cachedTrees = plugin.getRankSystemFactory().getRankTrees();
        LOGGER.info("RankTreeOverviewView - Using cached trees: " + cachedTrees.size() + " trees: " + String.valueOf(cachedTrees.keySet()));
        return CompletableFuture.supplyAsync(() -> {
            ArrayList<RRankTree> enabledTrees = new ArrayList<RRankTree>(cachedTrees.values().stream().filter(RRankTree::isEnabled).toList());
            LOGGER.info("RankTreeOverviewView - After filtering enabled: " + enabledTrees.size() + " trees");
            for (RRankTree tree : enabledTrees) {
                LOGGER.info("  Tree: " + tree.getIdentifier() + ", enabled=" + tree.isEnabled() + ", ranks=" + (tree.getRanks() != null ? tree.getRanks().size() : 0));
            }
            enabledTrees.sort(Comparator.comparingInt(RRankTree::getDisplayOrder));
            return enabledTrees;
        });
    }

    @Override
    protected void renderEntry(@NotNull Context context, @NotNull BukkitItemComponentBuilder builder, int index, @NotNull RRankTree rankTree) {
        try {
            Player player = context.getPlayer();
            RDQ plugin = (RDQ)this.rdq.get((StateValueHost)context);
            RankPathService pathService = plugin.getRankPathService();
            IRankSystemService rankSystemService = plugin.getRankSystemService();
            RDQPlayer currentPlayer = (RDQPlayer)this.rdqPlayer.get((StateValueHost)context);
            if (currentPlayer == null) {
                LOGGER.warning("RankTreeOverviewView - currentPlayer is null for tree: " + rankTree.getIdentifier());
                builder.withItem(UnifiedBuilderFactory.item(Material.PAPER).setName((Component)this.i18n(rankTree.getDisplayNameKey(), player).build().component()).addItemFlags(ItemFlag.HIDE_ATTRIBUTES).build());
                return;
            }
            boolean hasSelectedPath = this.hasPlayerSelectedRankTree(currentPlayer, rankTree);
            boolean isCurrentlyActive = pathService.hasSelectedRankPath(currentPlayer, rankTree);
            boolean meetsPrerequisites = this.checkRankTreePrerequisites(currentPlayer, rankTree, pathService);
            boolean isPreviewOnlyDueToFreeVersion = rankSystemService != null && rankSystemService.isPreviewOnly(currentPlayer, rankTree);
            RankTreeDisplayState displayState = this.determineDisplayState(hasSelectedPath, isCurrentlyActive, meetsPrerequisites, isPreviewOnlyDueToFreeVersion, rankTree);
            Material material = this.getMaterialForState(rankTree, displayState);
            List<Component> lore = this.buildLoreForRankTree(player, rankTree, displayState, hasSelectedPath, isCurrentlyActive);
            ((BukkitItemComponentBuilder)builder.withItem(UnifiedBuilderFactory.item(material).setName((Component)this.i18n(rankTree.getDisplayNameKey(), player).build().component()).setLore(lore).addItemFlags(ItemFlag.HIDE_ATTRIBUTES).build()).updateOnClick()).onClick(clickContext -> this.handleRankTreeClick((SlotClickContext)clickContext, rankTree, displayState, hasSelectedPath, isCurrentlyActive));
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, "Failed to render rank tree entry: " + rankTree.getIdentifier(), exception);
            builder.withItem(UnifiedBuilderFactory.item(Material.BARRIER).setName((Component)Component.text((String)("Error: " + rankTree.getIdentifier()))).addItemFlags(ItemFlag.HIDE_ATTRIBUTES).build());
        }
    }

    private boolean hasPlayerSelectedRankTree(@NotNull RDQPlayer player, @NotNull RRankTree rankTree) {
        if (player.getPlayerRankPaths() == null) {
            return false;
        }
        return player.getPlayerRankPaths().stream().anyMatch(rankPath -> rankPath.getSelectedRankPath() != null && rankPath.getSelectedRankPath().equals(rankTree));
    }

    private RankTreeDisplayState determineDisplayState(boolean hasSelectedPath, boolean isCurrentlyActive, boolean meetsPrerequisites, boolean isPreviewOnlyDueToFreeVersion, RRankTree rankTree) {
        if (hasSelectedPath) {
            if (isCurrentlyActive) {
                return RankTreeDisplayState.CURRENTLY_ACTIVE;
            }
            return RankTreeDisplayState.PREVIOUSLY_SELECTED;
        }
        if (isPreviewOnlyDueToFreeVersion) {
            return RankTreeDisplayState.FREE_VERSION_PREVIEW_ONLY;
        }
        if (!meetsPrerequisites) {
            return RankTreeDisplayState.LOCKED;
        }
        return RankTreeDisplayState.AVAILABLE;
    }

    private boolean checkRankTreePrerequisites(@NotNull RDQPlayer rdqPlayer, @NotNull RRankTree rankTree, @NotNull RankPathService pathService) {
        int minimumRequired = rankTree.getMinimumRankTreesToBeDone();
        int completedTrees = this.getCompletedRankTreesCount(rdqPlayer);
        if (completedTrees < minimumRequired) {
            return false;
        }
        if (!Hibernate.isInitialized(rankTree.getPrerequisiteRankTrees())) {
            return true;
        }
        for (RRankTree prerequisite : rankTree.getPrerequisiteRankTrees()) {
            if (this.isRankTreeCompleted(rdqPlayer, prerequisite)) continue;
            return false;
        }
        return true;
    }

    private Material getMaterialForState(@NotNull RRankTree rankTree, @NotNull RankTreeDisplayState state) {
        try {
            return switch (state.ordinal()) {
                case 1 -> Material.BARRIER;
                case 4 -> Material.SPYGLASS;
                default -> Material.valueOf((String)rankTree.getIcon().getMaterial().toUpperCase());
            };
        }
        catch (IllegalArgumentException exception) {
            return Material.PAPER;
        }
    }

    private List<Component> buildLoreForRankTree(@NotNull Player player, @NotNull RRankTree rankTree, @NotNull RankTreeDisplayState state, boolean hasSelectedPath, boolean isCurrentlyActive) {
        ArrayList<Component> lore = new ArrayList<Component>(this.i18n(rankTree.getDescriptionKey(), player).build().children());
        lore.add((Component)Component.empty());
        switch (state.ordinal()) {
            case 0: {
                lore.addAll(this.i18n("click.preview_rank_path", player).build().children());
                break;
            }
            case 1: {
                lore.add((Component)this.i18n("click.locked", player).build().component());
                if (rankTree.getMinimumRankTreesToBeDone() > 0) {
                    lore.addAll(this.i18n("click.locked.required", player).withPlaceholder("minimum_rank_paths_to_be_absolved_needed", rankTree.getMinimumRankTreesToBeDone()).build().children());
                }
                if (!Hibernate.isInitialized(rankTree.getPrerequisiteRankTrees()) || rankTree.getPrerequisiteRankTrees().isEmpty()) break;
                lore.add((Component)this.i18n("click.pre_requisites", player).build().component());
                for (RRankTree prereq : rankTree.getPrerequisiteRankTrees()) {
                    lore.addAll(this.i18n("click.pre_requisites_" + prereq.getDisplayNameKey(), player).build().children());
                }
                break;
            }
            case 2: {
                lore.add((Component)this.i18n("currently_active", player).build().component());
                lore.add((Component)this.i18n("click_to_preview", player).build().component());
                lore.add((Component)this.i18n("click_to_continue", player).build().component());
                break;
            }
            case 3: {
                lore.add((Component)this.i18n("previously_selected", player).build().component());
                lore.add((Component)this.i18n("click_to_preview", player).build().component());
                lore.add((Component)this.i18n("click_to_reactivate", player).build().component());
                break;
            }
            case 4: {
                lore.add((Component)Component.empty());
                lore.add((Component)this.i18n("free_version_preview_only", player).build().component());
                lore.addAll(this.i18n("free_version_preview_only_lore", player).build().children());
            }
        }
        return lore;
    }

    private void handleRankTreeClick(@NotNull SlotClickContext clickContext, @NotNull RRankTree rankTree, @NotNull RankTreeDisplayState state, boolean hasSelectedPath, boolean isCurrentlyActive) {
        Player player = clickContext.getPlayer();
        ClickType clickType = clickContext.getClickOrigin().getClick();
        switch (state.ordinal()) {
            case 0: {
                if (clickType == ClickType.LEFT) {
                    this.openRankTreePreview((Context)clickContext, rankTree);
                    break;
                }
                if (clickType != ClickType.RIGHT) break;
                int maximumRankPathsAllowed = ((RDQ)this.rdq.get((StateValueHost)clickContext)).getRankSystemFactory().getRankSystemSection().getProgressionRule().getMaximumActiveRankTrees();
                if (maximumRankPathsAllowed <= ((RDQ)this.rdq.get((StateValueHost)clickContext)).getPlayerRankPathRepository().findAllByAttributes(Map.of("player.uniqueId", player.getUniqueId())).stream().toList().size()) {
                    this.i18n("maximum_active_rank_paths_reached", player).includePrefix().withPlaceholder("maximum_rank_path_amount", maximumRankPathsAllowed).build().sendMessage();
                    break;
                }
                this.selectRankTree((Context)clickContext, rankTree);
                break;
            }
            case 1: {
                if (clickType == ClickType.LEFT) {
                    this.openRankTreePreview((Context)clickContext, rankTree);
                    return;
                }
                this.i18n("click.rank_path_locked", player).includePrefix().build().sendMessage();
                break;
            }
            case 2: {
                if (clickType == ClickType.LEFT) {
                    this.openRankTreePreview((Context)clickContext, rankTree);
                    break;
                }
                if (clickType != ClickType.RIGHT) break;
                this.openRankPathOverview((Context)clickContext, rankTree, false);
                break;
            }
            case 3: {
                if (clickType == ClickType.LEFT) {
                    this.openRankTreePreview((Context)clickContext, rankTree);
                    break;
                }
                if (clickType != ClickType.RIGHT) break;
                this.reactivateRankTree((Context)clickContext, rankTree);
                break;
            }
            case 4: {
                if (clickType == ClickType.LEFT) {
                    this.openRankTreePreview((Context)clickContext, rankTree);
                    break;
                }
                if (clickType != ClickType.RIGHT) break;
                this.i18n("free_version_upgrade_required", player).includePrefix().build().sendMessage();
            }
        }
    }

    private void openRankTreePreview(@NotNull Context context, @NotNull RRankTree rankTree) {
        context.openForPlayer(RankPathOverview.class, Map.of("plugin", this.rdq.get((StateValueHost)context), "player", this.rdqPlayer.get((StateValueHost)context), "rankTree", rankTree, "previewMode", true));
    }

    private void openRankPathOverview(@NotNull Context context, @NotNull RRankTree rankTree, boolean previewMode) {
        context.openForPlayer(RankPathOverview.class, Map.of("plugin", this.rdq.get((StateValueHost)context), "player", this.rdqPlayer.get((StateValueHost)context), "rankTree", rankTree, "previewMode", previewMode));
    }

    private void selectRankTree(@NotNull Context context, @NotNull RRankTree rankTree) {
        Player player = context.getPlayer();
        RRank startingRank = this.findStartingRank(rankTree);
        if (startingRank == null) {
            this.i18n("select.rank_path_starting_rank_not_found", player).includePrefix().build().sendMessage();
            return;
        }
        boolean success = ((RDQ)this.rdq.get((StateValueHost)context)).getRankPathService().selectRankPath((RDQPlayer)this.rdqPlayer.get((StateValueHost)context), rankTree, startingRank);
        if (success) {
            this.i18n("select.rank_path_selected", player).includePrefix().withPlaceholders(Map.of("rank_path", rankTree.getIdentifier(), "rank", startingRank.getIdentifier())).build().sendMessage();
            this.openRankPathOverview(context, rankTree, false);
        } else {
            this.i18n("select.rank_path_selection_failed", player).includePrefix().build().sendMessage();
        }
    }

    private void reactivateRankTree(@NotNull Context context, @NotNull RRankTree rankTree) {
        Player player = context.getPlayer();
        RRank startingRank = this.findStartingRank(rankTree);
        if (startingRank == null) {
            this.i18n("select.rank_path_starting_rank_not_found", player).includePrefix().build().sendMessage();
            return;
        }
        boolean success = ((RDQ)this.rdq.get((StateValueHost)context)).getRankPathService().switchRankPath((RDQPlayer)this.rdqPlayer.get((StateValueHost)context), rankTree, startingRank);
        if (success) {
            this.i18n("select.rank_path_reactivated", player).includePrefix().withPlaceholders(Map.of("rank_path", rankTree.getIdentifier())).build().sendMessage();
            this.openRankPathOverview(context, rankTree, false);
        } else {
            this.i18n("select.rank_path_reactivation_failed", player).includePrefix().build().sendMessage();
        }
    }

    private RRank findStartingRank(@NotNull RRankTree rankTree) {
        return rankTree.getRanks().stream().filter(RRank::isInitialRank).findFirst().orElse(null);
    }

    private int getCompletedRankTreesCount(@NotNull RDQPlayer rdqPlayer) {
        return rdqPlayer.getPlayerRankPaths().stream().filter(RPlayerRankPath::isCompleted).toList().size();
    }

    private boolean isRankTreeCompleted(@NotNull RDQPlayer rdqPlayer, @NotNull RRankTree rankTree) {
        return rdqPlayer.getPlayerRankPaths().stream().anyMatch(RDQPlayerRankPath -> RDQPlayerRankPath.getSelectedRankPath().equals(rankTree) && RDQPlayerRankPath.isCompleted());
    }

    @Override
    protected void onPaginatedRender(@NotNull RenderContext render, @NotNull Player player) {
        render.layoutSlot('c', UnifiedBuilderFactory.item(new Proceed().getHead(player)).setName((Component)this.i18n("create_rank_tree.name", player).build().component()).setLore(this.i18n("create_rank_tree.lore", player).build().children()).addItemFlags(ItemFlag.HIDE_ATTRIBUTES).build()).onClick(slotClickContext -> this.i18n("select.rank_tree_creation_coming_soon", player).includePrefix().build().sendMessage()).displayIf(() -> ((Player)player).isOp());
    }

    private static enum RankTreeDisplayState {
        AVAILABLE,
        LOCKED,
        CURRENTLY_ACTIVE,
        PREVIOUSLY_SELECTED,
        FREE_VERSION_PREVIEW_ONLY;

    }
}

