/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rdq.view.ranks;

import com.raindropcentral.rdq.RDQ;
import com.raindropcentral.rdq.database.entity.player.RDQPlayer;
import com.raindropcentral.rdq.database.entity.rank.RPlayerRank;
import com.raindropcentral.rdq.database.entity.rank.RRank;
import com.raindropcentral.rdq.database.entity.rank.RRankTree;
import com.raindropcentral.rdq.database.entity.rank.RRankUpgradeRequirement;
import com.raindropcentral.rdq.manager.RankRequirementProgressManager;
import com.raindropcentral.rdq.view.ranks.RankPathOverview;
import com.raindropcentral.rdq.view.ranks.RankRequirementDetailView;
import com.raindropcentral.rdq.view.ranks.util.RequirementCardRenderer;
import com.raindropcentral.rdq.view.ranks.util.RequirementProgressRenderer;
import com.raindropcentral.rplatform.logging.CentralLogger;
import com.raindropcentral.rplatform.utility.unified.UnifiedBuilderFactory;
import com.raindropcentral.rplatform.view.BaseView;
import de.jexcellence.remapped.me.devnatan.inventoryframework.component.BukkitItemComponentBuilder;
import de.jexcellence.remapped.me.devnatan.inventoryframework.context.Context;
import de.jexcellence.remapped.me.devnatan.inventoryframework.context.OpenContext;
import de.jexcellence.remapped.me.devnatan.inventoryframework.context.RenderContext;
import de.jexcellence.remapped.me.devnatan.inventoryframework.context.SlotClickContext;
import de.jexcellence.remapped.me.devnatan.inventoryframework.state.MutableState;
import de.jexcellence.remapped.me.devnatan.inventoryframework.state.State;
import de.jexcellence.remapped.me.devnatan.inventoryframework.state.StateValueHost;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.kyori.adventure.text.Component;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;

public class RankRequirementsJourneyView
extends BaseView {
    private static final Logger LOGGER = CentralLogger.getLogger("RDQ");
    private final State<RDQ> rdq = this.initialState("plugin");
    private final State<RDQPlayer> currentPlayer = this.initialState("player");
    private final State<RRank> targetRank = this.initialState("targetRank");
    private final State<RRankTree> selectedRankTree = this.initialState("rankTree");
    private final State<Boolean> previewMode = this.initialState("previewMode");
    private final MutableState<Boolean> allCompleted = this.mutableState(false);
    private final MutableState<Boolean> pulseState = this.mutableState(false);
    private BukkitRunnable pulseTask;
    private static final int BACK_SLOT = 0;
    private static final int RANK_INFO_SLOT = 4;
    private static final int CLAIM_BUTTON_SLOT = 8;
    private static final int OVERALL_PROGRESS_SLOT = 22;
    private static final int[] REQUIREMENT_SLOTS = new int[]{28, 30, 32, 34};
    private static final int[] CONNECTION_SLOTS = new int[]{29, 31, 33};
    private static final int[] OVERFLOW_SLOTS = new int[]{37, 39, 41, 43};
    private static final int[] OVERFLOW_CONNECTION_SLOTS = new int[]{38, 40, 42};
    private RankRequirementProgressManager progressManager;
    private RequirementProgressRenderer progressRenderer;
    private RequirementCardRenderer cardRenderer;

    public RankRequirementsJourneyView() {
        super(RankPathOverview.class);
    }

    @Override
    protected String getKey() {
        return "rank_requirements_journey_ui";
    }

    @Override
    @NotNull
    protected Map<String, Object> getTitlePlaceholders(@NotNull OpenContext openContext) {
        RRank rank = (RRank)this.targetRank.get((StateValueHost)openContext);
        return Map.of("rank_name", rank != null ? rank.getIdentifier() : "Unknown");
    }

    @Override
    public void onResume(@NotNull Context origin, @NotNull Context target) {
        super.onResume(origin, target);
        try {
            Player player = target.getPlayer();
            RDQPlayer rdqPlayer = (RDQPlayer)this.currentPlayer.get((StateValueHost)target);
            RRank rank = (RRank)this.targetRank.get((StateValueHost)target);
            if (this.progressManager != null && rank != null && rdqPlayer != null) {
                this.progressManager.refreshRankProgress(player, rdqPlayer, rank);
                boolean canClaim = this.progressManager.areAllRequirementsCompleted(player, rdqPlayer, rank);
                this.allCompleted.set((Object)canClaim, (StateValueHost)target);
                LOGGER.log(Level.FINE, "Resumed journey view, allCompleted=" + canClaim);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Failed to refresh progress on resume", e);
        }
    }

    @Override
    protected void handleBackButtonClick(@NotNull SlotClickContext clickContext) {
        try {
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("plugin", this.rdq.get((StateValueHost)clickContext));
            data.put("player", this.currentPlayer.get((StateValueHost)clickContext));
            data.put("rankTree", this.selectedRankTree.get((StateValueHost)clickContext));
            data.put("previewMode", this.previewMode.get((StateValueHost)clickContext));
            clickContext.openForPlayer(RankPathOverview.class, data);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Failed to navigate back to RankPathOverview", e);
            clickContext.closeForPlayer();
        }
    }

    @Override
    public void onFirstRender(@NotNull RenderContext render, @NotNull Player player) {
        try {
            RDQ plugin = (RDQ)this.rdq.get((StateValueHost)render);
            RRank rank = (RRank)this.targetRank.get((StateValueHost)render);
            RDQPlayer rdqPlayer = (RDQPlayer)this.currentPlayer.get((StateValueHost)render);
            boolean isPreviewMode = (Boolean)this.previewMode.get((StateValueHost)render);
            if (rank == null) {
                this.renderErrorState(render, player);
                return;
            }
            this.progressManager = new RankRequirementProgressManager(plugin);
            this.progressRenderer = new RequirementProgressRenderer();
            this.cardRenderer = new RequirementCardRenderer();
            this.progressManager.initializeRankProgressTracking(rdqPlayer, rank);
            this.renderRankInfo(render, player, rank);
            this.renderProgressBar(render, player, rank, rdqPlayer);
            this.renderOverallProgress(render, player, rank, rdqPlayer);
            this.renderRequirementCards(render, player, rank, rdqPlayer, isPreviewMode);
            this.renderClaimOrLockedButton(render, player, rank, rdqPlayer, isPreviewMode);
            this.startPulseAnimation(render, plugin);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Failed to render journey view", e);
            this.renderErrorState(render, player);
        }
    }

    private void renderRankInfo(@NotNull RenderContext render, @NotNull Player player, @NotNull RRank rank) {
        ((BukkitItemComponentBuilder)render.slot(4)).renderWith(() -> {
            try {
                Material icon = Material.valueOf((String)rank.getIcon().getMaterial().toUpperCase());
                return UnifiedBuilderFactory.item(icon).setName((Component)this.i18n("rank_info.name", player).withPlaceholder("rank_name", rank.getIdentifier()).build().component()).setLore(this.i18n("rank_info.lore", player).build().children()).addItemFlags(ItemFlag.HIDE_ATTRIBUTES).build();
            }
            catch (Exception e) {
                return UnifiedBuilderFactory.item(Material.DIAMOND).setName((Component)Component.text((String)rank.getIdentifier())).build();
            }
        });
    }

    private void renderProgressBar(@NotNull RenderContext render, @NotNull Player player, @NotNull RRank rank, @NotNull RDQPlayer rdqPlayer) {
        double progress = this.progressManager.getRankOverallProgress(player, rdqPlayer, rank);
        ArrayList<RRankUpgradeRequirement> requirements = new ArrayList<RRankUpgradeRequirement>(rank.getUpgradeRequirements());
        int completed = 0;
        for (RRankUpgradeRequirement req : requirements) {
            RankRequirementProgressManager.RequirementProgressData data = this.progressManager.getRequirementProgress(player, rdqPlayer, req);
            if (data.getStatus() != RankRequirementProgressManager.RequirementStatus.COMPLETED) continue;
            ++completed;
        }
        this.progressRenderer.renderProgressBar(render, player, progress, completed, requirements.size());
    }

    private void renderOverallProgress(@NotNull RenderContext render, @NotNull Player player, @NotNull RRank rank, @NotNull RDQPlayer rdqPlayer) {
        ((BukkitItemComponentBuilder)render.slot(22)).renderWith(() -> {
            double progress = this.progressManager.getRankOverallProgress(player, rdqPlayer, rank);
            int percentage = (int)Math.round(progress * 100.0);
            ArrayList<RRankUpgradeRequirement> requirements = new ArrayList<RRankUpgradeRequirement>(rank.getUpgradeRequirements());
            int completed = 0;
            for (RRankUpgradeRequirement req : requirements) {
                RankRequirementProgressManager.RequirementProgressData data = this.progressManager.getRequirementProgress(player, rdqPlayer, req);
                if (data.getStatus() != RankRequirementProgressManager.RequirementStatus.COMPLETED) continue;
                ++completed;
            }
            return UnifiedBuilderFactory.item(Material.NETHER_STAR).setName((Component)this.i18n("overall_progress.name", player).build().component()).setLore(this.i18n("overall_progress.lore", player).withPlaceholder("percentage", percentage).withPlaceholder("completed", completed).withPlaceholder("total", requirements.size()).build().children()).setGlowing(percentage >= 100).addItemFlags(ItemFlag.HIDE_ATTRIBUTES).build();
        }).updateOnStateChange(this.allCompleted);
    }

    private void renderRequirementCards(@NotNull RenderContext render, @NotNull Player player, @NotNull RRank rank, @NotNull RDQPlayer rdqPlayer, boolean isPreviewMode) {
        int slot;
        RRankUpgradeRequirement req;
        int i;
        ArrayList<RRankUpgradeRequirement> requirements = new ArrayList<RRankUpgradeRequirement>(rank.getUpgradeRequirements());
        requirements.sort(Comparator.comparingInt(RRankUpgradeRequirement::getDisplayOrder));
        for (i = 0; i < Math.min(4, requirements.size()); ++i) {
            req = (RRankUpgradeRequirement)requirements.get(i);
            slot = REQUIREMENT_SLOTS[i];
            this.renderRequirementCard(render, player, rdqPlayer, req, slot, isPreviewMode);
            if (i >= Math.min(3, requirements.size() - 1)) continue;
            this.renderConnection(render, player, rdqPlayer, req, (RRankUpgradeRequirement)requirements.get(i + 1), CONNECTION_SLOTS[i]);
        }
        if (requirements.size() > 4) {
            for (i = 4; i < Math.min(8, requirements.size()); ++i) {
                req = (RRankUpgradeRequirement)requirements.get(i);
                slot = OVERFLOW_SLOTS[i - 4];
                this.renderRequirementCard(render, player, rdqPlayer, req, slot, isPreviewMode);
                if (i >= Math.min(7, requirements.size() - 1) || i - 4 >= OVERFLOW_CONNECTION_SLOTS.length) continue;
                this.renderConnection(render, player, rdqPlayer, req, (RRankUpgradeRequirement)requirements.get(i + 1), OVERFLOW_CONNECTION_SLOTS[i - 4]);
            }
        }
    }

    private void renderRequirementCard(@NotNull RenderContext render, @NotNull Player player, @NotNull RDQPlayer rdqPlayer, @NotNull RRankUpgradeRequirement requirement, int slot, boolean isPreviewMode) {
        ((BukkitItemComponentBuilder)((BukkitItemComponentBuilder)((BukkitItemComponentBuilder)render.slot(slot)).renderWith(() -> {
            ItemMeta meta;
            boolean shouldGlow;
            RankRequirementProgressManager.RequirementProgressData progress = this.progressManager.getRequirementProgress(player, rdqPlayer, requirement);
            ItemStack card = this.cardRenderer.createRequirementCard(player, requirement, progress);
            if (progress.getStatus() == RankRequirementProgressManager.RequirementStatus.READY_TO_COMPLETE && !(shouldGlow = ((Boolean)this.pulseState.get((StateValueHost)render)).booleanValue()) && (meta = card.getItemMeta()) != null) {
                meta.setEnchantmentGlintOverride(Boolean.valueOf(false));
                card.setItemMeta(meta);
            }
            return card;
        }).updateOnStateChange(this.allCompleted)).updateOnStateChange(this.pulseState)).onClick(ctx -> this.handleRequirementClick((SlotClickContext)ctx, requirement, isPreviewMode));
    }

    private void renderConnection(@NotNull RenderContext render, @NotNull Player player, @NotNull RDQPlayer rdqPlayer, @NotNull RRankUpgradeRequirement current, @NotNull RRankUpgradeRequirement next, int slot) {
        ((BukkitItemComponentBuilder)render.slot(slot)).renderWith(() -> {
            RankRequirementProgressManager.RequirementProgressData currentProgress = this.progressManager.getRequirementProgress(player, rdqPlayer, current);
            Material material = currentProgress.getStatus() == RankRequirementProgressManager.RequirementStatus.COMPLETED ? Material.LIME_STAINED_GLASS_PANE : Material.GRAY_STAINED_GLASS_PANE;
            return UnifiedBuilderFactory.item(material).setName((Component)Component.text((String)" ")).addItemFlags(ItemFlag.HIDE_ATTRIBUTES).build();
        }).updateOnStateChange(this.allCompleted);
    }

    private void renderClaimOrLockedButton(@NotNull RenderContext render, @NotNull Player player, @NotNull RRank rank, @NotNull RDQPlayer rdqPlayer, boolean isPreviewMode) {
        boolean canClaim = this.progressManager.areAllRequirementsCompleted(player, rdqPlayer, rank);
        this.allCompleted.set((Object)canClaim, (StateValueHost)render);
        ((BukkitItemComponentBuilder)((BukkitItemComponentBuilder)render.slot(8)).renderWith(() -> {
            boolean claimable = (Boolean)this.allCompleted.get((StateValueHost)render);
            if (claimable && !isPreviewMode) {
                return UnifiedBuilderFactory.item(Material.EMERALD_BLOCK).setName((Component)this.i18n("claim_button.name", player).build().component()).setLore(this.i18n("claim_button.lore", player).build().children()).setGlowing(true).addItemFlags(ItemFlag.HIDE_ATTRIBUTES).build();
            }
            return UnifiedBuilderFactory.item(Material.BARRIER).setName((Component)this.i18n("claim_button.locked.name", player).build().component()).setLore(this.i18n("claim_button.locked.lore", player).build().children()).addItemFlags(ItemFlag.HIDE_ATTRIBUTES).build();
        }).updateOnStateChange(this.allCompleted)).onClick(ctx -> this.handleClaimClick((SlotClickContext)ctx, rank, rdqPlayer, isPreviewMode));
    }

    private void handleRequirementClick(@NotNull SlotClickContext ctx, @NotNull RRankUpgradeRequirement requirement, boolean isPreviewMode) {
        Player player = ctx.getPlayer();
        RDQPlayer rdqPlayer = (RDQPlayer)this.currentPlayer.get((StateValueHost)ctx);
        if (isPreviewMode) {
            this.i18n("messages.preview_mode", player).includePrefix().build().sendMessage();
            return;
        }
        RankRequirementProgressManager.RequirementProgressData progress = this.progressManager.getRequirementProgress(player, rdqPlayer, requirement);
        if (ctx.getClickOrigin().getClick().isLeftClick()) {
            if (progress.getStatus() == RankRequirementProgressManager.RequirementStatus.READY_TO_COMPLETE) {
                RankRequirementProgressManager.RequirementCompletionResult result = this.progressManager.attemptRequirementCompletion(player, rdqPlayer, requirement);
                if (result.isSuccess()) {
                    this.i18n("messages.requirement_completed", player).includePrefix().build().sendMessage();
                    int clickedSlot = ctx.getClickedSlot();
                    this.playCelebrationAnimation(ctx, clickedSlot);
                    ctx.update();
                    RRank rank = (RRank)this.targetRank.get((StateValueHost)ctx);
                    if (this.progressManager.areAllRequirementsCompleted(player, rdqPlayer, rank)) {
                        this.allCompleted.set((Object)true, (StateValueHost)ctx);
                        this.i18n("messages.all_completed", player).includePrefix().build().sendMessage();
                    }
                }
            } else if (progress.getStatus() != RankRequirementProgressManager.RequirementStatus.COMPLETED) {
                this.i18n("messages.not_ready", player).includePrefix().build().sendMessage();
            }
        } else if (ctx.getClickOrigin().getClick().isRightClick()) {
            if (progress.getStatus() == RankRequirementProgressManager.RequirementStatus.COMPLETED) {
                this.i18n("messages.already_completed", player).includePrefix().build().sendMessage();
                return;
            }
            this.openDetailView(ctx, requirement);
        }
    }

    private void openDetailView(@NotNull SlotClickContext ctx, @NotNull RRankUpgradeRequirement requirement) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("plugin", this.rdq.get((StateValueHost)ctx));
        data.put("player", this.currentPlayer.get((StateValueHost)ctx));
        data.put("rankTree", this.selectedRankTree.get((StateValueHost)ctx));
        data.put("targetRank", this.targetRank.get((StateValueHost)ctx));
        data.put("requirement", requirement);
        data.put("previewMode", this.previewMode.get((StateValueHost)ctx));
        ctx.openForPlayer(RankRequirementDetailView.class, data);
    }

    private void handleClaimClick(@NotNull SlotClickContext ctx, @NotNull RRank rank, @NotNull RDQPlayer rdqPlayer, boolean isPreviewMode) {
        Player player = ctx.getPlayer();
        if (isPreviewMode) {
            this.i18n("messages.preview_mode", player).includePrefix().build().sendMessage();
            return;
        }
        if (!this.progressManager.areAllRequirementsCompleted(player, rdqPlayer, rank)) {
            return;
        }
        try {
            RDQ plugin = (RDQ)this.rdq.get((StateValueHost)ctx);
            RRankTree rankTree = (RRankTree)this.selectedRankTree.get((StateValueHost)ctx);
            this.updatePlayerRank(plugin, rdqPlayer, rankTree, rank);
            this.i18n("messages.rank_claimed", player).withPlaceholder("rank_name", rank.getIdentifier()).includePrefix().build().sendMessage();
            ctx.openForPlayer(RankPathOverview.class, Map.of("plugin", plugin, "player", rdqPlayer, "rankTree", rankTree, "previewMode", false));
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Failed to claim rank", e);
        }
    }

    private void updatePlayerRank(@NotNull RDQ plugin, @NotNull RDQPlayer rdqPlayer, @NotNull RRankTree rankTree, @NotNull RRank newRank) {
        List playerRanks = plugin.getPlayerRankRepository().findAllByAttributes(Map.of("player.uniqueId", rdqPlayer.getUniqueId()));
        RPlayerRank existingRank = playerRanks.stream().filter(r -> Objects.equals(r.getRankTree(), rankTree)).findFirst().orElse(null);
        if (existingRank != null) {
            existingRank.setCurrentRank(newRank);
            plugin.getPlayerRankRepository().update(existingRank);
        } else {
            RPlayerRank newPlayerRank = new RPlayerRank(rdqPlayer, newRank, rankTree);
            plugin.getPlayerRankRepository().create(newPlayerRank);
        }
    }

    private void playCelebrationAnimation(final @NotNull SlotClickContext ctx, int completedSlot) {
        RDQ rdqPlugin = (RDQ)this.rdq.get((StateValueHost)ctx);
        Player player = ctx.getPlayer();
        int[] surroundingOffsets = new int[]{-10, -9, -8, -1, 1, 8, 9, 10};
        final ArrayList<Integer> validSurroundingSlots = new ArrayList<Integer>();
        for (int offset : surroundingOffsets) {
            int targetSlot = completedSlot + offset;
            if (targetSlot < 0 || targetSlot >= 54) continue;
            int completedRow = completedSlot / 9;
            int targetRow = targetSlot / 9;
            if (Math.abs(offset) == 1 && completedRow != targetRow) continue;
            validSurroundingSlots.add(targetSlot);
        }
        final HashMap<Integer, ItemStack> originalItems = new HashMap<Integer, ItemStack>();
        final Inventory inventory = player.getOpenInventory().getTopInventory();
        Iterator iterator = validSurroundingSlots.iterator();
        while (iterator.hasNext()) {
            int slot = (Integer)iterator.next();
            ItemStack original = inventory.getItem(slot);
            if (original == null) continue;
            originalItems.put(slot, original.clone());
        }
        ItemStack celebrationItem = UnifiedBuilderFactory.item(Material.LIME_STAINED_GLASS_PANE).setName((Component)Component.text((String)" ")).addItemFlags(ItemFlag.HIDE_ATTRIBUTES).build();
        Iterator iterator2 = validSurroundingSlots.iterator();
        while (iterator2.hasNext()) {
            int slot = (Integer)iterator2.next();
            inventory.setItem(slot, celebrationItem);
        }
        new BukkitRunnable(this){

            public void run() {
                Iterator iterator = validSurroundingSlots.iterator();
                while (iterator.hasNext()) {
                    int slot = (Integer)iterator.next();
                    ItemStack original = (ItemStack)originalItems.get(slot);
                    inventory.setItem(slot, original);
                }
                ctx.update();
            }
        }.runTaskLater((Plugin)rdqPlugin.getPlugin(), 10L);
    }

    private void startPulseAnimation(final @NotNull RenderContext render, @NotNull RDQ plugin) {
        this.stopPulseAnimation();
        this.pulseTask = new BukkitRunnable(){

            public void run() {
                try {
                    boolean currentState = (Boolean)RankRequirementsJourneyView.this.pulseState.get((StateValueHost)render);
                    RankRequirementsJourneyView.this.pulseState.set((Object)(!currentState ? 1 : 0), (StateValueHost)render);
                }
                catch (Exception e) {
                    this.cancel();
                }
            }
        };
        this.pulseTask.runTaskTimer((Plugin)plugin.getPlugin(), 10L, 10L);
    }

    private void stopPulseAnimation() {
        if (this.pulseTask != null) {
            try {
                this.pulseTask.cancel();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            this.pulseTask = null;
        }
    }

    private void renderErrorState(@NotNull RenderContext render, @NotNull Player player) {
        ((BukkitItemComponentBuilder)render.slot(22)).renderWith(() -> UnifiedBuilderFactory.item(Material.BARRIER).setName((Component)Component.text((String)"Error loading requirements")).build());
    }
}

